# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"
require "zlib"
require "stringio"

require "rast_test"
require "rast/filter"
require "rast/database-generatable"

module Rast
  class ApplicationGzipTest < Test::Unit::TestCase
    include DatabaseGeneratable

    def test_invoke
      invoke_test_simple
    end

    def invoke_test_simple
      create_options = {
        "encoding" => "utf8",
        "preserve_text" => true,
        "properties" => [],
      }
      db_name = generate_db_name
      LocalDB.create(db_name, create_options)

      LocalDB.open(db_name, Rast::DB::RDWR) do |db|
        doc = db.create_document
        chain = FilterChain.new(doc)
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "utf-8.txt.gz")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          chain.invoke(brigade, "application/x-gzip")
          doc.commit
        end

        doc = db.create_document
        chain = FilterChain.new(doc)
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "utf-8.txt.gz")
        File.open(filename) do |f|
          brigade.insert_tail(FileBucket.new(f))
          brigade.insert_tail(EOSBucket.new)
          empty_magic_filename = File.join(MakeVariable::TOP_SRCDIR, "tests",
                                           "data", "empty-magic")
          TestUtility.protect_env({"MAGIC" => empty_magic_filename}) do
            chain.invoke(brigade, nil, filename)
          end
          doc.commit
        end
      end
      LocalDB.open(db_name) do |db|
        assert_equal("gzip テスト これは gzip ファイルです ", db.get_text(1))
        assert_equal("gzip テスト これは gzip ファイルです ", db.get_text(2))
      end
    end
  end
end
