# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test-utility"

module Rast
  module DatabaseGeneratable
    def setup
      name = self.class.name.gsub(/:+/, "-").downcase
      @db_dir = TestUtility.mkdtemp(name)
      @db_name_count = 0
    end

    def teardown
      TestUtility.rm_rf(@db_dir)
    end

    private

    def generate_db_name
      @db_name_count += 1
      return File.expand_path(@db_name_count.to_s, @db_dir)
    end
  end
end
