/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include "rast/config.h"
#include "rast/string.h"

rast_string_t *
rast_string_create(apr_pool_t *pool, const char *s, int nbytes, int capacity)
{
    rast_string_t *string;

    string = (rast_string_t *) apr_palloc(pool, sizeof(rast_string_t));
    string->pool = pool;
    apr_pool_create(&string->sub_pool, pool);
    if (capacity > nbytes) {
        string->capacity = capacity;
    }
    else {
        string->capacity = nbytes + 1;
    }
    string->ptr = (char *) apr_palloc(string->sub_pool, string->capacity);
    memcpy(string->ptr, s, nbytes);
    string->ptr[nbytes] = '\0';
    string->len = nbytes;
    return string;
}

static void
ensure_capacity(rast_string_t *string, int min_capacity)
{
    if (string->capacity < min_capacity) {
        int new_capacity;
        apr_pool_t *new_pool;
        char *new_ptr;

        new_capacity = string->capacity * 2;
        if (new_capacity < min_capacity) {
            new_capacity = min_capacity;
        }
        apr_pool_create(&new_pool, string->pool);
        new_ptr = (char *) apr_palloc(new_pool, new_capacity);
        memcpy(new_ptr, string->ptr, string->len);
        string->ptr = new_ptr;
        string->capacity = new_capacity;
        apr_pool_destroy(string->sub_pool);
        string->sub_pool = new_pool;
    }
}

void
rast_string_append(rast_string_t *string, const char *s, int nbytes)
{
    ensure_capacity(string, string->len + nbytes + 1);
    memcpy(string->ptr + string->len, s, nbytes);
    string->len += nbytes;
    string->ptr[string->len] = '\0';
}

/* vim: set filetype=c sw=4 expandtab : */
