/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_STRING_H
#define RAST_STRING_H

#include <apr_pools.h>

typedef struct {
    apr_pool_t *pool;
    apr_pool_t *sub_pool;
    char *ptr;
    int len;
    int capacity;
} rast_string_t;

rast_string_t *rast_string_create(apr_pool_t *pool,
                                  const char *s, int nbytes, int capacity);
void rast_string_append(rast_string_t *string, const char *s, int nbytes);

#endif

/* vim: set filetype=c sw=4 expandtab : */
