/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#ifndef RAST_MERGER_H
#define RAST_MERGER_H

/**
 * @file merger.h merger
 */

#include "rast/db.h"
#include "rast/macros.h"

RAST_EXTERN_C_BEGIN

/**
 * @defgroup merger merger
 * @{
 */

typedef struct {
    /** The super class instance */
    rast_db_t base;

    /** The encoding of the database */
    const char *encoding;
    /** The number of databases */
    int num_merged_dbs;
    /** Some databases for merging */
    rast_db_t **merged_dbs;
    const rast_property_t *properties;
    int num_properties;
} rast_merger_t;

/**
 * Merge some opened databases.
 * @param db The database opened
 * @param merge_dbs Some databases for merging.
 * @param num_merge_dbs The number of databases.
 * @param pool The pool to allocate the memory out of
 * @return RAST_OK if succeeded, error otherwise
 */
rast_error_t *rast_merger_open(rast_db_t **db,
                               rast_db_t **merge_dbs, int num_merge_dbs,
                               apr_pool_t *pool);

/**
 * Please use rast_db_close().
 * @see rast_db_close()
 */
rast_error_t *rast_merger_close(rast_db_t *db);

/**
 * Please use rast_db_search().
 * @see rast_db_search()
 */
rast_error_t *rast_merger_search(rast_db_t *db,
                                 const char *query,
                                 rast_search_option_t *options,
                                 rast_result_t **result, apr_pool_t *pool);

/**
 * Please use rast_db_encoding().
 * @see rast_db_encoding()
 */
const char *rast_merger_encoding(rast_db_t *db);

/**
 * Please use rast_db_properties().
 * @see rast_db_properties()
 */
const rast_property_t *rast_merger_properties(rast_db_t *db,
                                              int *num_properties);

/** @} */

RAST_EXTERN_C_END

#endif
