/* 
 * Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
 *
 * This file is part of Rast.
 * See the file COPYING for redistribution information.
 *
 */

#include <stdio.h>
#include <stdlib.h>

#include <apr_pools.h>

#include "rast/db.h"

static int memory_error(int retcode);
static void print_error(rast_error_t *error);

rast_property_t properties[] = {
    {
        "filename",
        RAST_TYPE_STRING,
        RAST_PROPERTY_FLAG_SEARCH | RAST_PROPERTY_FLAG_UNIQUE
    },
    {
        "title",
        RAST_TYPE_STRING,
        RAST_PROPERTY_FLAG_TEXT_SEARCH | RAST_PROPERTY_FLAG_FULL_TEXT_SEARCH
    },
    {
        "last_modified",
        RAST_TYPE_DATE,
        RAST_PROPERTY_FLAG_SEARCH
    },
    {
        "filesize",
        RAST_TYPE_UINT,
        RAST_PROPERTY_FLAG_SEARCH
    },
};

int
main(int argc, char **argv)
{
    apr_pool_t *pool;
    char *dbpath;
    rast_db_create_option_t *options;
    rast_error_t *error;

    if (argc < 2) {
        fprintf(stderr, "usage: %s <db>\n", argv[0]);
        return 1;
    }
    dbpath = argv[1];

    apr_initialize();
    atexit(apr_terminate);
    error = rast_initialize();
    if (error != RAST_OK) {
        print_error(error);
        return 1;
    }
    atexit(rast_finalize);

    apr_pool_create_ex(&pool, NULL, memory_error, NULL);

    options = rast_db_create_option_create(pool);
    options->preserve_text = 1;
    options->properties = properties;
    options->num_properties = 4;

    error = rast_db_create(dbpath, options, pool);
    if (error != RAST_OK) {
        print_error(error);
        return 1;
    }

    return 0;
}

static int
memory_error(int retcode)
{
    abort();
    return -1;  /* prevent compiler warnings */
}

static void
print_error(rast_error_t *error)
{
#ifdef RAST_DEBUG
    fprintf(stderr, "%s:%d: %s\n", error->file, error->line, error->message);
#else
    fprintf(stderr, "error: %s\n", error->message);
#endif
    rast_error_destroy(error);
}

/* vim: set filetype=c sw=4 expandtab : */
