/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef WORDSRESERVATION_H
#define WORDSRESERVATION_H

#include <QtGui/QDialog>
#include <QtCore/QFile>


class QString;
//class QFile;

namespace Ui {
    class WordsReservation;
}

class WordsReservation : public QDialog
{
    Q_OBJECT

public:
    explicit WordsReservation(QWidget *parent = 0);
    ~WordsReservation();

    QString getProcessedText(const QString &rawtext);
    QString getResultText(const QString &res) const;

protected:
    void changeEvent(QEvent *);

public slots:
    void addWord(const QString &word);
//    void setStorageFile(const QString &file);
    void setCaseSensetive(bool b = true);
    void showReservator();

private slots:
    void addReservedSequence(const QString &word); // for gui
    void loadSequences();
    void saveSequences();
    void addSequence();
    void deleteSequence();
    void clearSequences();

    void updateList();

    void acceptChanges();
//    void rejectChanges();
private:
    Ui::WordsReservation *ui;
    QString m_source_text, m_translated_text;
    QStringList m_reserved_sequences;
    QFile m_sequences_file;
    bool m_flag_case_sensetive, m_flag_have_changes;
};

#endif // WORDSRESERVATION_H
