/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include <QtNetwork/QNetworkProxy>

namespace Ui {
    class Settings;
}

//classs

class Settings : public QDialog
{
    Q_OBJECT

public:
    enum NotificationMode
    {
        ShowToolTip = 0, ShowTrayMsg, ShowWindow, JustTranslate
    };

    enum TranslationTrigger
    {
        SelectionBuffer = 0, HotkeyPress, ModifierPress, None
    };

    explicit Settings(QWidget *parent = 0);
    ~Settings();

    // Getters for "Translation" section
    bool getAutoTranslate() const;
    bool getCopyToClipboard() const;
    bool getAutoDetectLanguage() const;
    bool getSimplifyResult() const;
    // Getters for "appearance" section
    bool getShowInTray() const;
    bool getShowToolbar() const;
    QFont getFont()/* const*/;
    QString getCurrentLanguage() const;
    // Getters for "Notifications" section
    Settings::NotificationMode getNotificationMode() const;
    Settings::TranslationTrigger getTranslationTrigger() const;
    QString getTranslationHotkey() const;
    Qt::KeyboardModifier getTranslationModifier() const;
    // Getters for "Tools" section
    bool getHistoryEnabled() const;
    bool getReservationEnabled() const;
    bool getReservationCaseSensetive() const;
    bool getAutoSpeachEnabled() const;
    QString getSpeachCmd() const;
    // Getters for "Proxy" section
    bool getProxyEnabled() const;
    QNetworkProxy getProxy();
    QString getLanguage() const;
public slots:
    // External setters:
    void setAutoTranslateChecked(bool b);
    void setScanBufferChecked(bool b);
    void setAutoDetectChecked(bool b);
    void setTranslationModifier(Qt::KeyboardModifier);
protected:
    void changeEvent(QEvent *);
    bool eventFilter(QObject *, QEvent *);
private:
    void loadLanguages();
    /*!
    Set proxy type (for gui). Some proxy type no need,
    we can't use QNetworkProxy enum;
    */
    void setProxyType(const QNetworkProxy::ProxyType type);
    //! Return proxyType bu gui item (see previous)
    QNetworkProxy::ProxyType getProxyType();

    QNetworkProxy::ProxyType m_proxy_type;
    NotificationMode m_notification_mode;
    TranslationTrigger m_translation_trigger;
    Qt::KeyboardModifier m_translation_modifier;
    QStringList m_languages_list;
    Ui::Settings *ui;
private slots:
    void saveSettings();
    void readSettings();
    void whenTranslationTriggerChanged(int i);
    void slotModifierChanged(const QString &);
signals:
    void settingsChanged();
};

#endif // SETTINGS_H
