/*!
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 *    Author: flareguner
 *    E-Mail: flareguner@gmail.com
 *    Years: 2010-2010
 */

#ifndef LOGGER_H
#define LOGGER_H

#include <QtGui/QDialog>
#include <QtCore/QDir>
#include <QtCore/QFile>
#include <QtCore/QList>


namespace Ui {
    class Logger;
}

class QString;
class QTextDocument;

class Logger : public QDialog
{
    Q_OBJECT
public:
    explicit Logger(QWidget *parent = 0);
    ~Logger();
protected:
    void changeEvent(QEvent *);
public slots:
    void showLogs();
    void log(const QString &text);
private slots:
    void loadLogs();
    void showLog(const int i);
    void findText();
private:
    QDir m_logging_dir;
    Ui::Logger *ui;
};

#endif // LOGGER_H
