/****************************************************************************
** SelectionObject is being used in MenuPreview for multiple selections
**
**   Created : Sun Mar 23 21:45:00 2006
**        by : Varol Okan using xemacs
** Copyright : (c) Varol Okan
** License   : GPL v 2.0
**
**
****************************************************************************/

#ifndef SELECTIONOBJECT_H
#define SELECTIONOBJECT_H

#include "objectcollection.h"

class QPainter;
class ShadowObject;

class SelectionObject : public ObjectCollection
{
  Q_OBJECT

public:
  // Public functions needed for the abstract base class.
  SelectionObject         ( QWidget *pParent=0 );
  virtual ~SelectionObject                   ( );

  void resetObjectStates                     ( );
  bool find                   ( MenuObject   * );
  bool mouseOver             ( const QPoint  & );
  void setMoveState                     ( bool );
  void setCurrentMousePos           ( QPoint & );
  virtual bool mousePressEvent ( QMouseEvent * );
  virtual bool createContextMenu      ( QPoint );

  virtual void setActive        ( bool );
  virtual void drawContents     ( QPainter   * );
  virtual void drawSelected     ( QPainter   * );
  virtual void setShadow        ( MenuObject * );
  virtual MenuObject* shadow    (              );
  virtual void setRect          ( QRect &      );
  virtual QRect &rect           ( );

  void clearShadows   ( );
  void drawShadows    ( QPainter * );
  void updateShadows  ( ShadowObject *, bool );

signals:
  void signalAlignSelection ( );

protected slots:
  virtual void slotAlign  ( );
  virtual void slotDelete ( );
  virtual void slotCut    ( );

private:
  QValueList<ShadowObject *> m_listOfShadows;
};

#endif	// SELECTIONOBJECT_H

