/****************************************************************************
3** Interface to the GUI.
**
**   Created : Sun Dec 14 12:09:08 2003
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef QDVDAUTHOR_H
#define QDVDAUTHOR_H


class QDomNode;
class QDomElement;
class QTranslator;
class QPopupMenu;
class QTimer;
class QListBox;
class QPopupMenu;

#include "formmain.h"
#include "xml_slideshow.h"
#include "plugins/interface.h"

class ButtonObject;
class ColorToolBar;
class SourceToolBar;
class StructureToolBar;
class SourceFileEntry;
class SourceFileInfo;
class Subtitles;
class SubtitlesGui;
class StructureItem;
class DVDMenu;
class MediaInterface;
class MediaInfo;
class uiDialogRenderPreview;
class DialogExecute;
class DialogLibrary;
class TemplateWizard;
class CXmlDVDAuthor;
class CXmlSpumux;
class UndoBuffer;
class DialogUndoStack;
class ButtonTransition;
namespace DVDLayout { class Gui;    };
namespace Render    { class Client; };

#define DVDAUTHOR_XML "dvdauthor.xml"

#include "rgba.h"
#include "utils.h"
#include "dragndropcontainer.h"

class QDVDAuthor : public CFormMain
{
	Q_OBJECT

public:
	enum enTabs { TabMainMenu=0, TabSubMenu, TabSubtitles, TabDVDLayout, TabDVDAuthorXml };

	QDVDAuthor ( );
	virtual ~QDVDAuthor ( );

protected:
	virtual void customEvent ( QCustomEvent * );

public slots:
	virtual void fileNew      ( );
	virtual void fileWizard   ( );
	virtual void fileOpen     ( );
	virtual void fileSave     ( );
	virtual void fileSave     ( QString, bool b=false );
	virtual void fileSaveAs   ( );
	virtual void fileExit     ( );
	virtual void editUndo     ( );
	virtual void editRedo     ( );
	virtual void editCut      ( );
	virtual void editCopy     ( );
	virtual void editPaste    ( );
	virtual void editFind     ( );
	virtual void helpIndex    ( );
	virtual void helpContents ( );
	virtual void helpGuide    ( );
	virtual void helpAbout    ( );

	virtual void polish                          ( );
	virtual void slotAutosave                    ( );
	virtual void slotOneClickDVD                 ( );
	virtual void slotActivatePlugin              ( );
	virtual void slotActivatePlugin         (  int );
	virtual void slotPluginCallback  ( int, QString, QString );
	virtual void slotNewMenuResponse ( int, QString, QString );
	virtual void slotNewSource       ( Plugin::SourceGroup * );
	virtual void slotEnableTabs             (  int );
	virtual void slotChangeLanguage         (  int );
	virtual void slotVisibleRegion          ( bool );
	virtual void slotSetup                       ( );
	virtual void slotVersions                    ( );
	virtual void slotDialogTemp                  ( );
	virtual void slotTemplateDownload            ( );
	virtual void slotExportDVDAuthorXML          ( );
	virtual void slotEditAddMovie                ( );
	virtual void slotAddFromLibrary              ( );
	virtual void slotEditAddSlideshow            ( );
	virtual void slotSelectZone                  ( );
	virtual void slotZone                   ( QAction * );
	virtual void slotStructureClicked ( StructureItem * );
	virtual void slotGenerateMasks               ( );
	virtual void slotCreateDVD                   ( );
	virtual void slotAddSubMenu                  ( );
	virtual void slotAddFiles                    ( );
	virtual void slotAddDirectory                ( );
	virtual void slotAddFromTemplate             ( );
	virtual void slotFeedback                    ( );
	virtual void slotTabChanged        ( QWidget * );
	virtual void slotRemoveCurrentSubMenu        ( );
	virtual void slotDeleteTemplateWizard        ( );
	virtual void slotRenameCurrentSubMenu        ( );
	virtual void slotCloneCurrentSubMenu         ( );
	virtual void slotUndoStack                   ( );
	virtual void slotUpdateStructure             ( );
	virtual void slotUpdateDVDLayout             ( );
	virtual void slotDeleteTempOlderThan         ( );
	virtual void slotCreateXml   ( const QString & );
	virtual void slotUpdateMenuBar               ( );
	virtual void slotChangeHistory           ( int );
	virtual void slotRenderMenu          ( QString );
	virtual void slotChangeStyle ( const QString & );
	virtual void slotCalculateSize               ( );
	virtual void slotImportKino                  ( );
	virtual void slotImportDvdauthor             ( );
	virtual void slotConvert                     ( );
	virtual void slotConvertCurrentMenu     ( bool );
	virtual void slotAboutToShowMenu             ( );

signals:
	void signalVisibleRegion (bool);

public:
	void fileOpen             ( QString );
	void postInit             ( bool );
	void addDVDMenu           ( DVDMenu *, bool b=false );
	void returnFromRenderMenu ( );
	bool checkForNewProject   ( );
	void showUndoStack        ( );
	void updateUndoStack      ( );
	bool tabVisible           ( enTabs );
	bool pleaseWait           ( );

	int  getFreeSourceSlot                                ( );
	void addDroppedSource                         ( QString );
	void addMovieList      ( QStringList &, QString *p=NULL );
	int  sourceFileCount                                  ( );
	SourceFileEntry *sourceFileEntry                 ( uint );
	SourceFileEntry *getSourceEntryByDisplayName( QString & );
	void appendSourceFileEntry          ( SourceFileEntry * );
	void removeSourceFileEntry          ( SourceFileEntry * );  // called to remove the SourceFileEntry
	void removedSourceEntry             ( SourceFileEntry * );  // called after entry has been removed from SourceToolBar
	void updateSourceFileInfo           ( SourceFileInfo  * );
	void editSourceFileInfo             ( SourceFileInfo  * );
	void updateDVDLayout                ( SourceFileEntry * );
	void replaceMenuName             ( DVDMenu *, QString & );
	void replaceSourceDisplayName    ( QString &, QString & );
	bool isSourceEntryUsed                      ( QString & );
	void addSound                           ( QStringList & );
	void setColor                              ( uint, Rgba );
	void updateStatusColor                                ( ); // updates the SourceToolBar color's
	MediaInfo  *getMediaInfo                              ( );
	UndoBuffer *getUndoBuffer                             ( );
	DragNDropContainer *getDragNDropContainer             ( );

	DVDMenu *findMenuFromSourceFileEntry( SourceFileEntry * );
	DVDMenu *getCurrentSubMenu                            ( );
	DVDMenu *getSubMenuByName                     ( QString );
	DVDMenu *getVMGMenu                                   ( );
	QValueList<DVDMenu *> &getSubMenus                    ( );
	void    importDvdauthor                       (  void * );
	void    createContextMenu ( SourceFileEntry *, QPoint & );

	QString getUniqueMenuTitle  ( QString, int i=0, DVDMenu *p=NULL );
	QString getVidFilter        ( );
	QString getImageFilter      ( );
	QString getMovieFilter      ( );
	QString getSoundFilter      ( );

private: // Private functions ...
	void initMe                 ( );
	bool cleanUp                ( );
	void LoadIni                ( );
	void SaveIni                ( );
	void newWizard              ( );
	void setRegionalZone        ( );
	void buildHistoryEntries    ( );
	void updateHistoryPix       ( );
	void initTabs               ( );
	void initPlugins            (   );
	void initLanguages          (     );
	void initStyles             (       );
	void initDVDLayoutTab       (         );
	void initSubtitlesTab       (           );
	void addHistory             ( QString     );
	bool writeProjectFile       ( QDomElement & );
	void setAutosave            ( bool b=false    );
	bool readProjectFile        ( QDomNode &, float & );
	bool renderSubtitles        ( SourceFileInfo *, bool b=false );
	bool buildFromDvdauthorXML  ( CXmlDVDAuthor *, QValueList<CXmlSpumux *> & );
        void recoverKB              ( CXmlSlideshow ::effect_struct *, QString );
	void createTempDirStructure ( );
	void createDvdauthorXml     ( );
	void createSubtitlesXml     ( );
	void createTransitionsXml   ( );
	void createMenuXml          ( );
	void createDVD              ( );
	bool checkHealth            ( );
	void engageCreateDVD        ( bool ); // Called to put QDVDAuthor in wait mode for slideshows to finish
	void replaceTempPaths       ( QString );
	QString  getTempFile        ( QString );
	QWidget *getTabWidget       ( enTabs,    int i=0 );
	unsigned long getAudioSize  ( SourceFileInfo   * );
	void eventEntry             ( Render::Client   * );
	void eventTrans             ( Render::Client   * );
	bool buttonTransitionExists ( ButtonTransition * );

private:
	bool    m_bVisibleRegion;

	DVDMenu *m_pVMGMenu;
	QValueList<DVDMenu *>   m_listDVDMenus;
	DragNDropContainer      m_dragNDropContainer;
	QStringList             m_listHistory;
	QValueList<QPixmap *>   m_listHistoryPix;
	int                     m_iMaxHistoryFiles;
	int                     m_iAutosave;	// Autosave every x seconds ...
	QString                 m_qsStyle;
	QTimer                 *m_pTimerAutosave;
	bool                    m_bAutosaving;
	bool                    m_bCreateDVDAfterSlideshows;
	bool                    m_bWait;

	Plugin::Interface      *m_pPluginInterface;
	ColorToolBar           *m_pColorToolbar;
	SourceToolBar          *m_pSourceToolbar;
	StructureToolBar       *m_pStructureToolbar;
	DVDLayout::Gui         *m_pDVDLayoutGui;
	SubtitlesGui           *m_pSubtitlesGui;
	QPopupMenu             *m_pMenuHistory;
	bool                    m_bModified;
	QTranslator            *m_pTranslator;
	QPopupMenu             *m_pLanguagePopup;
	QPopupMenu             *m_pPluginsPopup;
	QPopupMenu             *m_pTabsPopup;
	QPopupMenu             *m_pStylesPopup;
	DialogExecute          *m_pDialogExecute;
	DialogLibrary          *m_pDialogLibrary;
	TemplateWizard         *m_pTemplateWizard;
	DialogUndoStack        *m_pUndoStackDialog;

	QToolBar *m_pToolbar;
	QAction  *m_pActionToolbarNew;
	QAction  *m_pActionToolbarWizard;
	QAction  *m_pActionToolbarOpen;
	QAction  *m_pActionToolbarSave;
	QAction  *m_pActionToolbarSaveAs;
	QAction  *m_pActionToolbarExit;
	QWidget  *m_mainTabBuffer[3];  // DVDLayout/Subtitles/XMLOut
};

#endif // QDVDAUTHOR_H
