#!/bin/bash
#
# Extract random images from fantom-xp.com
#
# -i            == info. IP, plus 0, 1, or 2 selections
# -m            == media type, must be "img" or "vid"
# -l            == List all categories
# -c <category> == list themes of the Category ( sub-category )
# -t <theme>    == link to web page
# -n <link>     == Get the max # of pages
# -r <targetFile> <category> <theme> == get random image off the page
#
##################################################


if [ "x$1" == "x-m" ]; then 
  echo "img"
  exit
fi

if [ "x$1" == "x-i" ]; then
cat << EOF
http://www.fantom-xp.com
Category
Theme
EOF
fi;

# They follow different URL buildng rules.
#Home
#Most Popular

if [ "x$1" == "x-l" ]; then
cat << EOF
Animal Life
Computers
Backgrounds
Motors
Celebrities
EOF
fi;

home ( )
{
cat << EOF
Home
Top Wallpapers
New Wallpapers
EOF
}

homeLink ( )
{
  case $1 in
  "Home" )           echo "http://www.fantom-xp.com/wp.html" ;;
  "Top Wallpapers" ) echo "http://www.fantom-xp.com/wp__0.html" ;;
  * )                echo "http://www.fantom-xp.com/wp__new.html" ;;
  esac
}

mostPopular ( )
{
cat << EOF
Most Popular
Desktop Backgrounds
HD Wallpapers
iPad Resolution
Wallpaper 1440
Full HD 1080p
2560x1600 Wallpaper
EOF
}

mostPopularLink ( )
{
  case $1 in
  "Most Popular" )        echo "http://www.fantom-xp.com/en__0.html" ;;
  "Desktop Backgrounds" ) echo "http://www.fantom-xp.com/index.php?lang=wp&search=desktop+backgrounds" ;;
  "HD Wallpapers" )       echo "http://www.fantom-xp.com/index.php?lang=wp&search=1680x1050" ;;
  "iPad Resolution" )     echo "http://www.fantom-xp.com/index.php?lang=wp&search=1024x768" ;;
  "Wallpaper 1440" )      echo "http://www.fantom-xp.com/index.php?lang=wp&search=1440" ;;
  "Full HD 1080p" )       echo "http://www.fantom-xp.com/index.php?lang=wp&search=1920x1080" ;;
  * )                     echo "http://www.fantom-xp.com/index.php?lang=wp&search=2560x1600" ;;
  esac
}

# "Animal Life" has different URL building rules
animalLife ( )
{
cat << EOF
All Animals
Underwater
Kitten-Cat-Big Cats
Dogs-Puppy dogs
Nature
Flowers
Buterfly-Insects
EOF
}

animalLifeLink ( )
{
  case $1 in 
  "Animal Life" )         echo "http://www.fantom-xp.com/wp_6.html" ;;
  "All Animals" )         echo "http://www.fantom-xp.com/wp_15.html" ;;
  "Underwater" )          echo "http://www.fantom-xp.com/wp_11.html" ;;
  "Kitten-Cat-Big Cats" ) echo "http://www.fantom-xp.com/wp_20.html" ;;
  "Dogs-Puppy dogs" )     echo "http://www.fantom-xp.com/wp_25.html" ;;
  "Nature" )              echo "http://www.fantom-xp.com/wp_42.html" ;;
  "Flowers" )             echo "http://www.fantom-xp.com/wp_28.html" ;;
  * )                     echo "http://www.fantom-xp.com/wp_26.html" ;;
  esac;
}

# "Computers" has different URL building rules
computers ( )
{
cat << EOF
Apple
Laptops
WindowsXP
Windows VIsta
Windows 7
EOF
}

computersLink ( )
{
  case $1 in
  "Computers" )     echo "http://www.fantom-xp.com/wp_8.html" ;;
  "Apple" )         echo "http://www.fantom-xp.com/wp_32.html" ;;
  "Laptops" )       echo "http://www.fantom-xp.com/wp_35.html" ;;
  "WindowsXP" )     echo "http://www.fantom-xp.com/wp_19.html" ;;
  "Windows VIsta" ) echo "http://www.fantom-xp.com/wp_29.html" ;;
  * )               echo "http://www.fantom-xp.com/wp_23.html" ;;
  esac
}

# "Backgrounds" has different URL building rules
backgrounds ( )
{
cat << EOF
3D Graphics
Humor
Games
Cartoons
Misc
Holliday
Foods
Brands
Space
Sport
Travels
EOF
}

backgroundsLink ( )
{
  case $1 in
  "Backgrounds" ) echo "http://www.fantom-xp.com/wp_3.html" ;;
  "3D Graphics" ) echo "http://www.fantom-xp.com/wp_12.html" ;;
  "Humor" )       echo "http://www.fantom-xp.com/wp_33.html" ;;
  "Games" )       echo "http://www.fantom-xp.com/wp_18.html" ;;
  "Cartoons" )    echo "http://www.fantom-xp.com/wp_16.html" ;;
  "Misc" )        echo "http://www.fantom-xp.com/wp_21.html" ;;
  "Holliday" )    echo "http://www.fantom-xp.com/wp_22.html" ;;
  "Foods" )       echo "http://www.fantom-xp.com/wp_30.html" ;;
  "Brands" )      echo "http://www.fantom-xp.com/wp_31.html" ;;
  "Space" )       echo "http://www.fantom-xp.com/wp_49.html" ;;
  "Sport" )       echo "http://www.fantom-xp.com/wp_54.html" ;;
  * )             echo "http://www.fantom-xp.com/wp_63.html" ;;
  esac
}

# "Motors" has different URL building rules
motors ( )
{
cat << EOF
Aircraft
Cars
Military
Bikes
EOF
}

motorsLink ( )
{
  case $1 in
  "Motors" )   echo "http://www.fantom-xp.com/wp_5.html" ;;
  "Aircraft" ) echo "http://www.fantom-xp.com/wp_14.html" ;;
  "Cars" )     echo "http://www.fantom-xp.com/wp_17.html" ;;
  "Military" ) echo "http://www.fantom-xp.com/wp_24.html" ;;
  * )          echo "http://www.fantom-xp.com/wp_27.html" ;;
  esac
}

# "Celebrities" has different URL building rules
celebrities ( )
{
cat << EOF
Movies
Female
Male
Music
EOF
}

celebritiesLink ( )
{
  case $1 in
  "Celibrities" ) echo "http://www.fantom-xp.com/wp_7.html" ;;
  "Movies" )      echo "http://www.fantom-xp.com/wp_36.html" ;;
  "Female" )      echo "http://www.fantom-xp.com/wp_75.html" ;;
  "Male" )        echo "http://www.fantom-xp.com/wp_72.html" ;;
  * )             echo "http://www.fantom-xp.com/wp_84.html" ;;
  esac
}

getMaxSubpages ( )
{
  wget --user-agent=MSIE -qO - "$1" | grep "Next &gt;" | sed -e "s,Next.*,," -e "s,<[^>]*>,,g" | awk -F"." '{ print $4;}' | sed 's,[A-Za-z&;.,],,g'
}

getRandomLinkFrom ( )
{
  link=$1
#  array=`cat /tmp/wp_32_4.html | grep "Download Wallpaper" | awk -F'href=\"' '{ printf ("%s\n%s\n%s\n", $2, $4, $6 )  }' | sed 's,\".*,,g'`
  array=`wget --user-agent=MSIE -qO - "$link" | grep "Download Wallpaper" | awk -F'href=\"' '{ printf ("%s\n%s\n%s\n", $2, $4, $6 )  }' | sed 's,\".*,,g'`

  count=0
  for link in $array; do
    count=$(( count + 1 ))
  done
  rand=$(( RANDOM%count ))

  for link in $array; do
    if [ $rand -eq 0 ]; then
      echo $link
      return
    fi
    rand=$(( rand - 1 ))
  done

# cat wp_32_4.html | grep "Download Wallpaper" | awk -F'href=\"' '{ printf ("%s\n%s\n%s\n", $2, $4, $6 )  }' | sed 's,\".*,,g'
#will generate 
#http://www.fantom-xp.com/wp_32__Apple_iPad_pattern.html
#http://www.fantom-xp.com/wp_32__Apple_iPod_simple_blue.html
#http://www.fantom-xp.com/wp_32__Apple_iMac_Desktop.html
#http://www.fantom-xp.com/wp_32__iPed_digital_backgrounds.html
#http://www.fantom-xp.com/wp_32__Mac_style_desktop_background.html
#http://www.fantom-xp.com/wp_32__iPhone_Art_background.html
#http://www.fantom-xp.com/wp_32__Snow_Leopard_Mac_OS.html
#http://www.fantom-xp.com/wp_32__Apple_Orange_juice.html
#http://www.fantom-xp.com/wp_32__Mac_OS_secret_opportunities.html
#http://www.fantom-xp.com/wp_32__Parallels_Desktop_for_Mac.html
#http://www.fantom-xp.com/wp_32__Think_different_Apple_background.html
#http://www.fantom-xp.com/wp_32__Rainbow_Apple.html
#http://www.fantom-xp.com/wp_32__Apple_iTunes_Podcasts_Lost.html
#http://www.fantom-xp.com/wp_32__Trailblazer_New_Apple_Designer.html
#http://www.fantom-xp.com/wp_32__Winter_Solstice_iMac.html
}

getRandomFrom ( )
{
  link=`getRandomLinkFrom $1`
  # $link is something linke http://www.fantom-xp.com/wp_32__Apple_iMac_Desktop.html
  pic=`wget --user-agent=MSIE -qO - "$link" | grep " From " | sed -e 's,.*.<a href=\",,g' -e 's,\".*,,g'`
#  pic=`cat /tmp/wp_32__Apple_iMac_Desktop.html | grep " From " | sed -e 's,.*.<a href=\",,g' -e 's,\".*,,g'`
  # pic is /wallpapers/32/Apple_iMac_Desktop.jpg
  if [ ${pic:0:1} == "/" ]; then
    pic=http://www.fantom-xp.com$pic
  fi
  echo $pic

# cat wp_32__Apple_iMac_Desktop.html | grep " From " | sed -e 's,.*.<a href=\",,g' -e 's,\".*,,g'
# will generate :
# /wallpapers/32/Apple_iMac_Desktop.jpg
}


getMainLink ( )
{
  case  "$1" in
  "Home" )         homeLink        "$2" ;;
  "Most Popular" ) mostPopularLink "$2" ;;
  "Animal Life" )  animalLifeLink  "$2" ;;
  "Computers" )    computersLink   "$2" ;;
  "Backgrounds" )  backgroundsLink "$2" ;;
  "Motors" )       motorsLink      "$2" ;;
  "Celebrities" )  celebritiesLink "$2" ;;
  esac;
}

if [ $# -lt 3 ]; then 
  if [ "x$1" == "x-c" ]; then
    case  "$2" in
    "Home" )         home        ;;
    "Most Popular" ) mostPopular ;;
    "Animal Life" )  animalLife  ;;
    "Computers" )    computers   ;;
    "Backgrounds" )  backgrounds ;;
    "Motors" )       motors      ;;
    "Celebrities" )  celebrities ;;
    esac;
  fi;
else
  if [ "x$1" == "x-t" ]; then
    getMainLink "$2" "$3"
  fi;
fi;


#
# http://www.fantom-xp.com/wp_33.html == main page for Backgrounds/Humor
# http://www.fantom-xp.com/wp_33_4.html == Page 5 of selection
# fantom-xp.sh -r Computers Apple
if [ $# -eq 4 ]; then
  if [ "x$1" == "x-r" ]; then
    target="$2"
    category="$3"
    theme="$4"
    link=
    mainLink=`getMainLink "$category" "$theme"`
    max=`getMaxSubpages "$mainLink"`

    if [ $max -gt 1 ]; then
      max=$(( max - 1 ))
      rand=$(( $RANDOM%$max ))
      link=`echo $mainLink | sed 's,.html,,'`
      link=$link"_$rand"".html"
    else
      link=$mainLink
    fi

    PICURL=`getRandomFrom "$link"`
    wget --user-agent=MSIE $PICURL -O "$target"
  fi
fi

exit

if [ "x$1" == "x-n" ]; then
  # This function filters out how many sub-pages this page holds
  # E.g $2 = http://www.fantom-xp.com/wp.html
  getMaxSubpages "$2"
fi;



