/****************************************************************************
** Interface to the GUI.
**
**   Created : Sun Dec 14 12:09:08 2003
**        by : Varol Okan using kate editor
** Copyright : (c) Varol Okan
**   License : GPL v 2.0
**
** This class generates the command line for dvdauthor.
** Current Version of DVDAUTHOR used is 0.67
** You can find dvdauthor under http://dvdauthor.sourceforge.net/
**
****************************************************************************/

#ifndef MENU_H
#define MENU_H

// For compilation speed ???
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qaction.h>
// End for speed reasons

#include <qdatetime.h>
#include <qpixmap.h>

#include "rgba.h"
#include "global.h"
#include "xml_dvdauthor.h"

#define VMGM_LABEL "Main Menu VMGM"

class QGridLayout;
class QPushButton;
class QDomElement;
class QTabWidget;
class QPopupMenu;
class QDomNode;
class QAction;
class QToolBar;
class QTimer;

class MenuPreview;
class MenuObject;
class ButtonObject;
class MovieObject;
class SubMenus;
class DVDInfo;
class UndoBuffer;
class uiDialogRenderPreview;
class SourceFileEntry;
class SourceFileInfo;
class StructureItem;
class QDVDAuthor;
class Audio;

// Container class to encapsulate all variables for the DVDMenu - class
class CDVDMenuInterface
{
public:
	 CDVDMenuInterface ();
	~CDVDMenuInterface ();
	void initMe ();

	enum { StretchToFit = 0, StretchBlackBorders, StretchCutOff };

	bool writeProjectFile ( QDomElement & );
	bool readProjectFile  ( QDomNode &, float );
	CDVDMenuInterface & operator = ( CDVDMenuInterface & );
	bool operator == ( CDVDMenuInterface & );

	// variables.
	bool bModified;
	bool bIsSubMenu;
	QString qsMenuName;
	QValueList<Audio *>listSoundEntries; // Note, Audio::fileName == DisplayName of the SourceFileEntry

	// the following entries belong to the movie background
	QString qsMovieFileName;
	bool    bMovieBackgroundHasSound;
	QTime   timeOffset;
	QTime   timeDuration;
	// The following var is the background image or screenshot of the Movie ...
	QString qsBackgroundFileName;

	QString qsSelectedMaskFileName;
	QString qsHighlightedMaskFileName;
	QString qsResizeAlgo;
	QString qsAnimation;
	int     iStretchType;	// StretchToFit, BlackBorders, CutOffset
	QSize   posOffset;
	int     iFormat;
	int     iWidth;
	int     iHeight;
	int     iTitleset;
	int     iMenu;
	QString qsRatio;

	// generated by importdvdauthor.cpp::buildMenuFromPgc()
	// Note vob_struct.pause == "[multi|once]" is used as flag if once or all the time.
	QValueList <CXmlDVDAuthor::vob_struct *>listIntroVobs;
	QValueList <CXmlDVDAuthor::vob_struct *>listExtroVobs;
	QString qsPre;
	QString qsPause;
	QString qsPost;

	QPixmap backgroundImage;
	QPixmap highlightedMask;
	QPixmap selectedMask;
	Rgba    pgcColors[MAX_MASK_COLORS];
};

class DVDMenu : public QObject
{
	Q_OBJECT
protected:
	 DVDMenu ();
public:
	// Constructor / destructor
	DVDMenu ( QDVDAuthor * );
	virtual ~DVDMenu ( );

public slots:
	virtual void slotAddBackground       ( );
	virtual void slotAddSound            ( );
	virtual void createIntroExtroMenu    ( QPoint, bool, QString & );
	virtual void createSoundMenu         ( QPoint, QString & );
	virtual void slotAddIntro            ( );
	virtual void slotAddExtro            ( );
	virtual void slotAddHighlightedMask  ( );
	virtual void slotAddSelectedMask     ( );
	virtual void slotStructureClicked    ( StructureItem * );
	virtual void slotDroppedSomething    ( uint );
	virtual void slotCreatedMovieObject  ( MovieObject *, bool );
	virtual void slotAnimateObject       ( QString &, int, QString );
	virtual void slotStoreMenuAsTemplate ( );
	virtual void slotSnapshot            ( );
	virtual void slotUpdateStructure     ( );
	virtual void slotRequestSourceFiles  ( );
	virtual void slotRequestSubMenus     ( );
	virtual void slotMaskColorChanged    ( Rgba, Rgba );
	virtual void slotVisibleRegion       ( bool );
	virtual void slotRenderFrame         ( );
	virtual void slotEditTimeline        ( );
	virtual void slotBackgroundFromDialog( long );
	// The following functions will only reach the request through from the QDVDAuthor - class
	// to m_pPixmapMenu. Neccessary bc in mainMenubar the entries are valid for all SubMenus !!!
	virtual void slotAddFrameObject ( bool b=false );
	virtual void slotAddTextObject  ( bool b=false );
	virtual void slotAddImageObject ( bool b=false );
	virtual void slotAddMovieObject ( bool b=false );

public:  // public functions
	bool readProjectFile  (QDomNode &, float );
	bool writeProjectFile (QDomElement &);

	CDVDMenuInterface *getInterface   ( );
	StructureItem *createStructure    ( StructureItem * );
	QDVDAuthor *getDVDAuthor          ( );
	QValueList<ButtonObject *>        &getButtons          ( );
	QValueList<MovieObject *>         &getMovieObjects     ( );
	QValueList<SourceFileEntry *>     &getSourceFileEntries( bool b=true );
	QValueList<SourceFileInfo *>      &getSourceFileInfos  ( );
	SourceFileEntry    *getEntryFromButtonAction ( QString & );
	SourceFileInfo     *getInfoFromButtonAction  ( QString & );
	DVDMenu            *getMenuFromButtonAction  ( QString & );
	UndoBuffer  *getUndoBuffer        ( );
	MenuPreview *getMenuPreview       ( );
	void     clear                    ( );
	DVDMenu *clone                    ( );
	void    updateDVDMenu             ( bool b=true );
	QString checkDuration             ( );
	QString checkDuration             ( bool &, bool & );
	QString name                      ( );
	Rgba    getColor                  ( int );
	void    updateDVDMenu             ( QString );
	void    fitObjectDimension        ( MenuObject *p=NULL );
	void    createMask                ( QString &, int, bool b=false );
	void    setTabLabel               ( QString & );
	int     getFormat                 ( int iWidth, int iHeight );
	void    appendSourceFileEntry     ( SourceFileEntry * );
	void    removeSourceFileEntry     ( SourceFileEntry * );
	void    removeSourceEntry         ( QString & );
	void    removeBackgroundAudio     ( QString &, bool );
	bool    isSourceEntryUsed         ( QString & );
	void    replaceSourceDisplayName  ( QString &, QString & );
	void    replaceMenuName           ( QString &, QString & );
	void    modifyColor               ( uint, Rgba, bool b=false );
	void    refresh                   ( );
	void    createTransitionsXml      ( );
	bool    isMovieMenu               ( );
	bool    isEmpty                   ( );
	long    framesToRender            ( );
	float   fps                       ( );
	void    renderMenu                ( );
	bool    renderingDone             ( );
	void    changeSize                ( );
	void    initBackground            ( QString & );
	QString checkButtonsOverlapping   ( );

protected: // Private functions ...
	void    addBackground             ( QString &, QString *p=NULL, bool b=false );
	void    readBackgroundFile        ( QString & );
	void    CreateTab                 ( QTabWidget * );

protected:
	// helper functions ...
	void setMask (QString &, uint);
	void displayMask (uint);

protected:
	QWidget		*m_pDVDMenuTab;
	QGridLayout	*m_pTabLayout;
	QGridLayout	*m_pLayout1;
	QGridLayout	*m_pLayout3;
	MenuPreview	*m_pPixmapMenu;

	QPushButton	*m_pButtonAddBackground;
	QPushButton	*m_pButtonAddSound;
	QPushButton	*m_pButtonShowHighlightedMask;
	QPushButton	*m_pButtonShowSelectedMask;

	CDVDMenuInterface m_DVDMenuInterface;
	StructureItem    *m_pStructureItem;

	QPixmap m_highlightedMask;
	QPixmap m_selectedMask;
	uiDialogRenderPreview *m_pDialogRenderPreview;
	long m_iTotalFramesToRender;
	long m_iCurrentFrameToRender;
};

class VMGMenu : public DVDMenu
{
	Q_OBJECT
	 VMGMenu ();
public:
	 VMGMenu (QDVDAuthor *pDVDAuthor);
	~VMGMenu ();

	QToolBar   *getToolBar   ( );
	QPopupMenu *getPopupMenu ( );
	void      languageChange ( );

private:	// Private member functions ...
	void CreateToolBar (QDVDAuthor *pDVDAuthor);
	void CreateMenuEntry (QDVDAuthor *pDVDAuthor);

private:
	// Here are the private member actions ...
	QAction *m_pActionCreateDVD;
	QAction *m_pActionAddAudio;
	QAction *m_pActionAddBackgrnd;
	QAction *m_pActionAddSlide;
	QAction *m_pActionAddMenuSlide;
	QAction *m_pActionToolbarCreateDVD;
	QAction *m_pActionToolbarAddBackgrnd;
	QAction *m_pActionToolbarAddAudio;
	QAction *m_pActionToolbarAddSlide;
	QAction *m_pActionToolbarAddMenuSlide;
	QAction *m_pActionRenameMenu;
	QAction *m_pActionDeleteMenu;
	QAction *m_pActionCloneMenu;
	QAction *m_pActionConvertToPAL;
	QAction *m_pActionConvertToNTSC;
	QAction *m_pActionStoreMenu;
	QAction *m_pActionSnapshot;
	QAction *m_pActionAddFrame;
	QAction *m_pActionAddText;
	QAction *m_pActionAddImage;
	QAction *m_pActionAddMovie;
	QAction *m_pActionAddBackground;
	QAction *m_pActionAddSound;
	QAction *m_pActionAddIntro;
	QAction *m_pActionAddExtro;
	QAction *m_pActionAddFromLibrary;

	QToolBar   *m_pToolBar;
	QPopupMenu *m_pDVDMenuMenu;
};

#endif // MENU_H
