
/* unicode.q: some little unicode examples */

/* This script is encoded as UTF-8. Thus you'll need a Unicode-capable editor
   and a suitable font to display it properly. Moreover, the Q interpreter
   must have been compiled with unicode support (which is the default if your
   system has the necessary bits and pieces) to be able to process this
   file. */

/* The following option line ensures that the Q interpreter always uses the
   proper encoding when byte-compiling this file (if this option is not given,
   the interpreter will assume the host system encoding, whatever that happens
   to be). Note that --encoding, as a command line option to the interpreter
   (or the bytecode compiler), specifies the default encoding of script
   files. In difference to other command line options, this one can be used in
   each script file belonging to a program (not just the main script), using
   the "shebang" (#!) notation described in Appendix B.4 of the manual. This
   allows you to set the encoding on a per-file basis. */

#! --encoding=UTF-8

/* Sample test strings: */

def S1 = "Copyright © 1991-2005 by Albert Gräf\n",
  S2 = sprintf "א unicode string: '%s'\n" "太酷";

test = do puts [S1,S2];

/* Greek alphabet (lowercase). */

greek = strcat ["α".."ω"];

/* A little helper function to construct a character table. Lists 256
   characters starting at a given code point. */

table N:Int = map chr [N..N+255];

/* Print "hello" in different languages (pilfered from http://www.suse.de/
   ~mfabian/suse-cjk/). */

traditional_chinese = puts "早晨\n";
simplified_chinese = puts "你好\n";
japanese = puts "こんにちは\n";
korean = puts "안녕하세요\n";

/* Unicode letters can also be used in identifiers: */

안녕하세요 = puts "korean hello: 안녕하세요\n";

/* Moreover, sequences of punctuation characters from the entire unicode
   character set can serve as operator symbols. For instance, below we declare
   the "∈" symbol (U+2208, from the Unicode math symbols) as an alias for the
   (in) operator, which gives you a prettier way to write stuff like list
   comprehensions. */

public const (cond::in) X Y as ∈;

list_test = [(I,J) : I∈[1..5], J∈[1..I]];

/* For the Haskell aficionados... :) */

public const (cond::in) X Y as <-;

list_test2 = [(I,J) : I <- [1..5], J <- [1..I]];
