%{!?with_xemacs:%define with_xemacs 1}

%define name    prime-el
%define version 1.5.1.3
%define release 1
%define	emacsver	21.2
%define	xemacsver	21.4
%define	e_sitedir	%{_datadir}/emacs/site-lisp
%define e_startdir	%{e_sitedir}/site-start.d
%define	xe_sitedir	%{_datadir}/xemacs/site-lisp
%define xe_startdir	%{_datadir}/xemacs/site-packages/lisp/site-start.d
%define	sitepdir	%{_datadir}/xemacs/xemacs-packages

Summary: PRIME for Emacs
Name: %{name}
Version: %{version}
Release: %{release}
License: GPL
Group: Applications/Editors
Source0: http://prime.sourceforge.jp/src/%{name}-%{version}.tar.gz
URL: http://taiyaki.org/prime/emacs/
BuildArch: noarch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
%if %{with_xemacs}
BuildRequires: xemacs >= %{xemacsver}
%endif
BuildRequires: emacs >= %{emacsver}, mell, mell-emacs, mell-xemacs
BuildRequires: suikyo, suikyo-emacs, suikyo-xemacs

%description
PRIME for Emacs is a client of PRIME japanese input method.

%package emacs
Group: Applications/Editors
Summary: PRIME for Emacs (Emacs)
Requires: %{name} = %{version}-%{release}
Requires: emacs >= %{emacsver}, mell-emacs, suikyo-emacs

%description emacs
PRIME for Emacs is a client of PRIME japanese input method.

%if %{with_xemacs}
%package xemacs
Group: Applications/Editors
Summary: PRIME for Emacs (XEmacs)
Requires: %{name} = %{version}-%{release}
Requires: xemacs >= %{xemacsver}, mell-xemacs, suikyo-xemacs

%description xemacs
PRIME for Emacs is a client of PRIME japanese input method.
%endif

%prep
%setup -q

%build
%configure
make

cd src

cat << EOF > path.el
(setq load-path (nconc '(".") '("./contrib") '("%{e_sitedir}/mell") '("%{e_sitedir}/suikyo") load-path) byte-compile-warnings nil)
EOF

emacs -no-site-file -q -batch -l path.el -f batch-byte-compile *.el contrib/*.el
for i in *.el; do
  cp $i $i.emacs
done
for i in *.elc; do
  mv $i $i.emacs
done

%if %{with_xemacs}
perl -pi -e "s|^\\(require 'prime-engine-prime +nil t\\)|\\(require 'prime-engine-prime)|" prime-engine.el
perl -pi -e "s|^\\(require 'prime-engine-mode nil t\\)|\\(require 'prime-engine-mode)|" prime-engine.el
perl -pi -e "s|^\\(require 'font-lock nil t\\)|\\(require 'font-lock)|" prime.el
perl -pi -e "s|\\(require 'suikyo nil t\\)|\\(require 'suikyo)|" prime.el
#xemacs -no-site-file -q -batch -l path.el -f batch-byte-compile *.el
#for i in *.elc; do
#  mv $i $i.xemacs
#done
%endif

rm -f path.el*

cd ..

%install
rm -rf %{buildroot}

cd src

mkdir -p %{buildroot}%{e_sitedir}/%{name}
for i in *.el*.emacs; do
  install -c -m 0644 $i %{buildroot}%{e_sitedir}/%{name}/${i%%.emacs}
done

mkdir -p %{buildroot}%{e_sitedir}/%{name}/contrib
install -c -m 0644 contrib/insparens.el %{buildroot}%{e_sitedir}/%{name}/contrib
install -c -m 0644 contrib/insparens.elc %{buildroot}%{e_sitedir}/%{name}/contrib

mkdir -p %{buildroot}%{e_startdir}
install -c -m 0644 ../etc/init-prime.el %{buildroot}%{e_startdir}

%if %{with_xemacs}
cd ..
%configure --with-emacs-sitelispdir=%{sitepdir}/lisp \
  --with-emacs-initdir=%{xe_startdir}
make
cd src

mkdir -p %{buildroot}%{sitepdir}/lisp/%{name}
install -c -m 0644 *.el %{buildroot}%{sitepdir}/lisp/%{name}
#for i in *.elc.xemacs; do
#  install -c -m 0644 $i %{buildroot}%{sitepdir}/lisp/%{name}/${i%%.xemacs}
#donep

mkdir -p %{buildroot}%{sitepdir}/lisp/%{name}/contrib
install -c -m 0644 contrib/insparens.el %{buildroot}%{sitepdir}/lisp/%{name}/contrib

mkdir -p %{buildroot}%{xe_startdir}
install -c -m 0644 ../etc/init-prime.el %{buildroot}%{xe_startdir}
%endif

cd ..

make DESTDIR=%{buildroot} install-etc

find doc -name "Makefile*" -exec rm -f {} \;

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%config(noreplace) %{_sysconfdir}/prime/Custom_prime-el.el
%doc ChangeLog TODO doc

%files emacs
%defattr(-,root,root)
%{e_sitedir}/%{name}
%{e_startdir}/init-prime.el

%if %{with_xemacs}
%files xemacs
%defattr(-,root,root)
%{sitepdir}/lisp/%{name}
%{xe_startdir}/init-prime.el
%endif

%changelog
* Tue Dec 30 2003 Masaki Yatsu <yatsu@digital-genes.com>
- add '(noreplace)' option to Custom_prime-el.el

* Sun Dec 28 2003 Masaki Yatsu <yatsu@digital-genes.com>
- (1.2.1-1)
- create prime-el-xemacs package.

* Sun Dec 28 2003 Itou Hiroki <itouh(a)itpmail.itp.ne.jp>
- add 'make install-etc'

* Thu Dec 17 2003 Masaki Yatsu <yatsu@digital-genes.com>
- (1.2.0-1)
- version up.

* Tue May 27 2003 Masaki Yatsu <yatsu@borogrammers.net>
- (1.0.1-1 / 1.0.1-0pa1)
