//
// AUTOGENERATED, DO NOT EDIT
//
#include "precomp.hpp"

#ifdef HAVE_CLAMDBLAS

#include "opencv2/ocl/cl_runtime/cl_runtime.hpp"
#include "opencv2/ocl/cl_runtime/clamdblas_runtime.hpp"

#if defined(_WIN32)
    static void* WinGetProcAddress(const char* name)
    {
        static HMODULE opencl_module = NULL;
        if (!opencl_module)
        {
            opencl_module = GetModuleHandleA("clAmdBlas.dll");
            if (!opencl_module)
            {
                opencl_module = LoadLibraryA("clAmdBlas.dll");
                if (!opencl_module)
                    return NULL;
            }
        }
        return (void*)GetProcAddress(opencl_module, name);
    }
    #define CV_CL_GET_PROC_ADDRESS(name) WinGetProcAddress(name)
#endif // _WIN32

#if defined(__linux__)
    #include <dlfcn.h>
    #include <stdio.h>

    static void* GetProcAddress (const char* name)
    {
        static void* h = NULL;
        if (!h)
        {
            h = dlopen("libclAmdBlas.so", RTLD_LAZY | RTLD_GLOBAL);
            if (!h)
                return NULL;
        }

        return dlsym(h, name);
    }
    #define CV_CL_GET_PROC_ADDRESS(name) GetProcAddress(name)
#endif

#ifndef CV_CL_GET_PROC_ADDRESS
#define CV_CL_GET_PROC_ADDRESS(name) NULL
#endif

// generated by parser_clamdblas.py
enum OPENCLAMDBLAS_FN_ID {
    OPENCLAMDBLAS_FN_clAmdBlasGetVersion = 0,
    OPENCLAMDBLAS_FN_clAmdBlasSetup,
    OPENCLAMDBLAS_FN_clAmdBlasTeardown,
    OPENCLAMDBLAS_FN_clAmdBlasAddScratchImage,
    OPENCLAMDBLAS_FN_clAmdBlasRemoveScratchImage,
    OPENCLAMDBLAS_FN_clAmdBlasSswap,
    OPENCLAMDBLAS_FN_clAmdBlasDswap,
    OPENCLAMDBLAS_FN_clAmdBlasCswap,
    OPENCLAMDBLAS_FN_clAmdBlasZswap,
    OPENCLAMDBLAS_FN_clAmdBlasSscal,
    OPENCLAMDBLAS_FN_clAmdBlasDscal,
    OPENCLAMDBLAS_FN_clAmdBlasCscal,
    OPENCLAMDBLAS_FN_clAmdBlasZscal,
    OPENCLAMDBLAS_FN_clAmdBlasCsscal,
    OPENCLAMDBLAS_FN_clAmdBlasZdscal,
    OPENCLAMDBLAS_FN_clAmdBlasScopy,
    OPENCLAMDBLAS_FN_clAmdBlasDcopy,
    OPENCLAMDBLAS_FN_clAmdBlasCcopy,
    OPENCLAMDBLAS_FN_clAmdBlasZcopy,
    OPENCLAMDBLAS_FN_clAmdBlasSaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasDaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasCaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasZaxpy,
    OPENCLAMDBLAS_FN_clAmdBlasSdot,
    OPENCLAMDBLAS_FN_clAmdBlasDdot,
    OPENCLAMDBLAS_FN_clAmdBlasCdotu,
    OPENCLAMDBLAS_FN_clAmdBlasZdotu,
    OPENCLAMDBLAS_FN_clAmdBlasCdotc,
    OPENCLAMDBLAS_FN_clAmdBlasZdotc,
    OPENCLAMDBLAS_FN_clAmdBlasSrotg,
    OPENCLAMDBLAS_FN_clAmdBlasDrotg,
    OPENCLAMDBLAS_FN_clAmdBlasCrotg,
    OPENCLAMDBLAS_FN_clAmdBlasZrotg,
    OPENCLAMDBLAS_FN_clAmdBlasSrotmg,
    OPENCLAMDBLAS_FN_clAmdBlasDrotmg,
    OPENCLAMDBLAS_FN_clAmdBlasSrot,
    OPENCLAMDBLAS_FN_clAmdBlasDrot,
    OPENCLAMDBLAS_FN_clAmdBlasCsrot,
    OPENCLAMDBLAS_FN_clAmdBlasZdrot,
    OPENCLAMDBLAS_FN_clAmdBlasSrotm,
    OPENCLAMDBLAS_FN_clAmdBlasDrotm,
    OPENCLAMDBLAS_FN_clAmdBlasSnrm2,
    OPENCLAMDBLAS_FN_clAmdBlasDnrm2,
    OPENCLAMDBLAS_FN_clAmdBlasScnrm2,
    OPENCLAMDBLAS_FN_clAmdBlasDznrm2,
    OPENCLAMDBLAS_FN_clAmdBlasiSamax,
    OPENCLAMDBLAS_FN_clAmdBlasiDamax,
    OPENCLAMDBLAS_FN_clAmdBlasiCamax,
    OPENCLAMDBLAS_FN_clAmdBlasiZamax,
    OPENCLAMDBLAS_FN_clAmdBlasSasum,
    OPENCLAMDBLAS_FN_clAmdBlasDasum,
    OPENCLAMDBLAS_FN_clAmdBlasScasum,
    OPENCLAMDBLAS_FN_clAmdBlasDzasum,
    OPENCLAMDBLAS_FN_clAmdBlasSgemv,
    OPENCLAMDBLAS_FN_clAmdBlasDgemv,
    OPENCLAMDBLAS_FN_clAmdBlasCgemv,
    OPENCLAMDBLAS_FN_clAmdBlasZgemv,
    OPENCLAMDBLAS_FN_clAmdBlasSgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasDgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasCgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasZgemvEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsymv,
    OPENCLAMDBLAS_FN_clAmdBlasDsymv,
    OPENCLAMDBLAS_FN_clAmdBlasSsymvEx,
    OPENCLAMDBLAS_FN_clAmdBlasDsymvEx,
    OPENCLAMDBLAS_FN_clAmdBlasChemv,
    OPENCLAMDBLAS_FN_clAmdBlasZhemv,
    OPENCLAMDBLAS_FN_clAmdBlasStrmv,
    OPENCLAMDBLAS_FN_clAmdBlasDtrmv,
    OPENCLAMDBLAS_FN_clAmdBlasCtrmv,
    OPENCLAMDBLAS_FN_clAmdBlasZtrmv,
    OPENCLAMDBLAS_FN_clAmdBlasStrsv,
    OPENCLAMDBLAS_FN_clAmdBlasDtrsv,
    OPENCLAMDBLAS_FN_clAmdBlasCtrsv,
    OPENCLAMDBLAS_FN_clAmdBlasZtrsv,
    OPENCLAMDBLAS_FN_clAmdBlasSger,
    OPENCLAMDBLAS_FN_clAmdBlasDger,
    OPENCLAMDBLAS_FN_clAmdBlasCgeru,
    OPENCLAMDBLAS_FN_clAmdBlasZgeru,
    OPENCLAMDBLAS_FN_clAmdBlasCgerc,
    OPENCLAMDBLAS_FN_clAmdBlasZgerc,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr,
    OPENCLAMDBLAS_FN_clAmdBlasCher,
    OPENCLAMDBLAS_FN_clAmdBlasZher,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr2,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr2,
    OPENCLAMDBLAS_FN_clAmdBlasCher2,
    OPENCLAMDBLAS_FN_clAmdBlasZher2,
    OPENCLAMDBLAS_FN_clAmdBlasStpmv,
    OPENCLAMDBLAS_FN_clAmdBlasDtpmv,
    OPENCLAMDBLAS_FN_clAmdBlasCtpmv,
    OPENCLAMDBLAS_FN_clAmdBlasZtpmv,
    OPENCLAMDBLAS_FN_clAmdBlasStpsv,
    OPENCLAMDBLAS_FN_clAmdBlasDtpsv,
    OPENCLAMDBLAS_FN_clAmdBlasCtpsv,
    OPENCLAMDBLAS_FN_clAmdBlasZtpsv,
    OPENCLAMDBLAS_FN_clAmdBlasSspmv,
    OPENCLAMDBLAS_FN_clAmdBlasDspmv,
    OPENCLAMDBLAS_FN_clAmdBlasChpmv,
    OPENCLAMDBLAS_FN_clAmdBlasZhpmv,
    OPENCLAMDBLAS_FN_clAmdBlasSspr,
    OPENCLAMDBLAS_FN_clAmdBlasDspr,
    OPENCLAMDBLAS_FN_clAmdBlasChpr,
    OPENCLAMDBLAS_FN_clAmdBlasZhpr,
    OPENCLAMDBLAS_FN_clAmdBlasSspr2,
    OPENCLAMDBLAS_FN_clAmdBlasDspr2,
    OPENCLAMDBLAS_FN_clAmdBlasChpr2,
    OPENCLAMDBLAS_FN_clAmdBlasZhpr2,
    OPENCLAMDBLAS_FN_clAmdBlasSgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasDgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasCgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasZgbmv,
    OPENCLAMDBLAS_FN_clAmdBlasStbmv,
    OPENCLAMDBLAS_FN_clAmdBlasDtbmv,
    OPENCLAMDBLAS_FN_clAmdBlasCtbmv,
    OPENCLAMDBLAS_FN_clAmdBlasZtbmv,
    OPENCLAMDBLAS_FN_clAmdBlasSsbmv,
    OPENCLAMDBLAS_FN_clAmdBlasDsbmv,
    OPENCLAMDBLAS_FN_clAmdBlasChbmv,
    OPENCLAMDBLAS_FN_clAmdBlasZhbmv,
    OPENCLAMDBLAS_FN_clAmdBlasStbsv,
    OPENCLAMDBLAS_FN_clAmdBlasDtbsv,
    OPENCLAMDBLAS_FN_clAmdBlasCtbsv,
    OPENCLAMDBLAS_FN_clAmdBlasZtbsv,
    OPENCLAMDBLAS_FN_clAmdBlasSgemm,
    OPENCLAMDBLAS_FN_clAmdBlasDgemm,
    OPENCLAMDBLAS_FN_clAmdBlasCgemm,
    OPENCLAMDBLAS_FN_clAmdBlasZgemm,
    OPENCLAMDBLAS_FN_clAmdBlasSgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasDgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasCgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasZgemmEx,
    OPENCLAMDBLAS_FN_clAmdBlasStrmm,
    OPENCLAMDBLAS_FN_clAmdBlasDtrmm,
    OPENCLAMDBLAS_FN_clAmdBlasCtrmm,
    OPENCLAMDBLAS_FN_clAmdBlasZtrmm,
    OPENCLAMDBLAS_FN_clAmdBlasStrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasDtrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasCtrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasZtrmmEx,
    OPENCLAMDBLAS_FN_clAmdBlasStrsm,
    OPENCLAMDBLAS_FN_clAmdBlasDtrsm,
    OPENCLAMDBLAS_FN_clAmdBlasCtrsm,
    OPENCLAMDBLAS_FN_clAmdBlasZtrsm,
    OPENCLAMDBLAS_FN_clAmdBlasStrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasDtrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasCtrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasZtrsmEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasDsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasCsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasZsyrk,
    OPENCLAMDBLAS_FN_clAmdBlasSsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasDsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasCsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasZsyrkEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasCsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasZsyr2k,
    OPENCLAMDBLAS_FN_clAmdBlasSsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasDsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasCsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasZsyr2kEx,
    OPENCLAMDBLAS_FN_clAmdBlasSsymm,
    OPENCLAMDBLAS_FN_clAmdBlasDsymm,
    OPENCLAMDBLAS_FN_clAmdBlasCsymm,
    OPENCLAMDBLAS_FN_clAmdBlasZsymm,
    OPENCLAMDBLAS_FN_clAmdBlasChemm,
    OPENCLAMDBLAS_FN_clAmdBlasZhemm,
    OPENCLAMDBLAS_FN_clAmdBlasCherk,
    OPENCLAMDBLAS_FN_clAmdBlasZherk,
    OPENCLAMDBLAS_FN_clAmdBlasCher2k,
    OPENCLAMDBLAS_FN_clAmdBlasZher2k,
};
// generated by parser_clamdblas.py
const char* openclamdblas_fn_names[] = {
    "clAmdBlasGetVersion",
    "clAmdBlasSetup",
    "clAmdBlasTeardown",
    "clAmdBlasAddScratchImage",
    "clAmdBlasRemoveScratchImage",
    "clAmdBlasSswap",
    "clAmdBlasDswap",
    "clAmdBlasCswap",
    "clAmdBlasZswap",
    "clAmdBlasSscal",
    "clAmdBlasDscal",
    "clAmdBlasCscal",
    "clAmdBlasZscal",
    "clAmdBlasCsscal",
    "clAmdBlasZdscal",
    "clAmdBlasScopy",
    "clAmdBlasDcopy",
    "clAmdBlasCcopy",
    "clAmdBlasZcopy",
    "clAmdBlasSaxpy",
    "clAmdBlasDaxpy",
    "clAmdBlasCaxpy",
    "clAmdBlasZaxpy",
    "clAmdBlasSdot",
    "clAmdBlasDdot",
    "clAmdBlasCdotu",
    "clAmdBlasZdotu",
    "clAmdBlasCdotc",
    "clAmdBlasZdotc",
    "clAmdBlasSrotg",
    "clAmdBlasDrotg",
    "clAmdBlasCrotg",
    "clAmdBlasZrotg",
    "clAmdBlasSrotmg",
    "clAmdBlasDrotmg",
    "clAmdBlasSrot",
    "clAmdBlasDrot",
    "clAmdBlasCsrot",
    "clAmdBlasZdrot",
    "clAmdBlasSrotm",
    "clAmdBlasDrotm",
    "clAmdBlasSnrm2",
    "clAmdBlasDnrm2",
    "clAmdBlasScnrm2",
    "clAmdBlasDznrm2",
    "clAmdBlasiSamax",
    "clAmdBlasiDamax",
    "clAmdBlasiCamax",
    "clAmdBlasiZamax",
    "clAmdBlasSasum",
    "clAmdBlasDasum",
    "clAmdBlasScasum",
    "clAmdBlasDzasum",
    "clAmdBlasSgemv",
    "clAmdBlasDgemv",
    "clAmdBlasCgemv",
    "clAmdBlasZgemv",
    "clAmdBlasSgemvEx",
    "clAmdBlasDgemvEx",
    "clAmdBlasCgemvEx",
    "clAmdBlasZgemvEx",
    "clAmdBlasSsymv",
    "clAmdBlasDsymv",
    "clAmdBlasSsymvEx",
    "clAmdBlasDsymvEx",
    "clAmdBlasChemv",
    "clAmdBlasZhemv",
    "clAmdBlasStrmv",
    "clAmdBlasDtrmv",
    "clAmdBlasCtrmv",
    "clAmdBlasZtrmv",
    "clAmdBlasStrsv",
    "clAmdBlasDtrsv",
    "clAmdBlasCtrsv",
    "clAmdBlasZtrsv",
    "clAmdBlasSger",
    "clAmdBlasDger",
    "clAmdBlasCgeru",
    "clAmdBlasZgeru",
    "clAmdBlasCgerc",
    "clAmdBlasZgerc",
    "clAmdBlasSsyr",
    "clAmdBlasDsyr",
    "clAmdBlasCher",
    "clAmdBlasZher",
    "clAmdBlasSsyr2",
    "clAmdBlasDsyr2",
    "clAmdBlasCher2",
    "clAmdBlasZher2",
    "clAmdBlasStpmv",
    "clAmdBlasDtpmv",
    "clAmdBlasCtpmv",
    "clAmdBlasZtpmv",
    "clAmdBlasStpsv",
    "clAmdBlasDtpsv",
    "clAmdBlasCtpsv",
    "clAmdBlasZtpsv",
    "clAmdBlasSspmv",
    "clAmdBlasDspmv",
    "clAmdBlasChpmv",
    "clAmdBlasZhpmv",
    "clAmdBlasSspr",
    "clAmdBlasDspr",
    "clAmdBlasChpr",
    "clAmdBlasZhpr",
    "clAmdBlasSspr2",
    "clAmdBlasDspr2",
    "clAmdBlasChpr2",
    "clAmdBlasZhpr2",
    "clAmdBlasSgbmv",
    "clAmdBlasDgbmv",
    "clAmdBlasCgbmv",
    "clAmdBlasZgbmv",
    "clAmdBlasStbmv",
    "clAmdBlasDtbmv",
    "clAmdBlasCtbmv",
    "clAmdBlasZtbmv",
    "clAmdBlasSsbmv",
    "clAmdBlasDsbmv",
    "clAmdBlasChbmv",
    "clAmdBlasZhbmv",
    "clAmdBlasStbsv",
    "clAmdBlasDtbsv",
    "clAmdBlasCtbsv",
    "clAmdBlasZtbsv",
    "clAmdBlasSgemm",
    "clAmdBlasDgemm",
    "clAmdBlasCgemm",
    "clAmdBlasZgemm",
    "clAmdBlasSgemmEx",
    "clAmdBlasDgemmEx",
    "clAmdBlasCgemmEx",
    "clAmdBlasZgemmEx",
    "clAmdBlasStrmm",
    "clAmdBlasDtrmm",
    "clAmdBlasCtrmm",
    "clAmdBlasZtrmm",
    "clAmdBlasStrmmEx",
    "clAmdBlasDtrmmEx",
    "clAmdBlasCtrmmEx",
    "clAmdBlasZtrmmEx",
    "clAmdBlasStrsm",
    "clAmdBlasDtrsm",
    "clAmdBlasCtrsm",
    "clAmdBlasZtrsm",
    "clAmdBlasStrsmEx",
    "clAmdBlasDtrsmEx",
    "clAmdBlasCtrsmEx",
    "clAmdBlasZtrsmEx",
    "clAmdBlasSsyrk",
    "clAmdBlasDsyrk",
    "clAmdBlasCsyrk",
    "clAmdBlasZsyrk",
    "clAmdBlasSsyrkEx",
    "clAmdBlasDsyrkEx",
    "clAmdBlasCsyrkEx",
    "clAmdBlasZsyrkEx",
    "clAmdBlasSsyr2k",
    "clAmdBlasDsyr2k",
    "clAmdBlasCsyr2k",
    "clAmdBlasZsyr2k",
    "clAmdBlasSsyr2kEx",
    "clAmdBlasDsyr2kEx",
    "clAmdBlasCsyr2kEx",
    "clAmdBlasZsyr2kEx",
    "clAmdBlasSsymm",
    "clAmdBlasDsymm",
    "clAmdBlasCsymm",
    "clAmdBlasZsymm",
    "clAmdBlasChemm",
    "clAmdBlasZhemm",
    "clAmdBlasCherk",
    "clAmdBlasZherk",
    "clAmdBlasCher2k",
    "clAmdBlasZher2k",
};

static void* openclamdblas_check_fn(int ID)
{
    void* func = CV_CL_GET_PROC_ADDRESS(openclamdblas_fn_names[ID]);
    if (!func)
    {
        std::ostringstream msg;
        msg << "OpenCL AMD BLAS function is not available: [" << openclamdblas_fn_names[ID] << "]";
        CV_Error(CV_StsBadFunc, msg.str());
    }
    extern void* openclamdblas_fn_ptrs[];
    *(void**)(openclamdblas_fn_ptrs[ID]) = func;
    return func;
}

namespace {
// generated by parser_clamdblas.py
#define openclamdblas_fn0(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(); } \

#define openclamdblas_fn1(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1); } \

#define openclamdblas_fn2(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2); } \

#define openclamdblas_fn3(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3); } \

#define openclamdblas_fn4(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4); } \

#define openclamdblas_fn5(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5); } \

#define openclamdblas_fn6(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6); } \

#define openclamdblas_fn7(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7); } \

#define openclamdblas_fn8(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8); } \

#define openclamdblas_fn9(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9); } \

#define openclamdblas_fn10(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10); } \

#define openclamdblas_fn11(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11); } \

#define openclamdblas_fn12(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12); } \

#define openclamdblas_fn13(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13); } \

#define openclamdblas_fn14(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14); } \

#define openclamdblas_fn15(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15); } \

#define openclamdblas_fn16(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16); } \

#define openclamdblas_fn17(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17); } \

#define openclamdblas_fn18(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18); } \

#define openclamdblas_fn19(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19); } \

#define openclamdblas_fn20(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20); } \

#define openclamdblas_fn21(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21); } \

#define openclamdblas_fn22(ID, _R, decl_args) \
    typedef _R (*ID##FN)decl_args; \
    static _R ID##_switch_fn decl_args \
    { return ((ID##FN)openclamdblas_check_fn(ID))(p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15, p16, p17, p18, p19, p20, p21, p22); } \

}

// generated by parser_clamdblas.py
openclamdblas_fn3(OPENCLAMDBLAS_FN_clAmdBlasGetVersion, clAmdBlasStatus, (cl_uint* p1, cl_uint* p2, cl_uint* p3))
clAmdBlasStatus (*clAmdBlasGetVersion)(cl_uint*, cl_uint*, cl_uint*) =
        OPENCLAMDBLAS_FN_clAmdBlasGetVersion_switch_fn;
openclamdblas_fn0(OPENCLAMDBLAS_FN_clAmdBlasSetup, clAmdBlasStatus, ())
clAmdBlasStatus (*clAmdBlasSetup)() =
        OPENCLAMDBLAS_FN_clAmdBlasSetup_switch_fn;
openclamdblas_fn0(OPENCLAMDBLAS_FN_clAmdBlasTeardown, void, ())
void (*clAmdBlasTeardown)() =
        OPENCLAMDBLAS_FN_clAmdBlasTeardown_switch_fn;
openclamdblas_fn4(OPENCLAMDBLAS_FN_clAmdBlasAddScratchImage, cl_ulong, (cl_context p1, size_t p2, size_t p3, clAmdBlasStatus* p4))
cl_ulong (*clAmdBlasAddScratchImage)(cl_context, size_t, size_t, clAmdBlasStatus*) =
        OPENCLAMDBLAS_FN_clAmdBlasAddScratchImage_switch_fn;
openclamdblas_fn1(OPENCLAMDBLAS_FN_clAmdBlasRemoveScratchImage, clAmdBlasStatus, (cl_ulong p1))
clAmdBlasStatus (*clAmdBlasRemoveScratchImage)(cl_ulong) =
        OPENCLAMDBLAS_FN_clAmdBlasRemoveScratchImage_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasSswap, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasSswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSswap_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasDswap, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasDswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDswap_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasCswap, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasCswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCswap_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasZswap, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasZswap)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZswap_switch_fn;
openclamdblas_fn10(OPENCLAMDBLAS_FN_clAmdBlasSscal, clAmdBlasStatus, (size_t p1, cl_float p2, cl_mem p3, size_t p4, int p5, cl_uint p6, cl_command_queue* p7, cl_uint p8, const cl_event* p9, cl_event* p10))
clAmdBlasStatus (*clAmdBlasSscal)(size_t, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSscal_switch_fn;
openclamdblas_fn10(OPENCLAMDBLAS_FN_clAmdBlasDscal, clAmdBlasStatus, (size_t p1, cl_double p2, cl_mem p3, size_t p4, int p5, cl_uint p6, cl_command_queue* p7, cl_uint p8, const cl_event* p9, cl_event* p10))
clAmdBlasStatus (*clAmdBlasDscal)(size_t, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDscal_switch_fn;
openclamdblas_fn10(OPENCLAMDBLAS_FN_clAmdBlasCscal, clAmdBlasStatus, (size_t p1, cl_float2 p2, cl_mem p3, size_t p4, int p5, cl_uint p6, cl_command_queue* p7, cl_uint p8, const cl_event* p9, cl_event* p10))
clAmdBlasStatus (*clAmdBlasCscal)(size_t, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCscal_switch_fn;
openclamdblas_fn10(OPENCLAMDBLAS_FN_clAmdBlasZscal, clAmdBlasStatus, (size_t p1, cl_double2 p2, cl_mem p3, size_t p4, int p5, cl_uint p6, cl_command_queue* p7, cl_uint p8, const cl_event* p9, cl_event* p10))
clAmdBlasStatus (*clAmdBlasZscal)(size_t, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZscal_switch_fn;
openclamdblas_fn10(OPENCLAMDBLAS_FN_clAmdBlasCsscal, clAmdBlasStatus, (size_t p1, cl_float p2, cl_mem p3, size_t p4, int p5, cl_uint p6, cl_command_queue* p7, cl_uint p8, const cl_event* p9, cl_event* p10))
clAmdBlasStatus (*clAmdBlasCsscal)(size_t, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsscal_switch_fn;
openclamdblas_fn10(OPENCLAMDBLAS_FN_clAmdBlasZdscal, clAmdBlasStatus, (size_t p1, cl_double p2, cl_mem p3, size_t p4, int p5, cl_uint p6, cl_command_queue* p7, cl_uint p8, const cl_event* p9, cl_event* p10))
clAmdBlasStatus (*clAmdBlasZdscal)(size_t, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZdscal_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasScopy, clAmdBlasStatus, (size_t p1, const cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasScopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasScopy_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasDcopy, clAmdBlasStatus, (size_t p1, const cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasDcopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDcopy_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasCcopy, clAmdBlasStatus, (size_t p1, const cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasCcopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCcopy_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasZcopy, clAmdBlasStatus, (size_t p1, const cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasZcopy)(size_t, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZcopy_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasSaxpy, clAmdBlasStatus, (size_t p1, cl_float p2, const cl_mem p3, size_t p4, int p5, cl_mem p6, size_t p7, int p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasSaxpy)(size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSaxpy_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasDaxpy, clAmdBlasStatus, (size_t p1, cl_double p2, const cl_mem p3, size_t p4, int p5, cl_mem p6, size_t p7, int p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasDaxpy)(size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDaxpy_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasCaxpy, clAmdBlasStatus, (size_t p1, cl_float2 p2, const cl_mem p3, size_t p4, int p5, cl_mem p6, size_t p7, int p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasCaxpy)(size_t, cl_float2, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCaxpy_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasZaxpy, clAmdBlasStatus, (size_t p1, cl_double2 p2, const cl_mem p3, size_t p4, int p5, cl_mem p6, size_t p7, int p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasZaxpy)(size_t, cl_double2, const cl_mem, size_t, int, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZaxpy_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasSdot, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, const cl_mem p7, size_t p8, int p9, cl_mem p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasSdot)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSdot_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasDdot, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, const cl_mem p7, size_t p8, int p9, cl_mem p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasDdot)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDdot_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasCdotu, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, const cl_mem p7, size_t p8, int p9, cl_mem p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasCdotu)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCdotu_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasZdotu, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, const cl_mem p7, size_t p8, int p9, cl_mem p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasZdotu)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZdotu_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasCdotc, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, const cl_mem p7, size_t p8, int p9, cl_mem p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasCdotc)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCdotc_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasZdotc, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, const cl_mem p7, size_t p8, int p9, cl_mem p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasZdotc)(size_t, cl_mem, size_t, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZdotc_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasSrotg, clAmdBlasStatus, (cl_mem p1, size_t p2, cl_mem p3, size_t p4, cl_mem p5, size_t p6, cl_mem p7, size_t p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasSrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSrotg_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasDrotg, clAmdBlasStatus, (cl_mem p1, size_t p2, cl_mem p3, size_t p4, cl_mem p5, size_t p6, cl_mem p7, size_t p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasDrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDrotg_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasCrotg, clAmdBlasStatus, (cl_mem p1, size_t p2, cl_mem p3, size_t p4, cl_mem p5, size_t p6, cl_mem p7, size_t p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasCrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCrotg_switch_fn;
openclamdblas_fn13(OPENCLAMDBLAS_FN_clAmdBlasZrotg, clAmdBlasStatus, (cl_mem p1, size_t p2, cl_mem p3, size_t p4, cl_mem p5, size_t p6, cl_mem p7, size_t p8, cl_uint p9, cl_command_queue* p10, cl_uint p11, const cl_event* p12, cl_event* p13))
clAmdBlasStatus (*clAmdBlasZrotg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZrotg_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasSrotmg, clAmdBlasStatus, (cl_mem p1, size_t p2, cl_mem p3, size_t p4, cl_mem p5, size_t p6, const cl_mem p7, size_t p8, cl_mem p9, size_t p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasSrotmg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSrotmg_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasDrotmg, clAmdBlasStatus, (cl_mem p1, size_t p2, cl_mem p3, size_t p4, cl_mem p5, size_t p6, const cl_mem p7, size_t p8, cl_mem p9, size_t p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasDrotmg)(cl_mem, size_t, cl_mem, size_t, cl_mem, size_t, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDrotmg_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasSrot, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_float p8, cl_float p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasSrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_float, cl_float, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSrot_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasDrot, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_double p8, cl_double p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasDrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_double, cl_double, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDrot_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasCsrot, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_float p8, cl_float p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasCsrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_float, cl_float, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsrot_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasZdrot, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, cl_double p8, cl_double p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasZdrot)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, cl_double, cl_double, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZdrot_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasSrotm, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasSrotm)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, const cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSrotm_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasDrotm, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, int p4, cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasDrotm)(size_t, cl_mem, size_t, int, cl_mem, size_t, int, const cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDrotm_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasSnrm2, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasSnrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSnrm2_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasDnrm2, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasDnrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDnrm2_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasScnrm2, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasScnrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasScnrm2_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasDznrm2, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasDznrm2)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDznrm2_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasiSamax, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasiSamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasiSamax_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasiDamax, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasiDamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasiDamax_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasiCamax, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasiCamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasiCamax_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasiZamax, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasiZamax)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasiZamax_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasSasum, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasSasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSasum_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasDasum, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasDasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDasum_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasScasum, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasScasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasScasum_switch_fn;
openclamdblas_fn12(OPENCLAMDBLAS_FN_clAmdBlasDzasum, clAmdBlasStatus, (size_t p1, cl_mem p2, size_t p3, const cl_mem p4, size_t p5, int p6, cl_mem p7, cl_uint p8, cl_command_queue* p9, cl_uint p10, const cl_event* p11, cl_event* p12))
clAmdBlasStatus (*clAmdBlasDzasum)(size_t, cl_mem, size_t, const cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDzasum_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasSgemv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, cl_float p5, const cl_mem p6, size_t p7, const cl_mem p8, size_t p9, int p10, cl_float p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasSgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSgemv_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasDgemv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, cl_double p5, const cl_mem p6, size_t p7, const cl_mem p8, size_t p9, int p10, cl_double p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasDgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDgemv_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasCgemv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, FloatComplex p5, const cl_mem p6, size_t p7, const cl_mem p8, size_t p9, int p10, FloatComplex p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasCgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgemv_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasZgemv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, DoubleComplex p5, const cl_mem p6, size_t p7, const cl_mem p8, size_t p9, int p10, DoubleComplex p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasZgemv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgemv_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasSgemvEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, cl_float p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, cl_float p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasSgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSgemvEx_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasDgemvEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, cl_double p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, cl_double p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasDgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDgemvEx_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasCgemvEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, FloatComplex p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, FloatComplex p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasCgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgemvEx_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasZgemvEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, DoubleComplex p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, DoubleComplex p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasZgemvEx)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgemvEx_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasSsymv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, const cl_mem p7, size_t p8, int p9, cl_float p10, cl_mem p11, size_t p12, int p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasSsymv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsymv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDsymv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, const cl_mem p7, size_t p8, int p9, cl_double p10, cl_mem p11, size_t p12, int p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDsymv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsymv_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasSsymvEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, size_t p7, const cl_mem p8, size_t p9, int p10, cl_float p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasSsymvEx)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsymvEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasDsymvEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, size_t p7, const cl_mem p8, size_t p9, int p10, cl_double p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasDsymvEx)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsymvEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasChemv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, FloatComplex p4, const cl_mem p5, size_t p6, size_t p7, const cl_mem p8, size_t p9, int p10, FloatComplex p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasChemv)(clAmdBlasOrder, clAmdBlasUplo, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, FloatComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasChemv_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasZhemv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, DoubleComplex p4, const cl_mem p5, size_t p6, size_t p7, const cl_mem p8, size_t p9, int p10, DoubleComplex p11, cl_mem p12, size_t p13, int p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasZhemv)(clAmdBlasOrder, clAmdBlasUplo, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, int, DoubleComplex, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZhemv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasStrmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_mem p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasStrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStrmv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasDtrmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_mem p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasDtrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtrmv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasCtrmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_mem p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasCtrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtrmv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasZtrmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_mem p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasZtrmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtrmv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasStrsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasStrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStrsv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasDtrsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasDtrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtrsv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasCtrsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasCtrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtrsv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasZtrsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, size_t p8, cl_mem p9, size_t p10, int p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasZtrsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtrsv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasSger, clAmdBlasStatus, (clAmdBlasOrder p1, size_t p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasSger)(clAmdBlasOrder, size_t, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSger_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDger, clAmdBlasStatus, (clAmdBlasOrder p1, size_t p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDger)(clAmdBlasOrder, size_t, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDger_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCgeru, clAmdBlasStatus, (clAmdBlasOrder p1, size_t p2, size_t p3, cl_float2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCgeru)(clAmdBlasOrder, size_t, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgeru_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZgeru, clAmdBlasStatus, (clAmdBlasOrder p1, size_t p2, size_t p3, cl_double2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZgeru)(clAmdBlasOrder, size_t, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgeru_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCgerc, clAmdBlasStatus, (clAmdBlasOrder p1, size_t p2, size_t p3, cl_float2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCgerc)(clAmdBlasOrder, size_t, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgerc_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZgerc, clAmdBlasStatus, (clAmdBlasOrder p1, size_t p2, size_t p3, cl_double2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZgerc)(clAmdBlasOrder, size_t, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgerc_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasSsyr, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, size_t p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasSsyr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsyr_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasDsyr, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, size_t p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasDsyr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsyr_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasCher, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, size_t p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasCher)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCher_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasZher, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, size_t p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasZher)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZher_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasSsyr2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasSsyr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsyr2_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDsyr2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDsyr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsyr2_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCher2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCher2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCher2_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZher2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZher2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZher2_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasStpmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_mem p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasStpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStpmv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasDtpmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_mem p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasDtpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtpmv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasCtpmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_mem p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasCtpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtpmv_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasZtpmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_mem p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasZtpmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtpmv_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasStpsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasStpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStpsv_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasDtpsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasDtpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtpsv_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasCtpsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasCtpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtpsv_switch_fn;
openclamdblas_fn15(OPENCLAMDBLAS_FN_clAmdBlasZtpsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, const cl_mem p6, size_t p7, cl_mem p8, size_t p9, int p10, cl_uint p11, cl_command_queue* p12, cl_uint p13, const cl_event* p14, cl_event* p15))
clAmdBlasStatus (*clAmdBlasZtpsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, const cl_mem, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtpsv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasSspmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, const cl_mem p7, size_t p8, int p9, cl_float p10, cl_mem p11, size_t p12, int p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasSspmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSspmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDspmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, const cl_mem p7, size_t p8, int p9, cl_double p10, cl_mem p11, size_t p12, int p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDspmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDspmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasChpmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float2 p4, const cl_mem p5, size_t p6, const cl_mem p7, size_t p8, int p9, cl_float2 p10, cl_mem p11, size_t p12, int p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasChpmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasChpmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZhpmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double2 p4, const cl_mem p5, size_t p6, const cl_mem p7, size_t p8, int p9, cl_double2 p10, cl_mem p11, size_t p12, int p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZhpmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZhpmv_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasSspr, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasSspr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSspr_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasDspr, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasDspr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDspr_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasChpr, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasChpr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasChpr_switch_fn;
openclamdblas_fn14(OPENCLAMDBLAS_FN_clAmdBlasZhpr, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, cl_mem p8, size_t p9, cl_uint p10, cl_command_queue* p11, cl_uint p12, const cl_event* p13, cl_event* p14))
clAmdBlasStatus (*clAmdBlasZhpr)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZhpr_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasSspr2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasSspr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSspr2_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasDspr2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasDspr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDspr2_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasChpr2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_float2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasChpr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_float2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasChpr2_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasZhpr2, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, cl_double2 p4, const cl_mem p5, size_t p6, int p7, const cl_mem p8, size_t p9, int p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasZhpr2)(clAmdBlasOrder, clAmdBlasUplo, size_t, cl_double2, const cl_mem, size_t, int, const cl_mem, size_t, int, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZhpr2_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasSgbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, size_t p5, size_t p6, cl_float p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, int p13, cl_float p14, cl_mem p15, size_t p16, int p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasSgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSgbmv_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasDgbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, size_t p5, size_t p6, cl_double p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, int p13, cl_double p14, cl_mem p15, size_t p16, int p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasDgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDgbmv_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasCgbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, size_t p5, size_t p6, cl_float2 p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, int p13, cl_float2 p14, cl_mem p15, size_t p16, int p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasCgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgbmv_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasZgbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, size_t p3, size_t p4, size_t p5, size_t p6, cl_double2 p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, int p13, cl_double2 p14, cl_mem p15, size_t p16, int p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasZgbmv)(clAmdBlasOrder, clAmdBlasTranspose, size_t, size_t, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgbmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasStbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_mem p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasStbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStbmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDtbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_mem p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDtbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtbmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCtbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_mem p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCtbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtbmv_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZtbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_mem p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZtbmv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_mem, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtbmv_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasSsbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, size_t p4, cl_float p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, cl_float p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasSsbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsbmv_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasDsbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, size_t p4, cl_double p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, cl_double p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasDsbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsbmv_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasChbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, size_t p4, cl_float2 p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, cl_float2 p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasChbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_float2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasChbmv_switch_fn;
openclamdblas_fn20(OPENCLAMDBLAS_FN_clAmdBlasZhbmv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, size_t p3, size_t p4, cl_double2 p5, const cl_mem p6, size_t p7, size_t p8, const cl_mem p9, size_t p10, int p11, cl_double2 p12, cl_mem p13, size_t p14, int p15, cl_uint p16, cl_command_queue* p17, cl_uint p18, const cl_event* p19, cl_event* p20))
clAmdBlasStatus (*clAmdBlasZhbmv)(clAmdBlasOrder, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, int, cl_double2, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZhbmv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasStbsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasStbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStbsv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasDtbsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasDtbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtbsv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasCtbsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasCtbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtbsv_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasZtbsv, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, clAmdBlasDiag p4, size_t p5, size_t p6, const cl_mem p7, size_t p8, size_t p9, cl_mem p10, size_t p11, int p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasZtbsv)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, const cl_mem, size_t, size_t, cl_mem, size_t, int, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtbsv_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasSgemm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, cl_float p7, const cl_mem p8, size_t p9, const cl_mem p10, size_t p11, cl_float p12, cl_mem p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasSgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSgemm_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasDgemm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, cl_double p7, const cl_mem p8, size_t p9, const cl_mem p10, size_t p11, cl_double p12, cl_mem p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasDgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDgemm_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasCgemm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, FloatComplex p7, const cl_mem p8, size_t p9, const cl_mem p10, size_t p11, FloatComplex p12, cl_mem p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasCgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgemm_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasZgemm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, DoubleComplex p7, const cl_mem p8, size_t p9, const cl_mem p10, size_t p11, DoubleComplex p12, cl_mem p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasZgemm)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgemm_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasSgemmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, cl_float p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, size_t p13, cl_float p14, cl_mem p15, size_t p16, size_t p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasSgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSgemmEx_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasDgemmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, cl_double p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, size_t p13, cl_double p14, cl_mem p15, size_t p16, size_t p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasDgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDgemmEx_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasCgemmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, FloatComplex p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, size_t p13, FloatComplex p14, cl_mem p15, size_t p16, size_t p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasCgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCgemmEx_switch_fn;
openclamdblas_fn22(OPENCLAMDBLAS_FN_clAmdBlasZgemmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasTranspose p2, clAmdBlasTranspose p3, size_t p4, size_t p5, size_t p6, DoubleComplex p7, const cl_mem p8, size_t p9, size_t p10, const cl_mem p11, size_t p12, size_t p13, DoubleComplex p14, cl_mem p15, size_t p16, size_t p17, cl_uint p18, cl_command_queue* p19, cl_uint p20, const cl_event* p21, cl_event* p22))
clAmdBlasStatus (*clAmdBlasZgemmEx)(clAmdBlasOrder, clAmdBlasTranspose, clAmdBlasTranspose, size_t, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZgemmEx_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasStrmm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_float p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasStrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStrmm_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasDtrmm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_double p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasDtrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtrmm_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasCtrmm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, FloatComplex p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasCtrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtrmm_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasZtrmm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, DoubleComplex p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasZtrmm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtrmm_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasStrmmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_float p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasStrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStrmmEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasDtrmmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_double p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasDtrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtrmmEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasCtrmmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, FloatComplex p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasCtrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtrmmEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasZtrmmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, DoubleComplex p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasZtrmmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtrmmEx_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasStrsm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_float p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasStrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStrsm_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasDtrsm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_double p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasDtrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtrsm_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasCtrsm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, FloatComplex p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasCtrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtrsm_switch_fn;
openclamdblas_fn17(OPENCLAMDBLAS_FN_clAmdBlasZtrsm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, DoubleComplex p8, const cl_mem p9, size_t p10, cl_mem p11, size_t p12, cl_uint p13, cl_command_queue* p14, cl_uint p15, const cl_event* p16, cl_event* p17))
clAmdBlasStatus (*clAmdBlasZtrsm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtrsm_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasStrsmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_float p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasStrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasStrsmEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasDtrsmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, cl_double p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasDtrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDtrsmEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasCtrsmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, FloatComplex p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasCtrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCtrsmEx_switch_fn;
openclamdblas_fn19(OPENCLAMDBLAS_FN_clAmdBlasZtrsmEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, clAmdBlasTranspose p4, clAmdBlasDiag p5, size_t p6, size_t p7, DoubleComplex p8, const cl_mem p9, size_t p10, size_t p11, cl_mem p12, size_t p13, size_t p14, cl_uint p15, cl_command_queue* p16, cl_uint p17, const cl_event* p18, cl_event* p19))
clAmdBlasStatus (*clAmdBlasZtrsmEx)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, clAmdBlasTranspose, clAmdBlasDiag, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZtrsmEx_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasSsyrk, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_float p6, const cl_mem p7, size_t p8, cl_float p9, cl_mem p10, size_t p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasSsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsyrk_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasDsyrk, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_double p6, const cl_mem p7, size_t p8, cl_double p9, cl_mem p10, size_t p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasDsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsyrk_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasCsyrk, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, FloatComplex p6, const cl_mem p7, size_t p8, FloatComplex p9, cl_mem p10, size_t p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasCsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsyrk_switch_fn;
openclamdblas_fn16(OPENCLAMDBLAS_FN_clAmdBlasZsyrk, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, DoubleComplex p6, const cl_mem p7, size_t p8, DoubleComplex p9, cl_mem p10, size_t p11, cl_uint p12, cl_command_queue* p13, cl_uint p14, const cl_event* p15, cl_event* p16))
clAmdBlasStatus (*clAmdBlasZsyrk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZsyrk_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasSsyrkEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_float p6, const cl_mem p7, size_t p8, size_t p9, cl_float p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasSsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsyrkEx_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDsyrkEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_double p6, const cl_mem p7, size_t p8, size_t p9, cl_double p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsyrkEx_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCsyrkEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, FloatComplex p6, const cl_mem p7, size_t p8, size_t p9, FloatComplex p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsyrkEx_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZsyrkEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, DoubleComplex p6, const cl_mem p7, size_t p8, size_t p9, DoubleComplex p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZsyrkEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZsyrkEx_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasSsyr2k, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_float p6, const cl_mem p7, size_t p8, const cl_mem p9, size_t p10, cl_float p11, cl_mem p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasSsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, const cl_mem, size_t, cl_float, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsyr2k_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasDsyr2k, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_double p6, const cl_mem p7, size_t p8, const cl_mem p9, size_t p10, cl_double p11, cl_mem p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasDsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, const cl_mem, size_t, cl_double, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsyr2k_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCsyr2k, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, FloatComplex p6, const cl_mem p7, size_t p8, const cl_mem p9, size_t p10, FloatComplex p11, cl_mem p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, const cl_mem, size_t, FloatComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsyr2k_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZsyr2k, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, DoubleComplex p6, const cl_mem p7, size_t p8, const cl_mem p9, size_t p10, DoubleComplex p11, cl_mem p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZsyr2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, const cl_mem, size_t, DoubleComplex, cl_mem, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZsyr2k_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasSsyr2kEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_float p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_float p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasSsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsyr2kEx_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasDsyr2kEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, cl_double p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_double p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasDsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsyr2kEx_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasCsyr2kEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, FloatComplex p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, FloatComplex p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasCsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, FloatComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsyr2kEx_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasZsyr2kEx, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, DoubleComplex p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, DoubleComplex p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasZsyr2kEx)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, DoubleComplex, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZsyr2kEx_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasSsymm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, size_t p4, size_t p5, cl_float p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_float p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasSsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasSsymm_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasDsymm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, size_t p4, size_t p5, cl_double p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_double p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasDsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasDsymm_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasCsymm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, size_t p4, size_t p5, cl_float2 p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_float2 p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasCsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCsymm_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasZsymm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, size_t p4, size_t p5, cl_double2 p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_double2 p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasZsymm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZsymm_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasChemm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, size_t p4, size_t p5, cl_float2 p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_float2 p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasChemm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_float2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasChemm_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasZhemm, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasSide p2, clAmdBlasUplo p3, size_t p4, size_t p5, cl_double2 p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_double2 p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasZhemm)(clAmdBlasOrder, clAmdBlasSide, clAmdBlasUplo, size_t, size_t, cl_double2, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double2, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZhemm_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasCherk, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, float p6, const cl_mem p7, size_t p8, size_t p9, float p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasCherk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, float, const cl_mem, size_t, size_t, float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCherk_switch_fn;
openclamdblas_fn18(OPENCLAMDBLAS_FN_clAmdBlasZherk, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, double p6, const cl_mem p7, size_t p8, size_t p9, double p10, cl_mem p11, size_t p12, size_t p13, cl_uint p14, cl_command_queue* p15, cl_uint p16, const cl_event* p17, cl_event* p18))
clAmdBlasStatus (*clAmdBlasZherk)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, double, const cl_mem, size_t, size_t, double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZherk_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasCher2k, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, FloatComplex p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_float p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasCher2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, FloatComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_float, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasCher2k_switch_fn;
openclamdblas_fn21(OPENCLAMDBLAS_FN_clAmdBlasZher2k, clAmdBlasStatus, (clAmdBlasOrder p1, clAmdBlasUplo p2, clAmdBlasTranspose p3, size_t p4, size_t p5, DoubleComplex p6, const cl_mem p7, size_t p8, size_t p9, const cl_mem p10, size_t p11, size_t p12, cl_double p13, cl_mem p14, size_t p15, size_t p16, cl_uint p17, cl_command_queue* p18, cl_uint p19, const cl_event* p20, cl_event* p21))
clAmdBlasStatus (*clAmdBlasZher2k)(clAmdBlasOrder, clAmdBlasUplo, clAmdBlasTranspose, size_t, size_t, DoubleComplex, const cl_mem, size_t, size_t, const cl_mem, size_t, size_t, cl_double, cl_mem, size_t, size_t, cl_uint, cl_command_queue*, cl_uint, const cl_event*, cl_event*) =
        OPENCLAMDBLAS_FN_clAmdBlasZher2k_switch_fn;

// generated by parser_clamdblas.py
void* openclamdblas_fn_ptrs[] = {
    &clAmdBlasGetVersion,
    &clAmdBlasSetup,
    &clAmdBlasTeardown,
    &clAmdBlasAddScratchImage,
    &clAmdBlasRemoveScratchImage,
    &clAmdBlasSswap,
    &clAmdBlasDswap,
    &clAmdBlasCswap,
    &clAmdBlasZswap,
    &clAmdBlasSscal,
    &clAmdBlasDscal,
    &clAmdBlasCscal,
    &clAmdBlasZscal,
    &clAmdBlasCsscal,
    &clAmdBlasZdscal,
    &clAmdBlasScopy,
    &clAmdBlasDcopy,
    &clAmdBlasCcopy,
    &clAmdBlasZcopy,
    &clAmdBlasSaxpy,
    &clAmdBlasDaxpy,
    &clAmdBlasCaxpy,
    &clAmdBlasZaxpy,
    &clAmdBlasSdot,
    &clAmdBlasDdot,
    &clAmdBlasCdotu,
    &clAmdBlasZdotu,
    &clAmdBlasCdotc,
    &clAmdBlasZdotc,
    &clAmdBlasSrotg,
    &clAmdBlasDrotg,
    &clAmdBlasCrotg,
    &clAmdBlasZrotg,
    &clAmdBlasSrotmg,
    &clAmdBlasDrotmg,
    &clAmdBlasSrot,
    &clAmdBlasDrot,
    &clAmdBlasCsrot,
    &clAmdBlasZdrot,
    &clAmdBlasSrotm,
    &clAmdBlasDrotm,
    &clAmdBlasSnrm2,
    &clAmdBlasDnrm2,
    &clAmdBlasScnrm2,
    &clAmdBlasDznrm2,
    &clAmdBlasiSamax,
    &clAmdBlasiDamax,
    &clAmdBlasiCamax,
    &clAmdBlasiZamax,
    &clAmdBlasSasum,
    &clAmdBlasDasum,
    &clAmdBlasScasum,
    &clAmdBlasDzasum,
    &clAmdBlasSgemv,
    &clAmdBlasDgemv,
    &clAmdBlasCgemv,
    &clAmdBlasZgemv,
    &clAmdBlasSgemvEx,
    &clAmdBlasDgemvEx,
    &clAmdBlasCgemvEx,
    &clAmdBlasZgemvEx,
    &clAmdBlasSsymv,
    &clAmdBlasDsymv,
    &clAmdBlasSsymvEx,
    &clAmdBlasDsymvEx,
    &clAmdBlasChemv,
    &clAmdBlasZhemv,
    &clAmdBlasStrmv,
    &clAmdBlasDtrmv,
    &clAmdBlasCtrmv,
    &clAmdBlasZtrmv,
    &clAmdBlasStrsv,
    &clAmdBlasDtrsv,
    &clAmdBlasCtrsv,
    &clAmdBlasZtrsv,
    &clAmdBlasSger,
    &clAmdBlasDger,
    &clAmdBlasCgeru,
    &clAmdBlasZgeru,
    &clAmdBlasCgerc,
    &clAmdBlasZgerc,
    &clAmdBlasSsyr,
    &clAmdBlasDsyr,
    &clAmdBlasCher,
    &clAmdBlasZher,
    &clAmdBlasSsyr2,
    &clAmdBlasDsyr2,
    &clAmdBlasCher2,
    &clAmdBlasZher2,
    &clAmdBlasStpmv,
    &clAmdBlasDtpmv,
    &clAmdBlasCtpmv,
    &clAmdBlasZtpmv,
    &clAmdBlasStpsv,
    &clAmdBlasDtpsv,
    &clAmdBlasCtpsv,
    &clAmdBlasZtpsv,
    &clAmdBlasSspmv,
    &clAmdBlasDspmv,
    &clAmdBlasChpmv,
    &clAmdBlasZhpmv,
    &clAmdBlasSspr,
    &clAmdBlasDspr,
    &clAmdBlasChpr,
    &clAmdBlasZhpr,
    &clAmdBlasSspr2,
    &clAmdBlasDspr2,
    &clAmdBlasChpr2,
    &clAmdBlasZhpr2,
    &clAmdBlasSgbmv,
    &clAmdBlasDgbmv,
    &clAmdBlasCgbmv,
    &clAmdBlasZgbmv,
    &clAmdBlasStbmv,
    &clAmdBlasDtbmv,
    &clAmdBlasCtbmv,
    &clAmdBlasZtbmv,
    &clAmdBlasSsbmv,
    &clAmdBlasDsbmv,
    &clAmdBlasChbmv,
    &clAmdBlasZhbmv,
    &clAmdBlasStbsv,
    &clAmdBlasDtbsv,
    &clAmdBlasCtbsv,
    &clAmdBlasZtbsv,
    &clAmdBlasSgemm,
    &clAmdBlasDgemm,
    &clAmdBlasCgemm,
    &clAmdBlasZgemm,
    &clAmdBlasSgemmEx,
    &clAmdBlasDgemmEx,
    &clAmdBlasCgemmEx,
    &clAmdBlasZgemmEx,
    &clAmdBlasStrmm,
    &clAmdBlasDtrmm,
    &clAmdBlasCtrmm,
    &clAmdBlasZtrmm,
    &clAmdBlasStrmmEx,
    &clAmdBlasDtrmmEx,
    &clAmdBlasCtrmmEx,
    &clAmdBlasZtrmmEx,
    &clAmdBlasStrsm,
    &clAmdBlasDtrsm,
    &clAmdBlasCtrsm,
    &clAmdBlasZtrsm,
    &clAmdBlasStrsmEx,
    &clAmdBlasDtrsmEx,
    &clAmdBlasCtrsmEx,
    &clAmdBlasZtrsmEx,
    &clAmdBlasSsyrk,
    &clAmdBlasDsyrk,
    &clAmdBlasCsyrk,
    &clAmdBlasZsyrk,
    &clAmdBlasSsyrkEx,
    &clAmdBlasDsyrkEx,
    &clAmdBlasCsyrkEx,
    &clAmdBlasZsyrkEx,
    &clAmdBlasSsyr2k,
    &clAmdBlasDsyr2k,
    &clAmdBlasCsyr2k,
    &clAmdBlasZsyr2k,
    &clAmdBlasSsyr2kEx,
    &clAmdBlasDsyr2kEx,
    &clAmdBlasCsyr2kEx,
    &clAmdBlasZsyr2kEx,
    &clAmdBlasSsymm,
    &clAmdBlasDsymm,
    &clAmdBlasCsymm,
    &clAmdBlasZsymm,
    &clAmdBlasChemm,
    &clAmdBlasZhemm,
    &clAmdBlasCherk,
    &clAmdBlasZherk,
    &clAmdBlasCher2k,
    &clAmdBlasZher2k,
};

#endif
