(* This example tests garbage collection by making some
 * unattached components.
 *)

open Printf
open Newt

let () =
  init_and_finish (
    fun () ->
      cls ();

      centered_window 20 20 "Press any key to exit";

      ignore (compact_button 0 0 "");
      ignore (button 0 0 "");
      ignore (checkbox 0 0 "" '*' None);
      ignore (radio_button 0 0 "" false None);
      ignore (label 0 0 "");
      ignore (vertical_scrollbar 0 0 0
		Newt_int.NEWT_COLORSET_ROOT Newt_int.NEWT_COLORSET_BORDER);
      ignore (listbox 0 0 0 []);
      (* XXX These cause floating-point exceptions inside newt - why?
      ignore (textbox_reflowed 0 0 "" 10 10 10 []);
      ignore (textbox 0 0 10 10 []);
      *)
      ignore (entry 0 0 None 1 []);
      ignore (scale 0 0 1 1L);

      wait_for_key ();
      pop_window ();
  );

  Gc.compact ()
