open Printf
open Newt

let () =
  let r =
    init_and_finish (
      fun () ->
	cls ();

	centered_window 20 20 "Form with button";

	let text = textbox 1 1 15 5 [WRAP; SCROLL] in
	textbox_set_text text "This is some text in a reflowed text box.  This is some text in a reflowed text box.";
	let b1 = button 5 8 "  OK  " in
	let b2 = button 5 13 "Cancel" in
	let form = form None None [] in

	form_add_components form [text; b1; b2];

	let r = run_form form in
	pop_window ();

	match r with
	| Some b when component_equals b b1 -> "OK pressed"
	| Some b when component_equals b b2 -> "Cancel pressed"
	| Some b when component_equals b form ->
	    "Form component returned (F12?)"
	| Some b when component_equals b text -> "Textbox component returned"
	| Some _ -> "unknown component"
	| None -> "no component"
    ) in

  prerr_endline ("result: " ^ r);

  Gc.compact ()
