/*  NETMAJ-XUI -- X User Interface --  Copyright Notice
 *
 *      Copyright (c) 1995,1996 Todo Software All rights reserved.
 *
 *   You can redistribute it and/or modify this software under the terms
 *  of the GNU General Public License version 2 as published by
 *  the Free Software Foundation.
 *
 *   This software is provided 'as-is', without any express or implied
 *  warranty.  In no event will the author be held liable for any damages
 *  arising from the use of this software.
 *  See the gpl.text for more details.
 *
 *   If you would like to do something with NETMAJ that this copyright
 *  prohibits (such as distributing it with a commercial product,
 *  using portions of the source in some other program, etc.), please
 *  contact the author (preferably via email).  Arrangements can
 *  probably be worked out.
 *
 *   Todo Software : NBC02365@niftyserve.or.jp
 */
/*  -*- Mode: C -*- 
 * This file is part of xui
 * 
 * talkcmd.c -- 
 * 
 * $Id: talkcmd.c,v 1.2 1996/07/31 22:50:32 suz Exp $
 * Author          : NBC02365@niftyserve.or.jp
 * Created On      : Thu Jan 25 22:49:42 1996
 * Last Modified By: NBC02365@niftyserve.or.jp
 * Last Modified On: Thu Jan 25 22:49:46 1996
 * description:
 * 
 * Copyright (C) 1995,1996 Todo Software All rights reserved.
 */

#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "xnet.h"

void
comment_divide (src, dest1, dest2)
     char *src, *dest1, *dest2;
{
  *dest2 = 0;
  for (; *src;)
    {
      if (*src == '#'
	  && (*(src + 1) == '!' || (*(src + 1) == '#')))
	{
	  *dest1 = 0;
	  strcpy (dest2, src + 2);
	  break;
	}
      *dest1++ = *src++;
    }
  *dest1 = 0;
}

void
comment_exec_command (s)
     char *s;
{

  while (isspace (*s))
    s++;
  if (strncmp (s, "exec", 4))
    {
      s += 4;
      while (isspace (*s))
	s++;
      if (*s)
	{
#if X11
#define exec_system system
#endif
	  if (flag_stringexec)
	    exec_system (s);
	}
    }
  else if (strncmp (s, "play", 4))
    {
      char file[256], *p = file;

      s += 4;
      while (isspace (*s))
	s++;
      while (!isspace (*s) && *s != 0)
	*p++ = *s++;
      *p = 0;
#ifndef X11
      if (flag_stringexec)
	playsound (file);
#endif
    }
}
