/*
 * NETMAJ - network mahjongg -  Copyright Notice
 *     Copyright (C) 1994, 1995, 1996 Koji Suzuki (suz@kt.rim.or.jp)
 *
 *  You can redistribute it and/or modify this software under the terms 
 * of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 *  This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author be held liable for any damages
 * arising from the use of this software.
 * See the gpl.text for more details.
 *
 *  If you would like to do something with NETMAJ that this copyright
 * prohibits (such as distributing it with a commercial product,
 * using portions of the source in some other program, etc.), please
 * contact the author (preferably via email).  Arrangements can
 * probably be worked out.
 *
 *  Koji Suzuki   : suz@kt.rim.or.jp
 */

/* $Id: inputserver.c,v 1.3 1996/08/31 08:14:31 suz Exp $ */

#include "pai.h"
#include "global.h"

char buf[256];
char buf2[256];
int port = INPUT_PORT;

main() {
	SOCKETIO *ssp,*csp;
	fd_set fds;

retry:
printf("Waiting connection\n");
	if (!(ssp = ServerSock( port ))) {
		fprintf(stderr,"cannot open server socket:%d\n",port);
		exit(1);
	}
	csp = AcceptSock( ssp );
	SockClose(ssp);
printf("Established\n");

	for (;;) {
		FD_ZERO(&fds);
		FD_SET(0,&fds);
		FD_SET(csp->sd,&fds);

		select(csp->sd+1,&fds,0,0,0);
		if (SockIsRead(csp)) {
			SockClose(csp);
			goto retry;
		}
		if (fgets(buf,256,stdin)) {
			sprintf(buf2,MSG_COMMENT,buf);
			SockWrites(buf2,csp);
		} else {
			SockClose(csp);
			exit(0);
		}
	}
}
