
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "カレンダーの作成"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-R*/
#define RNGT "年月範囲"
#define RNGC "例) 200201_200212、指定がなければ今月"

/*-p*/
#define PADT "前後月のパディング"
#define PADC "カレンダーの第一週と最終週の前後月の日も出力する"

/*-m*/
#define MONT "月曜日を週の最初の曜日にする"
#define MONC "同時に-pを指定しなければならない"

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "指定された範囲のカレンダーを出力する。出力項目はyear,month,date。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtcalender -o rsl.xt\n\
  解説)今月のカレンダーを出力する。\n\
xtcalender -R 200303 -o rsl.xt\n\
  解説)2003年3月のカレンダーを出力する。\n\
xtcalender -R 200303_200306 -o rsl.xt\n\
  解説)2003年3月から6月のカレンダーを出力する。\n\
xtcalender -R 200303 -p -o rsl.xt\n\
  解説)2003年3月のカレンダーを、前後月の最終(最初)週つきで出力する。\n\
xtcalender -R 200303 -p -m -o rsl.xt\n\
  解説)2003年3月のカレンダーを、月曜日を最初の曜日として前後月の最終(最初)週つきで出力する。\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtcal,xtmkdata"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
