
#include "commonHelp.h"
/*============================================================================*/
/* コマンドヘルプ,man,musahi GUI 共通メッセージ管理                           */
/*============================================================================*/
/*----------------------------------------------------------------------------*/
/* コマンドのタイトル                                                         */
/* コマンドヘルプの最初の行に表示                                             */
/*----------------------------------------------------------------------------*/
#define HELPT "項目間およびレコード間の計算"

/*----------------------------------------------------------------------------*/
/* パラメータ                                                                 */
/* コマンドヘルプの USAGE:として"キーワード XXXT"を表示 ex)-k キー項目名リスト*/
/* flagのオプションはコマンドヘルプのOPTIONS)として表示 ex)-z : 標準出力の圧縮*/
/*----------------------------------------------------------------------------*/
/*-k*/
#define KEYT "キー項目名リスト"
#define KEYC "計算の単位となる項目名リスト"

/*-s*/
#define SRTT "並べ換える項目名リスト"
#define SRTC "キー項目名で指定した単位行の中で、行の順番を決めるための項目名を指定する"
#define SRTF "数値順,逆順"

/*-c*/
#define CALT "計算式"
#define CALC "組み込みの演算子や関数を組み合わせた式を指定する"

/*-a*/
#define FNMT C_FNMT
#define FNMC C_FNMC

/*-q*/
#define SEQT C_SEQT
#define SEQC C_SEQC

/*-i*/
#define INFT C_INFT
#define INFC C_INFC

/*-o*/
#define OTFT C_OTFT
#define OTFC C_OTFC

/*-z*/
#define ZIPT C_ZIPT
#define ZIPC C_ZIPC

/*-t*/
#define TXTT C_TXTT
#define TXTC C_TXTC

/*-T*/
#define TMPT C_TMPT
#define TMPC C_TMPC

/*----------------------------------------------------------------------------*/
/* 要約                                                                       */
/* コマンドヘルプのSUMMARY:として表示する                                     */
/* HTMLヘルプやmanには、下のHELPDの上に結合する形で表示する                   */
/*----------------------------------------------------------------------------*/
#define HELPS "計算式で指定した計算をおこなう。"

/*----------------------------------------------------------------------------*/
/* 例                                                                         */
/*----------------------------------------------------------------------------*/
#define HELPE "\
xtcal -c '$金額*$数量' -a 合計金額 -i dat.xt -o rsl.xt\n\
xtcal -c 'round($金額/$来店回数,0.1)' -a 来店あたり金額 -i dat.xt -o rsl.xt\n\
"

/*----------------------------------------------------------------------------*/
/* 参照コマンド(必ずカンマで区切り、空白は用いない)                           */
/*----------------------------------------------------------------------------*/
#define HELPR "xtsel,xtmkdata"

/*----------------------------------------------------------------------------*/
/* 作者について                                                               */
/* コマンドヘルプには表示されない                                             */
/*----------------------------------------------------------------------------*/
#define HELPA C_HELPA

/*----------------------------------------------------------------------------*/
/* バグレポート                                                               */
/* ここを登録すればコマンドヘルプのBUG REPORT:に表示される。                  */
/* 登録がなければ(#define HELPB "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPB C_HELPB

/*----------------------------------------------------------------------------*/
/* ホームページ                                                               */
/* ここを登録すればコマンドヘルプのINFORMATION:に表示される。                 */
/* 登録がなければ(#define HELPH "")何も表示しない。                           */
/*----------------------------------------------------------------------------*/
#define HELPH C_HELPH
