
/*============================================================================*/
/* ѹ                                                                   */
/*----------------------------------------------------------------------------*/
/* 1.0 : APIб                                                      */
/*============================================================================*/
#include <musashi.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/encoding.h>
#include <iconv.h>
#include <errno.h>
#include <glob.h>

#include <xmlheadHelp.h>
struct mssComHelp comHelp={
  "xmlhead",    /* ޥ̾       */
  "1.0",        /* С       */
  HELPT,        /* ޥɥȥ */
  HELPS,        /*              */
  HELPE,        /*            */
  HELPR,        /* ȥޥ     */
  HELPA,        /* Ծ         */
  HELPB,        /* ХݡȾ */
  HELPH         /* ۡڡ     */
};

#define UNDEF 0
#define MAX_NEST 32
#define LOCAL_BUF 256
#define EncMax MssFieldMaxLen  /*iconvǻȤʸĹ*/

/*----------------------------------------------------------------------------*/
/* Хѿ                                                             */
/*----------------------------------------------------------------------------*/
extern struct mssGlobalVariables mssGV;
extern xmlParserCtxtPtr ctxt;

static struct mssFPW    *fpw; /*ϥե빽¤*/
static iconv_t *icid;   /*iconv Ѵϥɥ*/
static char *inEnc=NULL; /*ܤΥեΥ󥳡ǥ*/
static char *inVer=NULL; /*ܤΥեΥС*/
static char  currentPath[4096]; /*߽Υѥ (/a/b/c/)*/

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  MssOptINT optLIN={
    OINT,   /* ץ󥿥                                             */
    "l",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ, 2:XMLtableǤΤɬ(txtǤ̵)      */
    10,     /* ǥե(ͤȤƻ)                                   */
    1,      /* Ǿ                                                       */
    INT_MAX,/*                                                        */
    LINT,   /* ΥץΥȥ(Helpɽ)                         */
    LINC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptINF optINF={
    OINF,   /* ץ󥿥                                             */
    "i",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    256,    /* ǽκե                                     */
    0,      /*1:file not foundΥ顼ǽλʤ 0:                   */
    INFT,   /* ΥץΥȥ(Helpɽ)                         */
    INFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ϥե                                                               */
/*----------------------------------------------------------------------------*/
  MssOptOTF optOTF={
    OOTF,   /* ץ󥿥                                             */
    "o",    /* (ʣʸԲ)                                   */
    0,      /* 0:ץ, 1:ɬ                                         */
    OTFT,   /* ΥץΥȥ(Helpɽ)                         */
    OTFC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ̽                                                                   */
/*----------------------------------------------------------------------------*/
  MssOptFLG optZIP={
    OFLG,   /* ץ󥿥                                             */
    "z",    /* (ʣʸԲ)                                   */
    0,      /* ǥե(Ūˤ0) onˤȤ1ˤ          */
    ZIPT,   /* ΥץΥȥ(Helpɽ)                         */
    ZIPC    /* ΥץΥ(Helpɽ)                         */
  };

/*----------------------------------------------------------------------------*/
/* ץޤȤ                                                       */
/*----------------------------------------------------------------------------*/
void *opt[]={&optLIN,&optINF,&optOTF,&optZIP,NULL};

/*----------------------------------------------------------------------------*/
/* ¤                                                                     */
/*----------------------------------------------------------------------------*/

/* -f ̾¤ */
/* ex) -f rec@id:recID */
struct XmlFld {
  int   cnt;               /*ܿ         */
  char *eleNamOrg[MssFieldMaxCnt]; /*̾ (rec)   */
  char *attNamOrg[MssFieldMaxCnt]; /*°̾ (id)    */
  char *newNamOrg[MssFieldMaxCnt]; /*̾(recID)*/
  char *eleNam[MssFieldMaxCnt];    /*̾UTF8     */
  char *attNam[MssFieldMaxCnt];    /*°̾UTF8     */
  char *newNam[MssFieldMaxCnt];    /*̾UTF8   */
  int   keyNum[MssFieldMaxCnt];    /*-kǤꤵƤСֹ*/
};

struct XmlKey {
  char *namOrg[MssFieldMaxCnt];
  char *nam[MssFieldMaxCnt];
  int   on[MssFieldMaxCnt];
  int   allKeyIsOn;
  int   cnt;
};

typedef struct _XmlState {
  int level;
  int crFlg;
  int tagCnt; /*ȥνи(οͤ򸵤˥쥯Ȥ)*/
} XmlState;

void endOfProgram(XmlState *state){

  mssFree(inEnc);
  mssFree(inVer);
  mssFree(state);

/*----------------------------------------------------------------------------*/
/*եå&λ                                                       */
/*----------------------------------------------------------------------------*/
  mssCloseFPW(fpw);     /*ϥեΥ*/
  mssFreeOption(opt);      /*ץΰ賫*/
  mssShowEndMsg();        /*λå           */
  mssEnd(mssExitSuccess); /*λ                     */
}

/*----------------------------------------------------------------------------*/
/* SAX ϥɥ顼                                                             */
/*----------------------------------------------------------------------------*/
void start_doc(XmlState *state){

  /*XML*/
  inEnc=mssStrdup((char *)ctxt->input->encoding);
  inVer=mssStrdup((char *)ctxt->version);
  mssWriteXmlDeclaration( inVer, inEnc, fpw );
  if(inEnc==NULL) inEnc=mssStrdup("UTF-8");

  /*Ϥiconvץ*/
  icid=iconv_open(inEnc,"UTF-8");
  if((int)icid==-1) {
    mssShowErrMsg("encoding type error in iconv_open");
    mssEnd(mssErrorNoDefault);
  }

  /* currentPathν */
  currentPath[0]='/';
  currentPath[1]='\0';

}

void end_doc(XmlState *state){
  if(icid!=NULL) iconv_close(icid);
}

/* start */
void start_element(XmlState *state, char *fullname, char **atts){
  struct mssXmlTag *xmlTag;
  char *pos;
  int i;

  /*νиoptLINĶ齪λ*/
  state->tagCnt++;
  if(state->tagCnt>optLIN.val){
    mssWriteRet(fpw);
    pos=currentPath+strlen(currentPath)-1;
    while(pos>currentPath){
      state->level--;
      *pos='\0';
      while(*pos!='/') pos--;
      mssWriteXmlIndent(state->level,fpw);
      xmlTag=mssInitXmlTag(pos+1,NULL);
      mssWriteXmlEndTag(xmlTag,icid,fpw);
      mssFreeXmlTag(xmlTag);
      mssWriteRet(fpw);
    }
    endOfProgram(state);
  }

  mssGV.inCnt++;

  /*ߤΥΡɥѥ򹹿*/
  strcat(currentPath,fullname);
  strcat(currentPath,"/");

  if(state->crFlg){
    mssWriteRet(fpw);
    state->crFlg=0;
  }
  mssWriteXmlIndent(state->level,fpw);
  xmlTag=mssInitXmlTag(fullname,NULL);
  if(atts!=NULL){
    for(i=0;;i++){
      if(*(atts+2*i+0)==NULL) break;
      if(*(atts+2*i+1)==NULL) break;
      mssAddXmlTagAttributeStr(xmlTag,*(atts+2*i),*(atts+2*i+1),NULL);
    }
  }
  mssWriteXmlStartTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);
  mssGV.outCnt++;
  state->level++;
}

/* end */
void end_element(XmlState *state, char *fullname, char **atts){
  struct mssXmlTag *xmlTag;
  char *pos;

  state->level--;
  if(state->crFlg){
    mssWriteRet(fpw);
    mssWriteXmlIndent(state->level,fpw);
    state->crFlg=0;
  }
  xmlTag=mssInitXmlTag(fullname,NULL);
  mssWriteXmlEndTag(xmlTag,icid,fpw);
  mssFreeXmlTag(xmlTag);

  /*ߤΥΡɥѥ򹹿*/
  pos=currentPath+strlen(currentPath)-2;
  while(*pos!='/') pos--;
  *(++pos)='\0';

}

void start_characters(XmlState *state, xmlChar *chars, int len){
  char *tmp;
  switch(*chars){
  case '\n':
    state->crFlg=1; break;
  case '&':
    mssWriteStr("&amp;",fpw); break;
  case '>':
    mssWriteStr("&gt;",fpw); break;
  case '<':
    mssWriteStr("&lt;",fpw); break;
  case '\'':
    mssWriteStr("&apos;",fpw); break;
  case '"':
    mssWriteStr("&quot;",fpw); break;
  default:
    tmp=mssNencoding(chars,len,icid);
    mssWriteStr(tmp,fpw);
    mssFree(tmp);
  }
}

void start_cdata(XmlState *state, xmlChar *chars, int len){
  char *tmp;
  mssWriteStr("<![CDATA[",fpw);
  tmp=mssNencoding(chars,len,icid);
  mssWriteStr(tmp,fpw);
  mssFree(tmp);
  mssWriteStr("]]>",fpw);
}

static xmlEntityPtr get_entity( XmlState *ctx, xmlChar *name){
  return xmlGetPredefinedEntity(name);
}

/*sax error handler*/
#include "saxerror.h"

static xmlSAXHandler SAXFunctions = {
    NULL, /* internalSubset */
    NULL, /* isStandalone */
    NULL, /* hasInternalSubset */
    NULL, /* hasExternalSubset */
    NULL, /* resolveEntity */
    (getEntitySAXFunc) get_entity, /* getEntity */
    NULL, /* entityDecl */
    NULL, /* notationDecl */
    NULL, /* attributeDecl */
    NULL, /* elementDecl */
    NULL, /* unparsedEntityDecl */
    NULL, /* setDocumentLocator */
    (startDocumentSAXFunc)start_doc, /* startDocument */
    (endDocumentSAXFunc)end_doc, /* endDocument */
    (startElementSAXFunc)start_element, /* startElement */
    (endElementSAXFunc)end_element, /* endElement */
    NULL, /* reference */
    (charactersSAXFunc) start_characters, /* characters */
    NULL, /* ignorableWhitespace */
    NULL, /* processingInstruction */
    NULL, /* comment */
    (warningSAXFunc) xmlSaxErrEnd, /* xmlParserWarning */
    (errorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    (fatalErrorSAXFunc) xmlSaxErrEnd, /* xmlParserError */
    NULL, /* getParameterEntity */
    (cdataBlockSAXFunc)start_cdata,
};

int main(int argc, char *argv[]){

  XmlState         *state;

/*----------------------------------------------------------------------------*/
/*                                                                      */
/*----------------------------------------------------------------------------*/
  mssInit(argc,argv,&comHelp);        /* ʥʤɤν     */
  mssHelpDoc(opt,&comHelp,argc,argv); /* إ                       */
  mssSetOption(opt,argc,argv);        /* ޥɥץ     */

  fpw=mssOpenFPW(optOTF.str,optZIP.set,0); /*ɸϥץ*/

/*----------------------------------------------------------------------------*/
/*ᥤ롼                                                              */
/*----------------------------------------------------------------------------*/

  state=mssCalloc(sizeof(XmlState),"xml2xt");

  ctxt=(xmlParserCtxtPtr)xmlCreateFileParserCtxt(*(optINF.strList+0));
  if(!ctxt){
    mssShowErrMsg("not xml file\n");
    mssEnd(mssErrorNoDefault);
  }
  ctxt->sax=&SAXFunctions;

  ctxt->userData=state;
  xmlParseDocument(ctxt);
  ctxt->sax=NULL;
  xmlFreeParserCtxt(ctxt);

/*----------------------------------------------------------------------------*/
/*λ                                                                    */
/*----------------------------------------------------------------------------*/
  endOfProgram(state);
  return(0);              /* to avoid warning message*/
}
