/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifndef SONG_H
#define SONG_H

#include <QPixmap>
#include <QPair>
#include <QString>
#include <QMetaType>
#include <QDebug>

class Song {
public:
	QString artist;
	QString title;
	QString lyrics;
	QString album;
	QPixmap cover;
	
	Song(const QString & = QString(), const QString & = QString(), const QString & = QString(),
		  const QString & = QString(), const QPixmap & = QPixmap());
	Song(const Song &);
	~Song();
	
	Song &operator=(const Song &);
	bool operator==(const Song &) const;
	bool operator!=(const Song& song) const;
};

Q_DECLARE_METATYPE(Song);

QDebug operator<<(QDebug dbg, const Song &);

#endif // SONG_H