/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LYRICSOURCE_H
#define LYRICSOURCE_H


#include <QString>
#include <QList>
#include <QPair>
#include <QUrl>


/**
 * @brief Represents a source page to fetch the lyrics from.
 */
struct LyricSource {
	QString name; /*!< The name of the source */
	QString title; /*!< The Pattern of the title e.g. {artist} - {song} */
	
	/**
	 * A list of pairs to use to extract the lyrics from the fetched page.
	 * The first component of each pair represents the begin of the patternt to
	 * search for, the second part the end.
	 */
	QList < QPair <QString, QString> > extract; 
	
	/**
	 * A list of pairs to use to exclude from the fetched lyrics. Works like
	 * the previous list.
	 */
	QList < QPair <QString, QString> > exclude; 
	
	/**
	 * The Url to fetch the lyrics from, this must contains the patterns to
	 * remplace for, e.g. http:\\url_to_page.domain.com/{artist}-{song}.
	 */
	QString url;
	
	/**
	 * Indicates if the first letter of each word of the artist and title has
	 * to be capitalized.
	 */
	bool start_case;
	
	/**
	 * This list indicates how to manipulate de url before send the request,
	 * the rules here manipulates the patterns as remplacing the ' ' with '_'.
	 * The first element of each pair represents the pattern to search for, the
	 * second element the replacement for each matching substring.
	 */
	QList < QPair <QString, QString> > url_replace;
};

#endif