/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LYRICGETTER_H
#define LYRICGETTER_H

#include <QObject>

//Network Access Classes
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>

//Utils
#include "song.h"
#include "lyrics_source.h"

#include <QList>
#include <QPair>
#include <QStringList>
#include <QString>

class LyricsGetter : public QObject {
Q_OBJECT

public:
	explicit LyricsGetter(QObject *parent = 0, LyricSource *source = 0);
	void setLyricSource(LyricSource *);
	LyricSource *currentLyricSource();
	
signals:
	void success(bool, QString);

public slots:
	void getLyric(const Song &);
	void getLyric(QString, QString);

private slots:
	void replyFinished(QNetworkReply *);

private:
	QNetworkAccessManager *m_networkAccess;
	LyricSource *m_source;

//Utility functions
	QString prepareString(QString string, QList< QPair< QString, QString > >
&rules, bool = true);
};

#endif // LYRICGETTER_H
