'encoding UTF-8  Do not remove or change this line!
'**************************************************************************
' DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
'
' Copyright 2000, 2010 Oracle and/or its affiliates.
'
' OpenOffice.org - a multi-platform office productivity suite
'
' This file is part of OpenOffice.org.
'
' OpenOffice.org is free software: you can redistribute it and/or modify
' it under the terms of the GNU Lesser General Public License version 3
' only, as published by the Free Software Foundation.
'
' OpenOffice.org is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU Lesser General Public License version 3 for more details
' (a copy is included in the LICENSE file that accompanied this code).
'
' You should have received a copy of the GNU Lesser General Public License
' version 3 along with OpenOffice.org.  If not, see
' <http://www.openoffice.org/license.html>
' for a copy of the LGPLv3 License.
'
'/************************************************************************
'*
'* owner : joerg.skottke@oracle.com
'*
'* short description : 
'*
'\******************************************************************************

testcase tCompareHelpContent()

    if ( gIsoLang <> "en-US" ) then
        printlog( "No testing for languages other than en_US" )
        goto endsub
    endif

    
    ' file related variables
    dim sFileOut as string
    dim sFilein as string
    dim sFileName as string
    dim sProductName as string : sProductName = hStringReplaceChar( gProductName, " ", "_" )
    
    ' the array that holds the names of the applications
    dim aTopicsFromUI( 1200 ) as string 
    
    ' some incremant variables and temporary stuff
    dim iTopicsFromUI as integer
    dim iCurrentItem as integer
    dim sCurrentItem as string
    dim irc as integer
    dim brc as boolean
    
    ' define input and output paths, presetting variables

    sFileName = sProductName & "_help_content_" & gIsoLang & ".txt"
    sFileOut = hGetWorkFile( sFilename )
    sFileIn  = gTesttoolPath & "framework\optional\input\help_browser\"  
    sFileIn  = convertpath( sFileIn & sFileName )
    
    aTopicsFromUI( 0 ) = "0"
    
    ' get the names from the listbox
    brc = hOpenHelp()
    if ( not brc ) then
        warnlog( "Help not open, aborting test" )
        goto endsub
    endif
    
    hSelectHelpTab( "content" )
    
    ' find out, how many items we have in the list
    iTopicsFromUI = hExpandAllNodes( SearchContent ) 
    printlog( "Reading " & iTopicsFromUI & " items from Content Treelist" )
    
    ' get all topics from the contents-treelist
    hGetVisibleNodeNames( SearchContent , aTopicsFromUI() )
 
    call hCloseHelp()
    
    ' Compare the list against a reference or create a new list, if the 
    ' reference does not exist
    printlog( "" )
    printlog( "Beginning comparision" )
    irc = hManageComparisionList( sFileIn, sFileOut, aTopicsFromUI() )
    hListResultEvaluation( irc , 0 )
    
endcase


