/*
 * xmlformat - registration of xml object formats 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 * 
 */

#ifndef XMLFORMAT_CONTACT_H
#define XMLFORMAT_CONTACT_H

#include "xmlformat-common.h"

/*

xmlformat-contact.xsd seems to be unfinished and inconsistent

*/

#define XMLFORMAT_CONTACT_ROOT				"contact"
#define XMLFORMAT_CONTACT_VERSION			"version"			// attribute

#define XMLFORMAT_CONTACT_DATECONTENT			"DateContent"
#define XMLFORMAT_CONTACT_DATECONTENT_CONTENT		"Content"			// element

#define XMLFORMAT_CONTACT_PREFERRED			"Preferred"
#define XMLFORMAT_CONTACT_PREFERRED_TRUE		"true"				// value
#define XMLFORMAT_CONTACT_PREFERRED_FALSE		"false"				// value

#define XMLFORMAT_CONTACT_ADDRESSLOCATION		"AddressLocation"
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_HOME		"Home"				// value
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_WORK		"Work"				// value
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_DOMESTIC	"Domestic"			// value
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_INTERNATIONAL	"International"			// value
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_POSTAL	"Postal"			// value
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_PARCEL	"Parcel"			// value
#define XMLFORMAT_CONTACT_ADDRESSLOCATION_OTHER		"Other"				// value

#define XMLFORMAT_CONTACT_ADDRESS			"Address"
#define XMLFORMAT_CONTACT_ADDRESS_POSTOFFICEBOX		"PostOfficeBox"			// element
#define XMLFORMAT_CONTACT_ADDRESS_EXTENDEDADDRESS	"ExtendedAddress"		// element
#define XMLFORMAT_CONTACT_ADDRESS_STREET		"Street"			// element
#define XMLFORMAT_CONTACT_ADDRESS_LOCALITY		"Locality"			// element
#define XMLFORMAT_CONTACT_ADDRESS_REGION		"Region"			// element
#define XMLFORMAT_CONTACT_ADDRESS_POSTALCODE		"PostalCode"			// element
#define XMLFORMAT_CONTACT_ADDRESS_COUNTRY		"Country"			// element
#define XMLFORMAT_CONTACT_ADDRESS_LOCATION		"Location"			// attribute type AddressLocation
#define XMLFORMAT_CONTACT_ADDRESS_PREF			"Pref"				// attribute type Preferred

#define XMLFORMAT_CONTACT_ADDRESSLABEL			"AddressLabel"
#define XMLFORMAT_CONTACT_ADDRESSLABEL_CONTENT		"Content"			// element
#define XMLFORMAT_CONTACT_ADDRESSLABEL_LOCATION		"Location"			// attribute type AddressLocation
#define XMLFORMAT_CONTACT_ADDRESSLABEL_PREF		"Pref"				// attribute type Preferred

#define XMLFORMAT_CONTACT_EMAILLOCATION			"EMailLocation"
#define XMLFORMAT_CONTACT_EMAILLOCATION_HOME		"Home"				// value
#define XMLFORMAT_CONTACT_EMAILLOCATION_WORK		"Work"				// value
#define XMLFORMAT_CONTACT_EMAILLOCATION_OTHER		"Other"				// value

#define XMLFORMAT_CONTACT_EMAIL				"EMail"
#define XMLFORMAT_CONTACT_EMAIL_CONTENT			"Content"			// element
#define XMLFORMAT_CONTACT_EMAIL_TYPE			"Type"				// attribute
#define XMLFORMAT_CONTACT_EMAIL_LOCATION		"Location"			// attribute type EMailLocation
#define XMLFORMAT_CONTACT_EMAIL_UISLOT			"UI-Slot"			// attribute
#define XMLFORMAT_CONTACT_EMAIL_PREFERRED		"Preferred"			// attribute type Preferred

#define XMLFORMAT_CONTACT_NAME				"Name"
#define XMLFORMAT_CONTACT_NAME_LASTNAME			"LastName"			// element
#define XMLFORMAT_CONTACT_NAME_FIRSTNAME		"FirstName"			// element
#define XMLFORMAT_CONTACT_NAME_ADDITIONAL		"Additional"			// element
#define XMLFORMAT_CONTACT_NAME_PREFIX			"Prefix"			// element
#define XMLFORMAT_CONTACT_NAME_SUFFIX			"Suffix"			// element

#define XMLFORMAT_CONTACT_ORGANIZATION			"Organization"
#define XMLFORMAT_CONTACT_ORGANIZATION_NAME		"Name"				// element
#define XMLFORMAT_CONTACT_ORGANIZATION_DEPARTMENT	"Department"			// element
#define XMLFORMAT_CONTACT_ORGANIZATION_UNIT		"Unit"				// element

#define XMLFORMAT_CONTACT_TELEPHONETYPE			"TelephoneTyp"
#define XMLFORMAT_CONTACT_TELEPHONETYPE_VOICE		"Voice"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_CELLULAR	"Cellular"			// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_FAX		"Fax"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_MESSAGE		"Message"			// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_PAGER		"Pager"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_MODEM		"Modem"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_ISDN		"Isdn"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_ASSISTANT	"Assistant"			// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_CALLBACK	"Callback"			// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_COMPANY		"Company"			// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_CAR		"Car"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_RADIO		"Radio"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_TELEX		"Telex"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_TTYYTDD		"TtyYtdd"			// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_BBS		"Bbs"				// value
#define XMLFORMAT_CONTACT_TELEPHONETYPE_VIDEO		"Video"				// value

#define XMLFORMAT_CONTACT_TELEPHONELOCATION		"TelephoneLocation"
#define XMLFORMAT_CONTACT_TELEPHONELOCATION_HOME	"Home"				// value
#define XMLFORMAT_CONTACT_TELEPHONELOCATION_WORK	"Work"				// value

#define XMLFORMAT_CONTACT_TELEPHONE			"Telephone"
#define XMLFORMAT_CONTACT_TELEPHONE_CONTENT		"Content"			// element
#define XMLFORMAT_CONTACT_TELEPHONE_TYPE		"Type"				// attribute type TelephoneType
#define XMLFORMAT_CONTACT_TELEPHONE_UISLOT		"UI-Slot"			// attribute
#define XMLFORMAT_CONTACT_TELEPHONE_LOCATION		"Location"			// attribute type TelephoneLocation
#define XMLFORMAT_CONTACT_TELEPHONE_PREFERRED		"Preferred"			// attribute type Preferred

#define XMLFORMAT_CONTACT_KEYTYPE			"KeyType"
#define XMLFORMAT_CONTACT_KEYTYPE_X509			"X509"				// value
#define XMLFORMAT_CONTACT_KEYTYPE_PGP			"Pgp"				// value

#define XMLFORMAT_CONTACT_KEY				"Key"
#define XMLFORMAT_CONTACT_KEY_CONTENT			"Content"			// element
#define XMLFORMAT_CONTACT_KEY_TYPE			"Type"				// attribute type KeyType

#define XMLFORMAT_CONTACT_LOCATION			"Location"
#define XMLFORMAT_CONTACT_LOCATION_LATITUDE		"Latitude"			// element
#define XMLFORMAT_CONTACT_LOCATION_LONGITUDE		"Longitude"			// element

#define XMLFORMAT_CONTACT_MESSAGING			"Messaging"
#define XMLFORMAT_CONTACT_MESSAGING_HOME		"Home"				// value

#define XMLFORMAT_CONTACT_IM				"IM"
#define XMLFORMAT_CONTACT_IM_CONTENT			"Content"			// element
#define XMLFORMAT_CONTACT_IM_LOCATION			"Location"			// attribute type Messaging
#define XMLFORMAT_CONTACT_IM_UISLOT			"UI-Slot"			// attribute

#define XMLFORMAT_CONTACT_GROUPEWISEDIRECTORY		"GroupwiseDirectory"
#define XMLFORMAT_CONTACT_GROUPEWISEDIRECTORY_CONTENT	"Content"			// element
#define XMLFORMAT_CONTACT_GROUPEWISEDIRECTORY_LOCATION	"Location"			// attribute type AddressLocation
#define XMLFORMAT_CONTACT_GROUPEWISEDIRECTORY_UISLOT	"UI-Slot"			// attribute

#define XMLFORMAT_CONTACT_BOOL				"Bool"
#define XMLFORMAT_CONTACT_BOOL_TRUE			"True"				// value
#define XMLFORMAT_CONTACT_BOOL_FALE			"False"				// value

#define XMLFORMAT_CONTACT_WANTSHTML			"WantsHTML"
#define XMLFORMAT_CONTACT_WANTSHTML_TYPE		"Type"				// attribute type Bool

#define XMLFORMAT_CONTACT_IMAGEFORMAT			"ImageFormat"
#define XMLFORMAT_CONTACT_IMAGEFORMAT_BMP		"Bmp"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_GIF		"Gif"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_CGM		"Cgm"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_WMF		"Wmf"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_MET		"Met"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_PMB		"Pmb"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_DIB		"Dib"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_PICT		"Pict"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_TIFF		"Tiff"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_PS		"Ps"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_PDF		"Pdf"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_JPEG		"Jpeg"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_MPEG		"Mpeg"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_MPEG2		"Mpeg2"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_AVI		"Avi"				// value
#define XMLFORMAT_CONTACT_IMAGEFORMAT_QTIME		"Qtime"				// value

#define XMLFORMAT_CONTACT_IMAGEENCODE			"ImageEncode"
#define XMLFORMAT_CONTACT_IMAGEENCODE_B			"b"				// value

#define XMLFORMAT_CONTACT_IMAGEVALUE			"ImageValue"
#define XMLFORMAT_CONTACT_IMAGEVALUE_URI		"URI"				// value

#define XMLFORMAT_CONTACT_LOGO				"Logo"
#define XMLFORMAT_CONTACT_LOGO_CONTENT			"Content"			// element
#define XMLFORMAT_CONTACT_LOGO_TYPE			"Type"				// attribute type ImageFormat
#define XMLFORMAT_CONTACT_LOGO_ENCODING			"Encoding"			// attribute type ImageEncode
#define XMLFORMAT_CONTACT_LOGO_VALUE			"Value"				// attribute type ImageValue

#define XMLFORMAT_CONTACT_PHOTO				"Photo"
#define XMLFORMAT_CONTACT_PHOTO_CONTENT			"Content"			// element
#define XMLFORMAT_CONTACT_PHOTO_TYPE			"Type"				// attribute type ImageFormat
#define XMLFORMAT_CONTACT_PHOTO_ENCODING		"Encoding"			// attribute type ImageEncode
#define XMLFORMAT_CONTACT_PHOTO_VALUE			"Value"				// attribute type ImageValue

#define XMLFORMAT_CONTACT_SOUNDFORMAT			"SoundFormat"
#define XMLFORMAT_CONTACT_SOUNDFORMAT_WAVE		"Wave"				// value
#define XMLFORMAT_CONTACT_SOUNDFORMAT_PCM		"Pcm"				// value
#define XMLFORMAT_CONTACT_SOUNDFORMAT_AIFF		"Aiff"				// value

#define XMLFORMAT_CONTACT_SOUND				"Sound"
#define XMLFORMAT_CONTACT_SOUND_CONTENT			"Content"			// element
#define XMLFORMAT_CONTACT_SOUND_TYPE			"Type"				// attribute type of SoundFormat
#define XMLFORMAT_CONTACT_SOUND_VALUE			"Value"				// attribute

#define XMLFORMAT_CONTACT_USERDEFINED			"UserDefined"
#define XMLFORMAT_CONTACT_USERDEFINED_CONTENT		"Content"			// element

#define XMLFORMAT_CONTACT_EXTENSION			"Extension"
#define XMLFORMAT_CONTACT_EXTENSION_EXTNAME		"ExtName"			// element
#define XMLFORMAT_CONTACT_EXTENSION_CONTENT		"Content"			// element


// Anniversary
#define XMLFORMAT_CONTACT_ANNIVERSARY			"Anniversary"
#define XMLFORMAT_CONTACT_ANNIVERSARY_CONTENT		XMLFORMAT_CONTACT_DATECONTENT_CONTENT

// Assistant
#define XMLFORMAT_CONTACT_ASSISTANT			"Assistant"
#define XMLFORMAT_CONTACT_ASSISTANT_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Birthday
#define XMLFORMAT_CONTACT_BIRTHDAY			"Birthday"
#define XMLFORMAT_CONTACT_BIRTHDAY_CONTENT		XMLFORMAT_CONTACT_DATECONTENT_CONTENT

// BlogUrl
#define XMLFORMAT_CONTACT_BLOGURL			"BlogUrl"
#define XMLFORMAT_CONTACT_BLOGURL_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// CalendarUrl
#define XMLFORMAT_CONTACT_CALENDARURL			"CalendarUrl"
#define XMLFORMAT_CONTACT_CALENDARURL_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Categories
#define XMLFORMAT_CONTACT_CATEGORIES			"Categories"
#define XMLFORMAT_CONTACT_CATEGORIES_CATEGORY		XMLFORMAT_COMMON_CATEGORIES_CATEGORY

// Class
#define XMLFORMAT_CONTACT_CLASS				"Class"
#define XMLFORMAT_CONTACT_CLASS_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// FbUrl
#define XMLFORMAT_CONTACT_FBURL				"FbUrl"
#define XMLFORMAT_CONTACT_FBURL_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// FileAs
#define XMLFORMAT_CONTACT_FILEAS			"FileAs"
#define XMLFORMAT_CONTACT_FILEAS_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// FormattedName
#define XMLFORMAT_CONTACT_FORMATTEDNAME			"FormattedName"
#define XMLFORMAT_CONTACT_FORMATTEDNAME_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// FreeBusyUrl
#define XMLFORMAT_CONTACT_FREEBUSYURL			"FreeBusyUrl"
#define XMLFORMAT_CONTACT_FREEBUSYURL_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// IM-AIM
#define XMLFORMAT_CONTACT_IMAIM				"IM-AIM"
#define XMLFORMAT_CONTACT_IMAIM_CONTENT			XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMAIM_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMAIM_UISLOT			XMLFORMAT_CONTACT_IM_UISLOT

// IM-GaduGadu
#define XMLFORMAT_CONTACT_IMGADUGADU			"IM-GaduGadu"
#define XMLFORMAT_CONTACT_IMGADUGADU_CONTENT		XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMGADUGADU_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMGADUGADU_UISLOT		XMLFORMAT_CONTACT_IM_UISLOT

// IM-ICQ
#define XMLFORMAT_CONTACT_IMICQ				"IM-ICQ"
#define XMLFORMAT_CONTACT_IMICQ_CONTENT			XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMICQ_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMICQ_UISLOT			XMLFORMAT_CONTACT_IM_UISLOT

// IM-Jabber
#define XMLFORMAT_CONTACT_IMJABBER			"IM-Jabber"
#define XMLFORMAT_CONTACT_IMJABBER_CONTENT		XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMJABBER_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMJABBER_UISLOT		XMLFORMAT_CONTACT_IM_UISLOT

// IM-MSN
#define XMLFORMAT_CONTACT_IMMSN				"IM-MSN"
#define XMLFORMAT_CONTACT_IMMSN_CONTENT			XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMMSN_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMMSN_UISLOT			XMLFORMAT_CONTACT_IM_UISLOT

// IM-Yahoo
#define XMLFORMAT_CONTACT_IMYAHOO			"IM-Yahoo"
#define XMLFORMAT_CONTACT_IMYAHOO_CONTENT		XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMYAHOO_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMYAHOO_UISLOT		XMLFORMAT_CONTACT_IM_UISLOT

// IM-Yabber
#define XMLFORMAT_CONTACT_IMYABBER			"IM-Yabber"
#define XMLFORMAT_CONTACT_IMYABBER_CONTENT		XMLFORMAT_CONTACT_IM_CONTENT
#define XMLFORMAT_CONTACT_IMYABBER_LOCATION		XMLFORMAT_CONTACT_IM_LOCATION
#define XMLFORMAT_CONTACT_IMYABBER_UISLOT		XMLFORMAT_CONTACT_IM_UISLOT

// IRC
#define XMLFORMAT_CONTACT_IRC				"IRC"
#define XMLFORMAT_CONTACT_IRC_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// KDE-Extension
#define XMLFORMAT_CONTACT_KDEEXTENSION			"KDE-Extension"
#define XMLFORMAT_CONTACT_KDEEXTENSION_EXTNAME		XMLFORMAT_CONTACT_EXTENSION_EXTNAME
#define XMLFORMAT_CONTACT_KDEEXTENSION_CONTENT		XMLFORMAT_CONTACT_EXTENSION_CONTENT

// Manager
#define XMLFORMAT_CONTACT_MANAGER			"Manager"
#define XMLFORMAT_CONTACT_MANAGER_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Nickname
#define XMLFORMAT_CONTACT_NICKNAME			"Nickname"
#define XMLFORMAT_CONTACT_NICKNAME_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Note
#define XMLFORMAT_CONTACT_NOTE				"Note"
#define XMLFORMAT_CONTACT_NOTE_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// PhotoUrl
#define XMLFORMAT_CONTACT_PHOTOURL			"PhotoUrl"
#define XMLFORMAT_CONTACT_PHOTOURL_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Profession
#define XMLFORMAT_CONTACT_PROFESSION			"Profession"
#define XMLFORMAT_CONTACT_PROFESSION_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Revision
#define XMLFORMAT_CONTACT_REVISION			"Revision"
#define XMLFORMAT_CONTACT_REVISION_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Role
#define XMLFORMAT_CONTACT_ROLE				"Role"
#define XMLFORMAT_CONTACT_ROLE_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// SMS
#define XMLFORMAT_CONTACT_SMS				"SMS"
#define XMLFORMAT_CONTACT_SMS_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Spouse
#define XMLFORMAT_CONTACT_SPOUSE			"Spouse"
#define XMLFORMAT_CONTACT_SPOUSE_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Title
#define XMLFORMAT_CONTACT_TITLE				"Title"
#define XMLFORMAT_CONTACT_TITLE_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Uid
#define XMLFORMAT_CONTACT_UID				"Uid"
#define XMLFORMAT_CONTACT_UID_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Url
#define XMLFORMAT_CONTACT_URL				"Url"
#define XMLFORMAT_CONTACT_URL_CONTENT			XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// Version
#define XMLFORMAT_CONTACT_Version			"Version"
#define XMLFORMAT_CONTACT_Version_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// VideoUrl
#define XMLFORMAT_CONTACT_VIDEOURL			"VideoUrl"
#define XMLFORMAT_CONTACT_VIDEOURL_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT

// WantsHtml
/*

Different than in WantsHtml type definition

#define XMLFORMAT_CONTACT_WANTSHTML			"WantsHtml"
#define XMLFORMAT_CONTACT_WANTSHTML_CONTENT		XMLFORMAT_COMMON_STRINGCONTENT_CONTENT
*/

#endif /* XMLFORMAT_CONTACT_H */
