//////////////////////////////////////////////////////////////////////////////
//
//    KEXIFUTILS.CPP
//
//    Copyright (C) 2002-2004 Renchi Raju <renchi at pooh.tam.uiuc.edu>
//                            Gilles CAULIER <caulier dot gilles at free.fr>
//                            Ralf Hoelzer <kde at ralfhoelzer.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin Steet, Fifth Floor, Cambridge, MA 02110-1301, USA.
//
//////////////////////////////////////////////////////////////////////////////

#include <qpalette.h>
#include <qfont.h>
#include <qpainter.h>

#include "kexifentry.h"
#include "kexiflistviewitem.h"

KExifListViewItem::KExifListViewItem(QListView* parent,
                                     KExifEntry* entry,
                                     const QColor& color)
    : QListViewItem(parent), m_exifEntry(entry),
      m_key(0), m_color(color)
{
    if (m_exifEntry)
    {
        setText(0, m_exifEntry->getTitle());
        setText(1, m_exifEntry->getValue());
    }
}

KExifEntry* KExifListViewItem::exifEntry() const
{
    return m_exifEntry;
}

void KExifListViewItem::setSortKey(int key)
{
    m_key = key;
}

int KExifListViewItem::compare(QListViewItem * i, int , bool) const
{
    KExifListViewItem* him = dynamic_cast<KExifListViewItem*>(i);
    if (!him)
        return 0;

    return (m_key - (him->m_key));
}

void KExifListViewItem::paintCell(QPainter* p, const QColorGroup& cg,
                                  int column, int width, int align)
{
    QColorGroup cgMod(cg);
    cgMod.setColor(QColorGroup::Base, m_color);

    if (column == 0)
    {
        p->save();
        QFont fn(p->font());
        fn.setBold(true);
        p->setFont(fn);
    }
    
    QListViewItem::paintCell(p, cgMod, column, width, align);

    if (column == 0)
    {
        p->restore();
    }
}
