/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define FASTQS 8 /* predictor 8 in used to store qscale */

short ac_rescale_table[1024];

/* prediction macros */
#define FASTCLEAR16(p) memset((p), 0, 32);
#define FASTCOPY16(d, s) memcpy((d), (s), 32);
/* TODO: AC rescaling according to qscale */
#define FASTSCALE8H(d, s, q)                      \
{                                                 \
  int _qp = (s)[FASTQS];                          \
  int _qs = (q);                                  \
                                                  \
  if(!_qp || _qp == _qs) memcpy((d), (s), 32);    \
  else {                                          \
    d[0] = s[0];                                  \
    d[1] = (s[1] * _qp + (s[1]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[2] = (s[2] * _qp + (s[2]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[3] = (s[3] * _qp + (s[3]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[4] = (s[4] * _qp + (s[4]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[5] = (s[5] * _qp + (s[5]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[6] = (s[6] * _qp + (s[6]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[7] = (s[7] * _qp + (s[7]>0)?(qs>>1):-(qs>>1)) / _qs;   \
  }                                               \
}                                               

#define FASTSCALE8V(d, s, q)                      \
{                                                 \
  int _qp = (s)[FASTQS];                          \
  int _qs = (q);                                  \
                                                  \
  if(!_qp || _qp == _qs) memcpy((d), (s), 32);    \
  else {                                          \
    d[0]  =  s[0];                                \
    d[9]  = ( s[9] * _qp + (s[9]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[10] = (s[10] * _qp + (s[10]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[11] = (s[11] * _qp + (s[11]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[12] = (s[12] * _qp + (s[12]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[13] = (s[13] * _qp + (s[13]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[14] = (s[14] * _qp + (s[14]>0)?(qs>>1):-(qs>>1)) / _qs;   \
    d[15] = (s[15] * _qp + (s[15]>0)?(qs>>1):-(qs>>1)) / _qs;   \
  }                                               \
}
#define FASTAC8H(d, b) {				\
  memcpy((d), (b), 16);                                 \
  ((short int *)(d))[9] = ((short int *)(b))[8];	\
  ((short int *)(d))[10] = ((short int *)(b))[16];	\
  ((short int *)(d))[11] = ((short int *)(b))[24];	\
  ((short int *)(d))[12] = ((short int *)(b))[32];	\
  ((short int *)(d))[13] = ((short int *)(b))[40];	\
  ((short int *)(d))[14] = ((short int *)(b))[48];	\
  ((short int *)(d))[15] = ((short int *)(b))[56];	\
}

#define FASTAC8V(d, b) {				\
  memcpy((d), (b), 16);                                 \
  ((short int *)(d))[9] = ((short int *)(b))[8];	\
  ((short int *)(d))[10] = ((short int *)(b))[16];	\
  ((short int *)(d))[11] = ((short int *)(b))[24];	\
  ((short int *)(d))[12] = ((short int *)(b))[32];	\
  ((short int *)(d))[13] = ((short int *)(b))[40];	\
  ((short int *)(d))[14] = ((short int *)(b))[48];	\
  ((short int *)(d))[15] = ((short int *)(b))[56];	\
}

#define FASTSAD8H(v, p, b) {			\
  v += abs(b[1]) - abs(b[1] - p[1]) +		\
       abs(b[2]) - abs(b[2] - p[2]) +		\
       abs(b[3]) - abs(b[3] - p[3]) +		\
       abs(b[4]) - abs(b[4] - p[4]) +		\
       abs(b[5]) - abs(b[5] - p[5]) +		\
       abs(b[6]) - abs(b[6] - p[6]) +		\
       abs(b[7]) - abs(b[7] - p[7]);		\
}
#define FASTSAD8V(v, p, b) {			\
  v += abs(b[9]) - abs(b[9] - p[9]) +		\
       abs(b[10]) - abs(b[10] - p[10]) +	\
       abs(b[11]) - abs(b[11] - p[11]) +	\
       abs(b[12]) - abs(b[12] - p[12]) +	\
       abs(b[13]) - abs(b[13] - p[13]) +	\
       abs(b[14]) - abs(b[14] - p[14]) +	\
       abs(b[15]) - abs(b[15] - p[15]);		\
}
#define COPY8H(b, p)				\
{						\
  b[1] = p[1];					\
  b[2] = p[2];					\
  b[3] = p[3];					\
  b[4] = p[4];					\
  b[5] = p[5];					\
  b[6] = p[6];					\
  b[7] = p[7];                                  \
}
#define COPY8V(b, p)				\
{						\
  b[8] = p[9];					\
  b[16] = p[10];				\
  b[24] = p[11];				\
  b[32] = p[12];				\
  b[40] = p[13];				\
  b[48] = p[14];				\
  b[56] = p[15];                                \
}
#define FASTDIFF8H(b, p) {			\
  b[0] -= p[0];					\
  b[1] -= p[1];					\
  b[2] -= p[2];					\
  b[3] -= p[3];					\
  b[4] -= p[4];					\
  b[5] -= p[5];					\
  b[6] -= p[6];					\
  b[7] -= p[7];					\
  /* don't need 8 */				\
  b[9] -= p[9];					\
  b[10] -= p[10];				\
  b[11] -= p[11];				\
  b[12] -= p[12];				\
  b[13] -= p[13];				\
  b[14] -= p[14];				\
  b[15] -= p[15];				\
}
#define FASTSUM8H(b, p) {			\
  b[0] += p[0];					\
  b[1] += p[1];					\
  b[2] += p[2];					\
  b[3] += p[3];					\
  b[4] += p[4];					\
  b[5] += p[5];					\
  b[6] += p[6];					\
  b[7] += p[7];					\
  /* don't need 8 */				\
  b[9] += p[9];					\
  b[10] += p[10];				\
  b[11] += p[11];				\
  b[12] += p[12];				\
  b[13] += p[13];				\
  b[14] += p[14];				\
  b[15] += p[15];				\
}

#define FASTDIFF8V(b, p) {			\
/*TODO:not all needed*/  b[0] -= p[0];					\
  b[1] -= p[1];					\
  b[2] -= p[2];					\
  b[3] -= p[3];					\
  b[4] -= p[4];					\
  b[5] -= p[5];					\
  b[6] -= p[6];					\
  b[7] -= p[7];					\
  /* don't need 8 */				\
  b[9] -= p[9];					\
  b[10] -= p[10];				\
  b[11] -= p[11];				\
  b[12] -= p[12];				\
  b[13] -= p[13];				\
  b[14] -= p[14];				\
  b[15] -= p[15];				\
}
#define FASTSUM8V(b, p) {			\
  b[0] += p[0];					\
  b[1] += p[1];					\
  b[2] += p[2];					\
  b[3] += p[3];					\
  b[4] += p[4];					\
  b[5] += p[5];					\
  b[6] += p[6];					\
  b[7] += p[7];					\
  /* don't need 8 */				\
  b[9] += p[9];					\
  b[10] += p[10];				\
  b[11] += p[11];				\
  b[12] += p[12];				\
  b[13] += p[13];				\
  b[14] += p[14];				\
  b[15] += p[15];				\
}
