/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qapp.h>
#include <qprocess.h>
#include <qevent.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qmessagebox.h>

#include <klocale.h>

#include "UserEvents.h"
#include "KYumConf.h" 
#include "KYumView.h"
#include "RepoView.h"
#include "YumLogView.h"


/***************************************************************************/
/**
 * Constructs the log viewer window, sets it into read-only mode, and
 * starts the monitoring thread.
 *
 ***************************************************************************/ 

YumLogView::YumLogView(QWidget * pWidget)
  : KTextEdit(pWidget)
{
    setReadOnly(true);
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

YumLogView::~YumLogView()
{
    stopThread();
    wait();
}


/***************************************************************************/
/**
 *
 *
 ***************************************************************************/ 

bool YumLogView::close() 
{
    stopThread();
    wait();

    return KTextEdit::close();
}

 
/***************************************************************************/
/**
 *  This method is called from the monitoring thread when the file yum.log
 *  has changed to reflect the changes in the log view window.
 *
 ***************************************************************************/ 

void YumLogView::updateContents(QString strLogFile) 
{
    QFile  logFile(strLogFile);

    if ( logFile.exists() && logFile.open(IO_ReadOnly) )
    {
        setText("");

        while ( !logFile.atEnd() )
        {
            QString strLine;

            logFile.readLine(strLine, Q_ULONG(1024));
            append(strLine);
        }

        logFile.close();
    }
    else
        setText(strLogFile + i18n(" could not be opened for reading.\n"));
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

bool YumLogView::startThread()
{
    bool bSuccess = false;

    if ( !running() )
    {
        m_bExitRequested = false;
        start();
        bSuccess = true;
    }

    return bSuccess;
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

void YumLogView::run()
{
    int               count   = 4;
    bool              bFirst  = true;
    const KYumConf  & yumConf = KYumView::getKYumView()->getYumConf();
    
    QFileInfo fileInfoOld(yumConf.getLogFile());

    do
    {
        if ( ++count == 5 ) // Every 5 seconds
        {
            QString     strLogFile(yumConf.getLogFile());
            QFileInfo   fileInfoNew(strLogFile);

            if ( bFirst ||
                 fileInfoOld.size()         != fileInfoNew.size() ||
                 fileInfoOld.lastModified() != fileInfoNew.lastModified() )
            {
                QApplication::postEvent(this, new FileChangedEvent(strLogFile));

                fileInfoOld = fileInfoNew;
                bFirst = false;
            }

            count = 0;
        }

        sleep(1);
    }
    while ( !exitRequested() );
}


/***************************************************************************/
/**
 *  
 *
 ***************************************************************************/ 

bool YumLogView::event(QEvent * pEvent)
{
    bool bProcessed = false;
    
    if ( pEvent->type() == QEvent::Type(c_evt_FileChanged) )
    {
        QMutexLocker locker(&m_mutex);
        FileChangedEvent * pEvt = dynamic_cast<FileChangedEvent *>(pEvent);
        
        updateContents(pEvt->getFileName());
    }
    else
        bProcessed = KTextEdit::event(pEvent);
    
    return bProcessed;
}

#include "YumLogView.moc"
