/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef OptionsView_H_Included
#define OptionsView_H_Included

#include <qwidget.h>
#include <qtable.h>


class QTextBrowser;
class CfgGroup;

class OptionsTable;
class OptionsWidget;
class Option;

class OptionsView : public QWidget
  {
    Q_OBJECT

    private:
      OptionsTable *    m_pTable;
      OptionsWidget *   m_pOptionsWidget;
      QTextBrowser *    m_pHelpView;

    public:
                        OptionsView       (QWidget      * pParent = 0,
                                           const char   * pName   = "OptionsView");

      virtual         ~ OptionsView       ();

      void              setOptions        (const CfgGroup * pGroup);
      void              setDefaults       ();

    signals:
      void              optionChanged     (QString strKey, QString strValue);

    protected slots:
      void              slotOptionChanged (const QString & strKey, const QString & strValue);
      void              slotOptionHelp    (const QString & strHelp);
  };

#endif
