/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details. 
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/


#ifndef _KYumView_H_Included
#define _KYumView_H_Included

#include <qtabwidget.h>
#include <kparts/part.h>

#include "KYumConf.h"
#include "ActionsTab.h"
#include "GroupsTab.h"
#include "YumConfTab.h"
#include "ReposTab.h"

class QPainter;
class QListViewItem;


/**
 * 
 */
class KYumView : public QTabWidget
  {
    Q_OBJECT

    private:
      KYumConf      m_yumConf;
      ActionsTab  * m_pActionsTab;
      GroupsTab   * m_pGroupsTab;
      YumConfTab  * m_pYumConfTab;
      ReposTab    * m_pReposTab;
      QWidget     * m_pCurrentTab;

    public:
                    KYumView        (QWidget *parent);
      virtual     ~ KYumView        ();

      RepoView    * getRepoView     () { return m_pReposTab->getRepoView(); }
      OutputView  * getOutputView   () { return m_pReposTab->getOutputView(); }
      YumConfView * getYumConfView  () { return m_pYumConfTab->getYumConfView(); }
      ActionsView * getActionsView  () { return m_pActionsTab->getActionsView(); }
      GroupsView  * getGroupsView   () { return m_pGroupsTab->getGroupsView(); }

      const 
      KYumConf &    getYumConf      () const { return m_yumConf; }
      
      KYumConf &    getYumConf      ()       { return m_yumConf; }
      
      void          print           (QPainter *, int height, int width);
      void          addRepo         (Repo::Ptr ptrRepo, QString strFileName = "");
      
      bool          loadYumConf     ();
      bool          saveAll         ();
      bool          saveRepo        (Repo::Ptr ptrRepo);
      
      
      static KYumView * getKYumView ();
      

    signals:
      void          signalChangeStatusbar (const QString &);
      void          signalChangeCaption   (const QString &);
      void          signalContextAddRepo  ();

    private slots:
      void          slotSetTitle        (const QString & title);
      void          slotRepoSelected    (QListViewItem *);
      void          slotEditRepo        (QListViewItem *, const QPoint &, int); 
      void          slotYumConfSaved    (const QString & strConf);
      void          slotTabChanged      (QWidget * pNewTab);
      void          slotRepoContextMenu (QListViewItem *, const QPoint &, int);
  };

#endif // _KYumView_H_Included
