/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <qlayout.h>

#include <klocale.h>
#include <ktextedit.h>

#include "KYumButton.h"
#include "DlgUserPrompt.h"


/****************************************************************************/
/*
 *
 *
 ****************************************************************************/

DlgUserPrompt::DlgUserPrompt(QString      strMsg,
                             const char * responses[],
                             int          idxBtnConfirm,
                             QWidget    * pParent,
                             const char * pName)

  : QDialog        (pParent, pName),
    m_strMsg       (strMsg),
    m_idxBtnConfirm(idxBtnConfirm)

{
    int numButtons;

    for ( numButtons=0; responses[numButtons]; numButtons++ )
      ;

    m_pButtons = new PKYumButton[numButtons];


    QVBoxLayout * pTopLayout  = new QVBoxLayout(this, 5, 5);
    KTextEdit   * pTextEdit   = new KTextEdit(this, "pTextEdit");

    pTextEdit->setReadOnly(true);
    pTextEdit->setText(strMsg);
    pTopLayout->addWidget(pTextEdit, 1);

    QWidget     * pButtonPanel  = new QWidget(this);
    QHBoxLayout * pButtonLayout = new QHBoxLayout(pButtonPanel, 6);
    QSpacerItem * pHSpacer      = new QSpacerItem(60,
                                                  60,
                                                  QSizePolicy::Expanding,
                                                  QSizePolicy::Minimum);

    pButtonLayout->addItem(pHSpacer);

    for ( int i=0; responses[i]; i++ )
    {
        QString strName;

        strName.sprintf("btn_%d", i+1);
        m_pButtons[i] = new KYumButton(i, responses[i], pButtonPanel, strName);
        pButtonLayout->addWidget(m_pButtons[i]);

        connect(m_pButtons[i], SIGNAL(buttonClicked(int)),
                this,          SLOT(slotButtonClicked(int)));

        if ( i == idxBtnConfirm )
            connect(m_pButtons[i], SIGNAL(clicked()), this, SLOT(accept()));
        else
            connect(m_pButtons[i], SIGNAL(clicked()), this, SLOT(reject()));

    }

    pTopLayout->addWidget(pButtonPanel);

    resize(400, 600);
}


/****************************************************************************/
/*
 *
 *
 ****************************************************************************/

DlgUserPrompt::~DlgUserPrompt()
{
}


/****************************************************************************/
/*
 *
 *
 ****************************************************************************/

void DlgUserPrompt::slotButtonClicked(int id)
{
}

#include "DlgUserPrompt.moc"

