/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef DlgEditRepo_H_Included
#define DlgEditRepo_H_Included

#include "BaseDlgEditRepo.h"

class Repo;

/**
@author Steffen Offermann
*/
class DlgEditRepo : public BaseDlgEditRepo
  {
    Q_OBJECT

    private:
      enum E_SetFieldsMode
        {
          c_SetAll,
          c_SetEmpty
        };

    private:
      Repo &        m_repo;

    private:
      void          checkFields     ();
      void          warnRepoPath    ();
      void          setFields       (const Repo & repo, E_SetFieldsMode = c_SetAll);

    public:
                    DlgEditRepo     (QWidget * pParent, QString strName, Repo & repo);
      virtual     ~ DlgEditRepo     ();

      void          loadMirrorList  (QString strFile);

    protected slots:
      virtual void  slotTextChanged (const QString &);
      virtual void  accept          ();

      virtual void  selectMirrorList();
      virtual void  selectRepoFile  ();
  };

#endif
