/***************************************************************************
 *
 *   KYum - a KDE GUI for yum
 *
 *   Copyright (C) 2005 by Steffen Offermann
 *   steffen_ac@yahoo.com
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#ifndef ActionsTab_H_Included
#define ActionsTab_H_Included

#include <qwidget.h>


class QSplitter;
class QTextBrowser;

class ActionsView;
class OutputView;
class YumLogView;
class PackageInfo;

class Process;


//
//
//
class ActionsTab : public QWidget
  {
    Q_OBJECT

    private:
      ActionsView   * m_pActionsView;
      OutputView    * m_pOutputView;
      YumLogView    * m_pYumLogView;
      QTextBrowser  * m_pInfoView;

    public:
                      ActionsTab(QWidget * pParent);

      ActionsView   * getActionsView()  { return m_pActionsView; }
      YumLogView    * getYumLogView()   { return m_pYumLogView; }


    public slots:
      bool            event(QEvent * pEvent);


    protected slots:
      void            slotActionStarted   (Process * pProcess);
      void            slotActionTerminated(Process * pProcess);

      void            slotYumInfo         (QString strLine);
      void            slotYumPkgInfo      (QString strLine);
      void            slotYumError        (QString strLine);
      void            slotShowPackageInfo (const PackageInfo & info);
  };

#endif

