/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/
#include "writeprefpage.h"

#include "libkita/kitaconfig.h"

#include <qcheckbox.h>

#include <kpassdlg.h>
#include <klineedit.h>

using namespace Kita;
WritePrefPage::WritePrefPage( QWidget *parent )
        : WritePrefBase( parent )
{
    DefaultNameLine->setText( KitaConfig::DefaultName() );
    DefaultNameUseAlwaysCheckBox->setChecked( KitaConfig::DefaultNameUseAlways() );
    DefaultMailLine->setText( KitaConfig::DefaultMail() );
    DefaultSageCheckBox->setChecked( KitaConfig::DefaultSage() );

    connect( DefaultNameLine, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    connect( DefaultNameUseAlwaysCheckBox, SIGNAL( toggled( bool ) ), SIGNAL( changed() ) );
    connect( DefaultMailLine, SIGNAL( textChanged( const QString& ) ), SIGNAL( changed() ) );
    connect( DefaultSageCheckBox, SIGNAL( toggled( bool ) ), SIGNAL( changed() ) );
}


WritePrefPage::~WritePrefPage()
{}

void WritePrefPage::apply()
{
    KitaConfig::setDefaultName( DefaultNameLine->text() );
    KitaConfig::setDefaultNameUseAlways( DefaultNameUseAlwaysCheckBox->isChecked() );
    KitaConfig::setDefaultMail( DefaultMailLine->text() );
    KitaConfig::setDefaultSage( DefaultSageCheckBox->isChecked() );
}

#include "writeprefpage.moc"
