/***************************************************************************
*   Copyright (C) 2004 by Kita Developers                                 *
*   ikemo@users.sourceforge.jp                                            *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KITADATINFO_H
#define KITADATINFO_H

#include <qobject.h>
#include <kurl.h>
#include <qvaluevector.h>
#include <qdatetime.h>
#include <qmutex.h>

class QStringList;


/* return val of DatInfo::getHTML() */
enum{
    KITA_HTML_NOTPARSED,
    KITA_HTML_NORMAL,
    KITA_HTML_ABONE,
    KITA_HTML_BROKEN
};


enum{
    ABONECHK_BY_ID,
    ABONECHK_BY_NAME,
    ABONECHK_BY_WORD
};



/* Data Base of anchor
 
   For example, No.5 res has name = "foo", id "id1234", and anchors >>2-3 and >>4, then,
 
   m_resDatVec[5].name = "foo",
   m_resDatVec[5].id = "id1234",
   m_resDatVec[5].anclist[0].from = 2,
   m_resDatVec[5].anclist[0].to = 3,
   m_resDatVec[5].anclist[1].from = 4,
   m_resDatVec[5].anclist[1].to = 4.   
 
*/
struct ANCNUM
{
    int from;
    int to;
};

typedef QValueList<ANCNUM> AncList;


/* Data Base of response */
struct RESDAT
{
    int num;         /* number */
    QString linestr; /* raw line data */

    bool parsed;
    bool broken;

    QString name;
    QString nameHTML;
    QString address;
    QString date;
    QDateTime dateTime;
    QString id;
    QString be;
    QString bepointmark;
    QString host;
    QString bodyHTML;

    AncList anclist; /* anchor list. See above. */

    bool checkAbone; /* Is abone checked ? */
    bool abone;

    /* Is this res responsed by other one? */
    bool isResponsed;
};
typedef QValueVector<RESDAT> ResDatVec;


namespace Kita
{

    class Access;
    class OfflawAccess;
    class Thread;

    /*-----------------------*/

    class DatInfo : public QObject
    {
        Q_OBJECT

        QMutex m_mutex;

        /* pointer of Thread class */
        Thread* m_thread;

        /* basic information */
        KURL m_datURL;
        bool m_broken;
        ResDatVec m_resDatVec;
        int m_lock;

        /* for caching */
        Access* m_access;
        OfflawAccess* m_access2;
        QString m_lastLine;
        bool m_nowLoading;

        /* abone */
        bool m_aboneByID;
        bool m_aboneByName;
        bool m_aboneByBody;
        bool m_aboneChain;


        /* japanese strings */
        QString m_spacestr;
        QString m_framestr1; /* '|' */
        QString m_framestr2; /* '|-' */
        QString m_framestr3; /* 'L' */

        /*-------------------------------*/

    public:

        DatInfo();
        DatInfo( const KURL& url );
        ~DatInfo();
        void init();
        void wait();
        const KURL& url();

        /* for caching */
        bool updateCache( const QObject* parent );
        int getResponseCode();
        int getServerTime();
        bool deleteCache();
        bool isLoadingNow();
        void stopLoading();

        /* lock, unlock */
        void lock ();
        void unlock();
        int isLocked();

        /* string data */
        const QString& getDat( int num );
        const QString& getId( int num );
        QString getPlainName( int num );
        QString getPlainTitle( int num );
        QString getPlainBody( int num );

        /* HTML data */
        int getHTML( int num, bool checkAbone, QString& titleHTML, QString& bodyHTML );
        QString getHTMLString( int startnum, int endnum, bool checkAbone = TRUE );
        QString getHtmlByID( const QString& strid, int &count );
        QString getTreeByRes( const int rootnum, int& count );
        QString getTreeByResReverse( const int rootnum, int& count );

        /* numerical data */
        int getResNum();
        int getReadNum();
        int getViewPos();
        int getNumByID( const QString& strid );
        int getDatSize();

        /* several informations */
        const bool isResponsed ( int num ) const;
        bool isResValid( int num );
        bool isBroken();
        bool isResBroken( int num );
        bool checkID( const QString& strid, int num );
        bool checkWord( QStringList& stlist, int num, bool checkOR );

        /* abone check */
        bool checkAbone( int num );
        void resetAbone();

        /*-------------------------*/

    private:

        void initPrivate( bool loadCache = TRUE );
        void resetResDat( RESDAT& resdat );
        void increaseResDatVec( int delta );
        void deleteAccessJob();

        /* copy data */
        bool copyOneLineToResDat( const QString& line );

        /* HTML data */
        int getHTMLPrivate( int num, bool checkAbone, QString& titleHTML, QString& bodyHTML );
        void getHTMLofOneRes( int num, bool checkAbone, QString& html );
        QString getTreeByResPrivate( const int rootnum, bool reverse, int& count );
        QString getTreeByResCore( const int rootnum, bool reverse, int& count, QString prestr );
        bool checkRes( const int num, const int target );

        /* for abone */
        void resetAbonePrivate();
        bool checkAbonePrivate( int num );
        bool checkAboneCore( const QString& str, QStringList& strlist );

        /* parsing funtions */
        bool parseDat( int num );

        /*----------------------------*/

    private slots:

        void slotReceiveData( const QStringList& lineList );
        void slotFinishLoad();

    signals:
        void receiveData();
        void finishLoad();
    };

}

#endif
