/***************************************************************************
 *   Copyright (C) 2008 by Eric Laffoon   *
 *   sequitur@kde.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "radiobutton.h"
#include "radiobuttonkmdrdesignerplugin.h"

#include <QtPlugin>

RadioButtonKmdrDesignerPlugin::RadioButtonKmdrDesignerPlugin(QObject *parent): QObject(parent)
{
  initialized = false;
}

void RadioButtonKmdrDesignerPlugin::initialize(QDesignerFormEditorInterface * /* core */)
{
  if (initialized)
      return;

  initialized = true;
}

bool RadioButtonKmdrDesignerPlugin::isInitialized() const
{
  return initialized;
}

QWidget *RadioButtonKmdrDesignerPlugin::createWidget(QWidget *parent)
{
  return new RadioButton(parent);
}

QString RadioButtonKmdrDesignerPlugin::name() const
{
  return "RadioButton";
}

QString RadioButtonKmdrDesignerPlugin::group() const
{
  return "Display Widgets [Kommander]";
}

QIcon RadioButtonKmdrDesignerPlugin::icon() const
{
  return QIcon();
}

QString RadioButtonKmdrDesignerPlugin::toolTip() const
{
  return "";
}

QString RadioButtonKmdrDesignerPlugin::whatsThis() const
{
  return "";
}

bool RadioButtonKmdrDesignerPlugin::isContainer() const
{
  return false;
}

QString RadioButtonKmdrDesignerPlugin::domXml() const
{
  return "<widget class=\"RadioButton\" name=\"RadioButton\">\n"
        " <property name=\"geometry\">\n"
        "  <rect>\n"
        "   <x>0</x>\n"
        "   <y>0</y>\n"
        "   <width>32</width>\n"
        "   <height>24</height>\n"
        "  </rect>\n"
        " </property>\n"
        " <property name=\"toolTip\" >\n"
        "  <string>Insert a RadioButton</string>\n"
        " </property>\n"
        " <property name=\"whatsThis\" >\n"
        "  <string>The RadioButton offers exclusive selection within a ButtonGroup</string>\n"
        " </property>\n"
        "</widget>\n";
}

QString RadioButtonKmdrDesignerPlugin::includeFile() const
{
  return "radiobutton.h";
}
