// -*- c++ -*-
/***************************************************************************
                           volumecontroller.h
                           ------------------
    begin                : Sun May 9 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef CHANNELCHANGER_H
#define CHANNELCHANGER_H

#include <qobject.h>

class AudioManager;
class SourceManager;
class QTimer;

class VolumeController : public QObject
{
    Q_OBJECT

public:
    void setVolume(int left, int right);
    void volumeUp(int step);
    void volumeDown(int step);
    void mute(bool mute);
    void toggleMute();

    void prepareChannelChange();

    void setTiming(unsigned int pre, unsigned int post);

    void volume(int* left, int* right) const { *left = _left; *right = _right; };
    int  volume() const { return (_left+_right)/2; };
    bool muted() const { return _muted; };

    void setConfig(bool preferAudioManager, int amVol, int srcmVol);

signals:
    void setChannel();
    void muted(bool mute);
    void volumeChanged(int left, int right);
    void volumeChanged(int vol);


private slots:
    void preTimerExpired();
    void applyVolumeSettings();

private:
    friend class Kdetv;
    VolumeController(AudioManager* am, SourceManager* srcm,
                     bool preferAudioManager, int amVol, int srcmVol,
                     QObject* parent = NULL, const char* name = NULL);
    ~VolumeController();

    void doMute(bool mute);
    void doSetVolume(int left, int right);

    AudioManager*  _am;
    SourceManager* _srcm;

    bool           _preferAudioManager;
    int            _amVol;
    int            _srcmVol;

    unsigned int   _pre;
    unsigned int   _post;
    QTimer*        _preTimer;
    QTimer*        _postTimer;

    int  _left;
    int  _right;
    bool _muted;
};

#endif
