/***************************************************************************
                           channelimporter.cpp
                           -------------------
    begin                : Sat Oct 25 2003
    copyright            : (C) 2003 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <kdebug.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kconfig.h>

#include <qstringlist.h>
#include <qdir.h>

#include "channelstore.h"
#include "channelimporter.h"

ChannelImporter::ChannelImporter()
    : _map(0L)
{
    QStringList qsl = KGlobal::dirs()->resourceDirs("kdetv");
    for (QStringList::ConstIterator p = qsl.constBegin(); p != qsl.constEnd(); ++p) {
        _path = *p + "channels-dist/";
        if (QDir(_path).exists() && QFile::exists(_path + "Index.map")) {
            _map = new KConfig(_path + "Index.map", true, false);
            break;
        }
    }   
}

ChannelImporter::~ChannelImporter()
{
    delete _map;
}

QStringList ChannelImporter::lists()
{
    if (!_map) return QStringList();
    return _map->groupList();
}

bool ChannelImporter::import(ChannelStore* store, const QString& list)
{
    if (!_map) return false;

    _map->setGroup(list);
    QString name = _map->readEntry("file", QString::null);
    if (name.isEmpty()) {
        kdWarning() << "Error reading frequency list map file. Check your installation." << endl;
        return false;
    }

    if (!store->load(_path + name, "xawtv")) {
        kdWarning() << "Error importing frequency list file. Check your installation." << endl;
        return false;
    }

    store->renumber();
    return true;
}


#include "channelimporter.moc"
