/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.util.HashMap;

public class LFUMap
implements Serializable {
    private HashMap map;
    private MapEntry first;
    private MapEntry last;
    private int cacheSize;

    public LFUMap(int cacheSize) {
        this.cacheSize = Math.max(3, cacheSize);
        this.map = new HashMap(cacheSize);
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            return null;
        }
        if (this.first == this.last) {
            if (this.first.getKey().equals(key)) {
                return this.first.getValue();
            }
            return null;
        }
        MapEntry metrics = (MapEntry)this.map.get(key);
        if (metrics == null) {
            return null;
        }
        MapEntry prev = metrics.getPrevious();
        if (prev == null) {
            return metrics.getValue();
        }
        MapEntry next = metrics.getNext();
        if (next == null) {
            prev.setNext(null);
            this.last = prev;
            metrics.setPrevious(null);
            metrics.setNext(this.first);
            this.first.setPrevious(metrics);
            this.first = metrics;
            return metrics.getValue();
        }
        next.setPrevious(prev);
        prev.setNext(next);
        metrics.setPrevious(null);
        metrics.setNext(this.first);
        this.first.setPrevious(metrics);
        this.first = metrics;
        return metrics.getValue();
    }

    public void put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            if (value == null) {
                return;
            }
            this.last = this.first = new MapEntry(key, value);
            this.map.put(key, this.first);
            return;
        }
        if (value == null) {
            this.remove(key);
            return;
        }
        if (this.first.getKey().equals(key)) {
            return;
        }
        MapEntry entry = (MapEntry)this.map.get(key);
        if (entry == null) {
            if (1 + this.map.size() >= this.cacheSize) {
                this.map.remove(this.last.getKey());
                MapEntry previous = this.last.getPrevious();
                this.last.setNext(null);
                this.last.setPrevious(null);
                previous.setNext(null);
                this.last = previous;
            }
            MapEntry cacheEntry = new MapEntry(key, value);
            this.first.setPrevious(cacheEntry);
            cacheEntry.setNext(this.first);
            this.map.put(key, cacheEntry);
            this.first = cacheEntry;
            return;
        }
        entry.setValue(value);
        if (entry == this.first) {
            throw new IllegalStateException("Duplicate return?");
        }
        if (entry == this.last) {
            MapEntry previous = this.last.getPrevious();
            previous.setNext(null);
            this.last = previous;
            this.first.setPrevious(entry);
            entry.setNext(this.first);
            entry.setPrevious(null);
            this.first = entry;
            return;
        }
        MapEntry previous = entry.getPrevious();
        MapEntry next = entry.getNext();
        previous.setNext(next);
        next.setPrevious(previous);
        this.first.setPrevious(entry);
        entry.setNext(this.first);
        entry.setPrevious(null);
        this.first = entry;
    }

    public void remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.first == null) {
            return;
        }
        MapEntry entry = (MapEntry)this.map.remove(key);
        if (entry == null) {
            return;
        }
        if (entry == this.first) {
            MapEntry nextEntry = this.first.getNext();
            if (nextEntry == null) {
                this.first = null;
                this.last = null;
                entry.setNext(null);
                entry.setPrevious(null);
                return;
            }
            this.first = nextEntry;
            nextEntry.setPrevious(null);
            entry.setNext(null);
            entry.setPrevious(null);
            return;
        }
        if (entry == this.last) {
            MapEntry prev = this.last.getPrevious();
            prev.setNext(null);
            this.last = prev;
            entry.setNext(null);
            entry.setPrevious(null);
            return;
        }
        MapEntry previous = entry.getPrevious();
        MapEntry next = entry.getNext();
        previous.setNext(next);
        next.setPrevious(previous);
        entry.setNext(null);
        entry.setPrevious(null);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public int getMaximumSize() {
        return this.cacheSize;
    }

    public void validate() {
        if (this.first == null) {
            return;
        }
        if (this.first.getPrevious() != null) {
            throw new IllegalStateException();
        }
        if (this.last.getNext() != null) {
            throw new IllegalStateException();
        }
        int counter = 0;
        MapEntry p = null;
        MapEntry e = this.first;
        while (e != null) {
            if (e.getPrevious() != p) {
                throw new IllegalStateException();
            }
            p = e;
            e = e.getNext();
            ++counter;
        }
        if (counter != this.size()) {
            throw new IllegalStateException();
        }
        counter = 0;
        MapEntry n = null;
        e = this.last;
        while (e != null) {
            if (e.getNext() != n) {
                throw new IllegalStateException();
            }
            n = e;
            e = e.getPrevious();
            ++counter;
        }
        if (n != this.first) {
            throw new IllegalStateException();
        }
        if (counter != this.size()) {
            throw new IllegalStateException();
        }
        if (this.size() > this.cacheSize) {
            throw new IllegalStateException();
        }
    }

    private static class MapEntry {
        private Object key;
        private Object value;
        private MapEntry previous;
        private MapEntry next;

        protected MapEntry(Object key, Object value) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                throw new NullPointerException();
            }
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public MapEntry getPrevious() {
            return this.previous;
        }

        public void setPrevious(MapEntry previous) {
            this.previous = previous;
        }

        public MapEntry getNext() {
            return this.next;
        }

        public void setNext(MapEntry next) {
            this.next = next;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value = value;
        }
    }
}

