/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ClassQueryTool {
    private static final Log logger = LogFactory.getLog((Class)(class$org$pentaho$reporting$libraries$base$util$ClassQueryTool == null ? (class$org$pentaho$reporting$libraries$base$util$ClassQueryTool = ClassQueryTool.class$("org.pentaho.reporting.libraries.base.util.ClassQueryTool")) : class$org$pentaho$reporting$libraries$base$util$ClassQueryTool));
    static /* synthetic */ Class class$org$pentaho$reporting$libraries$base$util$ClassQueryTool;

    protected ClassQueryTool() {
    }

    protected void processEntry(ClassLoader classLoader, String entryName) {
        if (entryName == null) {
            throw new NullPointerException();
        }
        if (classLoader == null) {
            throw new NullPointerException();
        }
        if (!entryName.endsWith(".class")) {
            return;
        }
        String className = entryName.substring(0, entryName.length() - 6).replace('/', '.');
        if (!this.isValidClass(className)) {
            return;
        }
        try {
            Class<?> c = classLoader.loadClass(className);
            this.processClass(classLoader, c);
        }
        catch (NoClassDefFoundError ndef) {
        }
        catch (Throwable e) {
            logger.debug((Object)("At class '" + className + "': " + e));
        }
    }

    protected boolean isValidClass(String className) {
        return true;
    }

    protected abstract void processClass(ClassLoader var1, Class var2);

    private void processJarFile(ClassLoader classLoader, URL jarFile) {
        try {
            ZipEntry ze;
            ZipInputStream zf = new ZipInputStream(jarFile.openStream());
            while ((ze = zf.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                this.processEntry(classLoader, ze.getName());
            }
            zf.close();
        }
        catch (IOException e1) {
            logger.debug((Object)("Caught IO-Exception while processing file " + jarFile));
        }
    }

    public void processDirectory(File directory) throws IOException {
        URLClassLoader classLoader;
        URL url;
        int i;
        String fileName;
        File file;
        ArrayList<URL> allURLs = new ArrayList<URL>();
        ArrayList<URL> jarURLs = new ArrayList<URL>();
        ArrayList<File> directoryURLs = new ArrayList<File>();
        String classpath = System.getProperty("java.class.path");
        String pathSeparator = System.getProperty("path.separator");
        StringTokenizer tokenizer = new StringTokenizer(classpath, pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String pathElement = tokenizer.nextToken();
            File directoryOrJar = new File(pathElement);
            file = directoryOrJar.getAbsoluteFile();
            if (file.isDirectory() && file.exists() && file.canRead()) {
                allURLs.add(file.toURL());
                directoryURLs.add(file);
                continue;
            }
            if (!file.isFile() || !file.exists() || !file.canRead() || !(fileName = file.getName()).endsWith(".jar") && !fileName.endsWith(".zip")) continue;
            allURLs.add(file.toURL());
            jarURLs.add(file.toURL());
        }
        if (directory != null && directory.isDirectory()) {
            File[] driverFiles = directory.listFiles();
            for (int i2 = 0; i2 < driverFiles.length; ++i2) {
                file = driverFiles[i2];
                if (file.isDirectory() && file.exists() && file.canRead()) {
                    allURLs.add(file.toURL());
                    directoryURLs.add(file);
                    continue;
                }
                if (!file.isFile() || !file.exists() || !file.canRead() || !(fileName = file.getName()).endsWith(".jar") && !fileName.endsWith(".zip")) continue;
                allURLs.add(file.toURL());
                jarURLs.add(file.toURL());
            }
        }
        URL[] urlsArray = jarURLs.toArray(new URL[jarURLs.size()]);
        File[] dirsArray = directoryURLs.toArray(new File[directoryURLs.size()]);
        URL[] allArray = allURLs.toArray(new URL[allURLs.size()]);
        for (i = 0; i < allArray.length; ++i) {
            url = allArray[i];
            logger.debug((Object)url);
        }
        for (i = 0; i < urlsArray.length; ++i) {
            url = urlsArray[i];
            classLoader = new URLClassLoader(allArray);
            this.processJarFile(classLoader, url);
        }
        for (i = 0; i < dirsArray.length; ++i) {
            File file2 = dirsArray[i];
            classLoader = new URLClassLoader(allArray);
            this.processDirectory(classLoader, file2, "");
        }
    }

    private void processDirectory(URLClassLoader classLoader, File file, String pathPrefix) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File subFile = files[i];
            if (!subFile.exists() || !subFile.canRead()) continue;
            if (subFile.isDirectory()) {
                this.processDirectory(classLoader, subFile, pathPrefix + subFile.getName() + '/');
                continue;
            }
            if (!subFile.isFile()) continue;
            this.processEntry(classLoader, pathPrefix + subFile.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

