/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * loopback.h
 * Copyright (C) 2008-2012 Red Hat, Inc. All rights reserved.
 * 
 * Authors:
 *   Akira TAGOH  <tagoh@redhat.com>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301  USA
 */
#ifndef __LOOPBACK_H__
#define __LOOPBACK_H__

#include <glib.h>
#include <glib-object.h>
#include <libgxim/gximsrvconn.h>
#include <libgxim/gximsrvtmpl.h>
#include "compose.h"

G_BEGIN_DECLS

#define XIM_TYPE_LOOPBACK		(xim_loopback_get_type())
#define XIM_LOOPBACK(_o_)		(G_TYPE_CHECK_INSTANCE_CAST ((_o_), XIM_TYPE_LOOPBACK, XimLoopback))
#define XIM_LOOPBACK_CLASS(_c_)		(G_TYPE_CHECK_CLASS_CAST ((_o_), XIM_TYPE_LOOPBACK, XimLoopbackClass))
#define XIM_IS_LOOPBACK(_o_)		(G_TYPE_CHECK_INSTANCE_TYPE ((_o_), XIM_TYPE_LOOPBACK))
#define XIM_IS_LOOPBACK_CLASS(_o_)	(G_TYPE_CHECK_CLASS_TYPE ((_o_), XIM_TYPE_LOOPBACK))
#define XIM_LOOPBACK_GET_CLASS(_o_)	(G_TYPE_INSTANCE_GET_CLASS ((_o_), XIM_TYPE_LOOPBACK, XimLoopbackClass))

#define XIM_TYPE_LOOPBACK_CONNECTION		(xim_loopback_connection_get_type())
#define XIM_LOOPBACK_CONNECTION(_o_)		(G_TYPE_CHECK_INSTANCE_CAST ((_o_), XIM_TYPE_LOOPBACK_CONNECTION, XimLoopbackConnection))
#define XIM_LOOPBACK_CONNECTION_CLASS(_c_)	(G_TYPE_CHECK_CLASS_CAST ((_o_), XIM_TYPE_LOOPBACK_CONNECTION, XimLoopbackConnectionClass))
#define XIM_IS_LOOPBACK_CONNECTION(_o_)		(G_TYPE_CHECK_INSTANCE_TYPE ((_o_), XIM_TYPE_LOOPBACK_CONNECTION))
#define XIM_IS_LOOPBACK_CONNECTION_CLASS(_o_)	(G_TYPE_CHECK_CLASS_TYPE ((_o_), XIM_TYPE_LOOPBACK_CONNECTION))
#define XIM_LOOPBACK_CONNECTION_GET_CLASS(_o_)	(G_TYPE_INSTANCE_GET_CLASS ((_o_), XIM_TYPE_LOOPBACK_CONNECTION, XimLoopbackConnectionClass))


typedef struct _XimLoopbackClass	XimLoopbackClass;
typedef struct _XimLoopback		XimLoopback;

typedef struct _XimLoopbackConnectionClass	XimLoopbackConnectionClass;
typedef struct _XimLoopbackConnection		XimLoopbackConnection;
typedef struct _XimLoopbackIC			XimLoopbackIC;

struct _XimLoopbackClass {
	GXimServerTemplateClass  parent_class;
};

struct _XimLoopback {
	GXimServerTemplate  parent_instance;

	GHashTable         *conn_table;
	guint               latest_imid;
	gboolean            sync_on_forward;
};

struct _XimLoopbackConnectionClass {
	GXimServerConnectionClass  parent_class;
};

struct _XimLoopbackConnection {
	GXimServerConnection  parent_instance;
	Compose              *composer;
	GHashTable           *ic_table;
	guint                 latest_icid;
};

struct _XimLoopbackIC {
	Sequence   *sequence_state;
	GXimICAttr *icattr;
	GQueue     *keyeventq;
	gboolean    wait_for_reply;
	gboolean    resend;
};

GType        xim_loopback_get_type(void) G_GNUC_CONST;
XimLoopback *xim_loopback_new     (GdkDisplay *dpy);

GType xim_loopback_connection_get_type(void) G_GNUC_CONST;


G_END_DECLS

#endif /* __LOOPBACK_H__ */
