/*
 * IIIMF-SKK, Japanese Language Engine for
 *                        IIIMF (Internet/Intranet Input Method Framework)
 *
 * Copyright (C) 2003 Motonobu Ichimura <famao@momonga-linux.org>
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */
                                                                                                          
/* $Id: wmutil.h,v 1.1.2.1 2003/08/01 13:47:54 famao Exp $ */
                                                                                                          
/* vi:set ts=4 sw=4: */

#ifndef HAVE_WMUTIL_H
#define HAVE_WMUTIL_H

#include <gtk/gtk.h>
#include <gdk/gdkx.h>

/* EWMH */
#define _NET_WM_STATE_REMOVE 0
#define _NEW_WM_STATE_ADD 1
#define _NEW_WM_STATE_TOGGLE 2

void wmutil_window_type_ewmh (GdkWindow *window, GdkAtom *types, guint num, GdkPropMode mode);
void wmutil_window_state_ewmh_client_message (GdkWindow *state, GdkAtom atom1, GdkAtom atom2);
void wmutil_window_state_ewmh_prop (GdkWindow *state, GdkAtom *atoms, guint num, GdkPropMode mode);
void wmutil_window_current_desktop (GdkWindow *window, gint *cur_desktop);
void wmutil_window_workarea_ewmh (GdkWindow *window, gint *x, gint *y, gint *width, gint *height);
void wmutil_window_desktop_ewmh_prop (GdkWindow *window, gulong desktop);
void wmutil_window_desktop_ewmh_client_message (GdkWindow *window, gulong desktop);

/* GNOME */
#define WIN_STATE_STICKY (1 << 0)
#define WIN_STATE_MINIMIZED (1 << 1)
#define WIN_STATE_MAXIMIZED_VERT (1 << 2)
#define WIN_STATE_MAXIMIZED_HORIZ (1 << 3)
#define WIN_STATE_HIDDEN (1 << 4)
#define WIN_STATE_SHADED (1 << 5)
#define WIN_STATE_HID_WORKSPACE (1 << 6)
#define WIN_STATE_HID_TRANSIEND (1 << 7)
#define WIN_STATE_FIXED_POSITION (1 << 8)
#define WIN_STATE_ARRANGE_IGNORE (1 << 9)

#define WIN_HINTS_SKIP_FOCUS (1 << 0)
#define WIN_HINTS_SKIP_WINLIST (1 << 1)
#define WIN_HINTS_SKIP_TASKBAR (1 << 2)
#define WIN_HINTS_GROUP_TRANSIENT (1 << 3)
#define WIN_HINTS_FOCUS_ON_CLICK (1 << 4)

#define WIN_LAYER_DESKTOP 0
#define WIN_LAYER_BELOW   2
#define WIN_LAYER_NORMAL  4
#define WIN_LAYER_ONTOP   6
#define WIN_LAYER_DOCK    8
#define WIN_LAYER_ABOVE_DOCK 10
#define WIN_LAYER_MENU   12

void wmutil_window_state_gnome (GdkWindow *state, long state_flags);
void wmutil_window_hints_gnome (GdkWindow *hints, long hints_flags);
void wmutil_window_layer_gnome (GdkWindow *layer, long stack);

/* KDE */
void wmutil_window_tray_kde (GdkWindow* tray_win, GdkWindow *transient_for);

/* ICEWM */
#define ICEWM_TRAY_IGNORE 0
#define ICEWM_TRAY_MINIMIZED 1
#define ICEWM_TRAY_EXCLUSIVE 2

void wmutil_window_tray_icewm (GdkWindow *window, gint state);

/* System Tray */
#define SYSTEM_TRAY_REQUEST_DOCK 0
#define SYSTEM_TRAY_BEGIN_MESSAGE 1
#define SYSTEM_TRAY_CANCEL_MESSAGE 2

/* XEmbed */
#define XEMBED_MAPPED (1 << 0)

#define XEMBED_EMBEDDED_NOTIFY 0
#define XEMBED_WINDOW_ACTIVATE 1
#define XEMBED_WINDOW_DEACTIVATE 2
#define XEMBED_WINDOW_REQUEST_FOCUS 3
#define XEMBED_WINDOW_FOCUS_IN 4
#define XEMBED_WINDOW_FOCUS_OUT 5
#define XEMBED_WINDOW_FOCUS_NEXT 6
#define XEMBED_WINDOW_FOCUS_PREV 7
#define XEMBED_MODALITY_ON 10
#define XEMBED_MODALITY_OFF 11
#define XEMBED_REGISTER_ACCELERATOR 12
#define XEMBED_ACTIVATE_ACCELERATOR 13

#define XEMBED_FOCUS_CURRENT 0
#define XEMBED_FOCUS_FIRST 1
#define XEMBED_FOCUS_LAST 2

void wmutil_window_tray_xembed (GdkWindow *window);
void wmutil_window_tray_spec (GdkWindow *window);
void wmutil_window_tray_baloon (GdkWindow *window, const gchar *message, guint length);
void wmutil_window_tray_baloon_start (GdkWindow *window, guint length, guint id);
void wmutil_window_tray_baloon_cancel (GdkWindow *window, guint id);

/* ICCCM */
void wmutil_window_input_icccm (GdkWindow *window, gboolean flag);
void wmutil_window_hints_icccm (GdkWindow *window, gint state);

/* Check WM */
#define WM_IS_UNKNOWN 0
#define WM_IS_EWMH (1 << 0)
#define WM_IS_BLACKBOX (1 << 1)
#define WM_IS_KWIN (1 << 2)
#define WM_IS_GNOME (1 << 3)
#define WM_IS_WMAKER (1 << 4)
#define WM_IS_ICEWM (1 << 5)
#define WM_CAN_TRAY (1 << 6)
#define WM_CAN_TRAY_SPEC (1 << 7)

gint wmutil_window_check_wm_type (void);


Window wmutil_window_get_toplevel (Display *d, Window w);

#endif
