/* ibusdrawing.c generated by valac 0.14.0, the Vala compiler
 * generated from ibusdrawing.vala, do not modify */

/* 
 * Copyright (C) 2011 Daiki Ueno <ueno@unixuser.org>
 * Copyright (C) 2011 Red Hat, Inc.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <ibus/ibuspanelextensions.h>
#include <stdlib.h>


#define IBUS_TYPE_IDRAWING (ibus_idrawing_get_type ())
#define IBUS_IDRAWING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_TYPE_IDRAWING, IBusIDrawing))
#define IBUS_IS_IDRAWING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_TYPE_IDRAWING))
#define IBUS_IDRAWING_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), IBUS_TYPE_IDRAWING, IBusIDrawingIface))

typedef struct _IBusIDrawing IBusIDrawing;
typedef struct _IBusIDrawingIface IBusIDrawingIface;

#define IBUS_TYPE_IDRAWING_PROXY (ibus_idrawing_proxy_get_type ())
typedef GDBusProxy IBusIDrawingProxy;
typedef GDBusProxyClass IBusIDrawingProxyClass;

#define IBUS_TYPE_DRAWING (ibus_drawing_get_type ())
#define IBUS_DRAWING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_TYPE_DRAWING, IBusDrawing))
#define IBUS_DRAWING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_TYPE_DRAWING, IBusDrawingClass))
#define IBUS_IS_DRAWING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_TYPE_DRAWING))
#define IBUS_IS_DRAWING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_TYPE_DRAWING))
#define IBUS_DRAWING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_TYPE_DRAWING, IBusDrawingClass))

typedef struct _IBusDrawing IBusDrawing;
typedef struct _IBusDrawingClass IBusDrawingClass;
typedef struct _IBusDrawingPrivate IBusDrawingPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IBusIDrawingIface {
	GTypeInterface parent_iface;
	void (*show) (IBusIDrawing* self, GError** error);
	void (*hide) (IBusIDrawing* self, GError** error);
	void (*set_cursor_location) (IBusIDrawing* self, gint x, gint y, gint w, gint h, GError** error);
};

struct _IBusDrawing {
	IBusPanelExtension parent_instance;
	IBusDrawingPrivate * priv;
};

struct _IBusDrawingClass {
	IBusPanelExtensionClass parent_class;
};

struct _IBusDrawingPrivate {
	gboolean _visible;
	IBusIDrawing* proxy;
};


static gpointer ibus_drawing_parent_class = NULL;

GType ibus_idrawing_proxy_get_type (void) G_GNUC_CONST;
guint ibus_idrawing_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType ibus_idrawing_get_type (void) G_GNUC_CONST;
void ibus_idrawing_show (IBusIDrawing* self, GError** error);
void ibus_idrawing_hide (IBusIDrawing* self, GError** error);
void ibus_idrawing_set_cursor_location (IBusIDrawing* self, gint x, gint y, gint w, gint h, GError** error);
static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void ibus_idrawing_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_ibus_idrawing_stroke_added (IBusIDrawing* self, GVariant* parameters);
static void _dbus_handle_ibus_idrawing_stroke_removed (IBusIDrawing* self, GVariant* parameters);
static void ibus_idrawing_proxy_show (IBusIDrawing* self, GError** error);
static void ibus_idrawing_proxy_hide (IBusIDrawing* self, GError** error);
static void ibus_idrawing_proxy_set_cursor_location (IBusIDrawing* self, gint x, gint y, gint w, gint h, GError** error);
static void ibus_idrawing_proxy_ibus_idrawing_interface_init (IBusIDrawingIface* iface);
static void _dbus_ibus_idrawing_show (IBusIDrawing* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_idrawing_hide (IBusIDrawing* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_ibus_idrawing_set_cursor_location (IBusIDrawing* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void ibus_idrawing_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* ibus_idrawing_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean ibus_idrawing_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_ibus_idrawing_stroke_added (GObject* _sender, gdouble* coordinates, int coordinates_length1, gpointer* _data);
static void _dbus_ibus_idrawing_stroke_removed (GObject* _sender, guint n_strokes, gpointer* _data);
static void _ibus_idrawing_unregister_object (gpointer user_data);
GType ibus_drawing_get_type (void) G_GNUC_CONST;
#define IBUS_DRAWING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_TYPE_DRAWING, IBusDrawingPrivate))
enum  {
	IBUS_DRAWING_DUMMY_PROPERTY,
	IBUS_DRAWING_VISIBLE
};
IBusDrawing* ibus_drawing_new (GDBusConnection* conn, GError** error);
IBusDrawing* ibus_drawing_construct (GType object_type, GDBusConnection* conn, GError** error);
static void __lambda0_ (IBusDrawing* self, GVariant* c, gchar** i, int i_length1);
static void ibus_drawing_set_visible (IBusDrawing* self, gboolean value);
static void ___lambda0__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void ibus_drawing_real_show (IBusPanelExtension* base);
static void ibus_drawing_real_hide (IBusPanelExtension* base);
static void ibus_drawing_real_set_cursor_location (IBusPanelExtension* base, gint x, gint y, gint w, gint h);
gboolean ibus_drawing_get_visible (IBusDrawing* self);
static void ibus_drawing_finalize (GObject* obj);
static void _vala_ibus_drawing_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_ibus_drawing_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_show_in[] = {NULL};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_show_out[] = {NULL};
static const GDBusMethodInfo _ibus_idrawing_dbus_method_info_show = {-1, "Show", (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_show_in), (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_show_out)};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_hide_in[] = {NULL};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_hide_out[] = {NULL};
static const GDBusMethodInfo _ibus_idrawing_dbus_method_info_hide = {-1, "Hide", (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_hide_in), (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_hide_out)};
static const GDBusArgInfo _ibus_idrawing_dbus_arg_info_set_cursor_location_x = {-1, "x", "i"};
static const GDBusArgInfo _ibus_idrawing_dbus_arg_info_set_cursor_location_y = {-1, "y", "i"};
static const GDBusArgInfo _ibus_idrawing_dbus_arg_info_set_cursor_location_w = {-1, "w", "i"};
static const GDBusArgInfo _ibus_idrawing_dbus_arg_info_set_cursor_location_h = {-1, "h", "i"};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_set_cursor_location_in[] = {&_ibus_idrawing_dbus_arg_info_set_cursor_location_x, &_ibus_idrawing_dbus_arg_info_set_cursor_location_y, &_ibus_idrawing_dbus_arg_info_set_cursor_location_w, &_ibus_idrawing_dbus_arg_info_set_cursor_location_h, NULL};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_set_cursor_location_out[] = {NULL};
static const GDBusMethodInfo _ibus_idrawing_dbus_method_info_set_cursor_location = {-1, "SetCursorLocation", (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_set_cursor_location_in), (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_set_cursor_location_out)};
static const GDBusMethodInfo * const _ibus_idrawing_dbus_method_info[] = {&_ibus_idrawing_dbus_method_info_show, &_ibus_idrawing_dbus_method_info_hide, &_ibus_idrawing_dbus_method_info_set_cursor_location, NULL};
static const GDBusArgInfo _ibus_idrawing_dbus_arg_info_stroke_added_coordinates = {-1, "coordinates", "ad"};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_stroke_added[] = {&_ibus_idrawing_dbus_arg_info_stroke_added_coordinates, NULL};
static const GDBusSignalInfo _ibus_idrawing_dbus_signal_info_stroke_added = {-1, "StrokeAdded", (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_stroke_added)};
static const GDBusArgInfo _ibus_idrawing_dbus_arg_info_stroke_removed_n_strokes = {-1, "n_strokes", "u"};
static const GDBusArgInfo * const _ibus_idrawing_dbus_arg_info_stroke_removed[] = {&_ibus_idrawing_dbus_arg_info_stroke_removed_n_strokes, NULL};
static const GDBusSignalInfo _ibus_idrawing_dbus_signal_info_stroke_removed = {-1, "StrokeRemoved", (GDBusArgInfo **) (&_ibus_idrawing_dbus_arg_info_stroke_removed)};
static const GDBusSignalInfo * const _ibus_idrawing_dbus_signal_info[] = {&_ibus_idrawing_dbus_signal_info_stroke_added, &_ibus_idrawing_dbus_signal_info_stroke_removed, NULL};
static const GDBusPropertyInfo * const _ibus_idrawing_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _ibus_idrawing_dbus_interface_info = {-1, "org.freedesktop.IBus.Drawing", (GDBusMethodInfo **) (&_ibus_idrawing_dbus_method_info), (GDBusSignalInfo **) (&_ibus_idrawing_dbus_signal_info), (GDBusPropertyInfo **) (&_ibus_idrawing_dbus_property_info)};
static const GDBusInterfaceVTable _ibus_idrawing_dbus_interface_vtable = {ibus_idrawing_dbus_interface_method_call, ibus_idrawing_dbus_interface_get_property, ibus_idrawing_dbus_interface_set_property};

void ibus_idrawing_show (IBusIDrawing* self, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IDRAWING_GET_INTERFACE (self)->show (self, error);
}


void ibus_idrawing_hide (IBusIDrawing* self, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IDRAWING_GET_INTERFACE (self)->hide (self, error);
}


void ibus_idrawing_set_cursor_location (IBusIDrawing* self, gint x, gint y, gint w, gint h, GError** error) {
	g_return_if_fail (self != NULL);
	IBUS_IDRAWING_GET_INTERFACE (self)->set_cursor_location (self, x, y, w, h, error);
}


static void g_cclosure_user_marshal_VOID__POINTER_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void ibus_idrawing_base_init (IBusIDrawingIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("stroke_added", IBUS_TYPE_IDRAWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
		g_signal_new ("stroke_removed", IBUS_TYPE_IDRAWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
	}
}


GType ibus_idrawing_get_type (void) {
	static volatile gsize ibus_idrawing_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_idrawing_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusIDrawingIface), (GBaseInitFunc) ibus_idrawing_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType ibus_idrawing_type_id;
		ibus_idrawing_type_id = g_type_register_static (G_TYPE_INTERFACE, "IBusIDrawing", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (ibus_idrawing_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (ibus_idrawing_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) ibus_idrawing_proxy_get_type);
		g_type_set_qdata (ibus_idrawing_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.IBus.Drawing");
		g_type_set_qdata (ibus_idrawing_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) ibus_idrawing_register_object);
		g_once_init_leave (&ibus_idrawing_type_id__volatile, ibus_idrawing_type_id);
	}
	return ibus_idrawing_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (IBusIDrawingProxy, ibus_idrawing_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (IBUS_TYPE_IDRAWING, ibus_idrawing_proxy_ibus_idrawing_interface_init) )
static void ibus_idrawing_proxy_class_init (IBusIDrawingProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = ibus_idrawing_proxy_g_signal;
}


static void _dbus_handle_ibus_idrawing_stroke_added (IBusIDrawing* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gdouble* coordinates = NULL;
	int coordinates_length1;
	GVariant* _tmp0_;
	gdouble* _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	GVariantIter _tmp2_;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	coordinates_length1 = 0;
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp1_ = g_new (gdouble, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	g_variant_iter_init (&_tmp2_, _tmp0_);
	for (; (_tmp3_ = g_variant_iter_next_value (&_tmp2_)) != NULL; _tmp1__length1++) {
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gdouble, _tmp1_, _tmp1__size + 1);
		}
		_tmp1_[_tmp1__length++] = g_variant_get_double (_tmp3_);
		g_variant_unref (_tmp3_);
	}
	coordinates_length1 = _tmp1__length1;
	coordinates = _tmp1_;
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "stroke-added", coordinates, coordinates_length1);
	coordinates = (g_free (coordinates), NULL);
}


static void _dbus_handle_ibus_idrawing_stroke_removed (IBusIDrawing* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint n_strokes = 0U;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	n_strokes = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	g_signal_emit_by_name (self, "stroke-removed", n_strokes);
}


static void ibus_idrawing_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "StrokeAdded") == 0) {
		_dbus_handle_ibus_idrawing_stroke_added ((IBusIDrawing*) proxy, parameters);
	} else if (strcmp (signal_name, "StrokeRemoved") == 0) {
		_dbus_handle_ibus_idrawing_stroke_removed ((IBusIDrawing*) proxy, parameters);
	}
}


static void ibus_idrawing_proxy_init (IBusIDrawingProxy* self) {
}


static void ibus_idrawing_proxy_show (IBusIDrawing* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Drawing", "Show");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_idrawing_proxy_hide (IBusIDrawing* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Drawing", "Hide");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_idrawing_proxy_set_cursor_location (IBusIDrawing* self, gint x, gint y, gint w, gint h, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.IBus.Drawing", "SetCursorLocation");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (x));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (y));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (w));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (h));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void ibus_idrawing_proxy_ibus_idrawing_interface_init (IBusIDrawingIface* iface) {
	iface->show = ibus_idrawing_proxy_show;
	iface->hide = ibus_idrawing_proxy_hide;
	iface->set_cursor_location = ibus_idrawing_proxy_set_cursor_location;
}


static void _dbus_ibus_idrawing_show (IBusIDrawing* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_idrawing_show (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_idrawing_hide (IBusIDrawing* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	ibus_idrawing_hide (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_ibus_idrawing_set_cursor_location (IBusIDrawing* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gint x = 0;
	GVariant* _tmp5_;
	gint y = 0;
	GVariant* _tmp6_;
	gint w = 0;
	GVariant* _tmp7_;
	gint h = 0;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	x = g_variant_get_int32 (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	y = g_variant_get_int32 (_tmp6_);
	g_variant_unref (_tmp6_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	w = g_variant_get_int32 (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	h = g_variant_get_int32 (_tmp8_);
	g_variant_unref (_tmp8_);
	ibus_idrawing_set_cursor_location (self, x, y, w, h, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void ibus_idrawing_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Show") == 0) {
		_dbus_ibus_idrawing_show (object, parameters, invocation);
	} else if (strcmp (method_name, "Hide") == 0) {
		_dbus_ibus_idrawing_hide (object, parameters, invocation);
	} else if (strcmp (method_name, "SetCursorLocation") == 0) {
		_dbus_ibus_idrawing_set_cursor_location (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* ibus_idrawing_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean ibus_idrawing_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_ibus_idrawing_stroke_added (GObject* _sender, gdouble* coordinates, int coordinates_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gdouble* _tmp9_;
	GVariantBuilder _tmp10_;
	int _tmp11_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp9_ = coordinates;
	g_variant_builder_init (&_tmp10_, G_VARIANT_TYPE ("ad"));
	for (_tmp11_ = 0; _tmp11_ < coordinates_length1; _tmp11_++) {
		g_variant_builder_add_value (&_tmp10_, g_variant_new_double (*_tmp9_));
		_tmp9_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp10_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.IBus.Drawing", "StrokeAdded", _arguments, NULL);
}


static void _dbus_ibus_idrawing_stroke_removed (GObject* _sender, guint n_strokes, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (n_strokes));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.IBus.Drawing", "StrokeRemoved", _arguments, NULL);
}


guint ibus_idrawing_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_ibus_idrawing_dbus_interface_info), &_ibus_idrawing_dbus_interface_vtable, data, _ibus_idrawing_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "stroke-added", (GCallback) _dbus_ibus_idrawing_stroke_added, data);
	g_signal_connect (object, "stroke-removed", (GCallback) _dbus_ibus_idrawing_stroke_removed, data);
	return result;
}


static void _ibus_idrawing_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ibus_idrawing_stroke_added, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_ibus_idrawing_stroke_removed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
         * Create a drawing pad instance.
         *
         * @param conn a DBusConnection
         *
         * @return a new Drawing instance
         */
static void __lambda0_ (IBusDrawing* self, GVariant* c, gchar** i, int i_length1) {
	GVariant* _tmp0_;
	const GVariantType* _tmp1_;
	GVariant* _tmp2_ = NULL;
	GVariant* v;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = G_VARIANT_TYPE_BOOLEAN;
	_tmp2_ = g_variant_lookup_value (_tmp0_, "visible", _tmp1_);
	v = _tmp2_;
	_tmp3_ = g_variant_get_boolean (v);
	ibus_drawing_set_visible (self, _tmp3_);
	_g_variant_unref0 (v);
}


static void ___lambda0__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	__lambda0_ (self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}


IBusDrawing* ibus_drawing_construct (GType object_type, GDBusConnection* conn, GError** error) {
	IBusDrawing * self = NULL;
	GDBusConnection* _tmp0_;
	IBusIDrawing* _tmp1_ = NULL;
	IBusIDrawing* _tmp2_;
	IBusIDrawing* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (conn != NULL, NULL);
	self = (IBusDrawing*) ibus_panel_extension_construct (object_type);
	_tmp0_ = conn;
	_tmp1_ = g_initable_new (IBUS_TYPE_IDRAWING_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.IBus.Drawing", "g-connection", _tmp0_, "g-object-path", "/org/freedesktop/IBus/Drawing", "g-interface-name", "org.freedesktop.IBus.Drawing", NULL);
	_tmp2_ = (IBusIDrawing*) _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = _tmp2_;
	_tmp3_ = self->priv->proxy;
	g_signal_connect_object (G_DBUS_PROXY (_tmp3_), "g-properties-changed", (GCallback) ___lambda0__g_dbus_proxy_g_properties_changed, self, 0);
	return self;
}


IBusDrawing* ibus_drawing_new (GDBusConnection* conn, GError** error) {
	return ibus_drawing_construct (IBUS_TYPE_DRAWING, conn, error);
}


/**
         * {@inheritDoc}
         */
static void ibus_drawing_real_show (IBusPanelExtension* base) {
	IBusDrawing * self;
	GError * _inner_error_ = NULL;
	self = (IBusDrawing*) base;
	{
		IBusIDrawing* _tmp0_;
		_tmp0_ = self->priv->proxy;
		ibus_idrawing_show (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("ibusdrawing.vala:69: Error: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * {@inheritDoc}
         */
static void ibus_drawing_real_hide (IBusPanelExtension* base) {
	IBusDrawing * self;
	GError * _inner_error_ = NULL;
	self = (IBusDrawing*) base;
	{
		IBusIDrawing* _tmp0_;
		_tmp0_ = self->priv->proxy;
		ibus_idrawing_hide (_tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch1_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("ibusdrawing.vala:80: Error: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
         * {@inheritDoc}
         */
static void ibus_drawing_real_set_cursor_location (IBusPanelExtension* base, gint x, gint y, gint w, gint h) {
	IBusDrawing * self;
	GError * _inner_error_ = NULL;
	self = (IBusDrawing*) base;
	{
		IBusIDrawing* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp0_ = self->priv->proxy;
		_tmp1_ = x;
		_tmp2_ = y;
		_tmp3_ = w;
		_tmp4_ = h;
		ibus_idrawing_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("ibusdrawing.vala:91: Error: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


gboolean ibus_drawing_get_visible (IBusDrawing* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_visible;
	result = _tmp0_;
	return result;
}


static void ibus_drawing_set_visible (IBusDrawing* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_visible = _tmp0_;
	g_object_notify ((GObject *) self, "visible");
}


static void ibus_drawing_class_init (IBusDrawingClass * klass) {
	ibus_drawing_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusDrawingPrivate));
	IBUS_PANEL_EXTENSION_CLASS (klass)->show = ibus_drawing_real_show;
	IBUS_PANEL_EXTENSION_CLASS (klass)->hide = ibus_drawing_real_hide;
	IBUS_PANEL_EXTENSION_CLASS (klass)->set_cursor_location = ibus_drawing_real_set_cursor_location;
	G_OBJECT_CLASS (klass)->get_property = _vala_ibus_drawing_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ibus_drawing_set_property;
	G_OBJECT_CLASS (klass)->finalize = ibus_drawing_finalize;
	/**
	         * Whether the drawing window is visible.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), IBUS_DRAWING_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	         * Signal emitted each time a stroke is added.
	         *
	         * @param coordinates an array of double (0.0 to 1.0) which
	         * represents a stroke (i.e. [x1, y1, x2, y2, x3, y3, ...]).
	         */
	g_signal_new ("stroke_added", IBUS_TYPE_DRAWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_INT);
	/**
	         * Signal emitted each time a stroke is removed.
	         *
	         * @param n_strokes the number of strokes to be removed.  0 is
	         * passed when all the strokes are removed.
	         */
	g_signal_new ("stroke_removed", IBUS_TYPE_DRAWING, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}


static void ibus_drawing_instance_init (IBusDrawing * self) {
	self->priv = IBUS_DRAWING_GET_PRIVATE (self);
}


static void ibus_drawing_finalize (GObject* obj) {
	IBusDrawing * self;
	self = IBUS_DRAWING (obj);
	ibus_panel_extension_hide ((IBusPanelExtension*) self);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (ibus_drawing_parent_class)->finalize (obj);
}


/**
     * Proxy to access the handwriting pad service.
     */
GType ibus_drawing_get_type (void) {
	static volatile gsize ibus_drawing_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_drawing_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusDrawingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_drawing_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusDrawing), 0, (GInstanceInitFunc) ibus_drawing_instance_init, NULL };
		GType ibus_drawing_type_id;
		ibus_drawing_type_id = g_type_register_static (IBUS_TYPE_PANEL_EXTENSION, "IBusDrawing", &g_define_type_info, 0);
		g_once_init_leave (&ibus_drawing_type_id__volatile, ibus_drawing_type_id);
	}
	return ibus_drawing_type_id__volatile;
}


static void _vala_ibus_drawing_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	IBusDrawing * self;
	self = IBUS_DRAWING (object);
	switch (property_id) {
		case IBUS_DRAWING_VISIBLE:
		g_value_set_boolean (value, ibus_drawing_get_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_ibus_drawing_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	IBusDrawing * self;
	self = IBUS_DRAWING (object);
	switch (property_id) {
		case IBUS_DRAWING_VISIBLE:
		ibus_drawing_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



