/* engine.c generated by valac 0.14.0, the Vala compiler
 * generated from engine.vala, do not modify */

/*
 * Copyright (C) 2011  Daiki Ueno
 * Copyright (C) 2011  Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <ibuscharmap.h>
#include <ibus/ibuspanelextensions.h>
#include <config.h>
#include <gio/gio.h>
#include <stdio.h>


#define IBUS_CHARMAP_TYPE_ENGINE (ibus_charmap_engine_get_type ())
#define IBUS_CHARMAP_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), IBUS_CHARMAP_TYPE_ENGINE, IBusCharmapEngine))
#define IBUS_CHARMAP_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), IBUS_CHARMAP_TYPE_ENGINE, IBusCharmapEngineClass))
#define IBUS_CHARMAP_IS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IBUS_CHARMAP_TYPE_ENGINE))
#define IBUS_CHARMAP_IS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), IBUS_CHARMAP_TYPE_ENGINE))
#define IBUS_CHARMAP_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), IBUS_CHARMAP_TYPE_ENGINE, IBusCharmapEngineClass))

typedef struct _IBusCharmapEngine IBusCharmapEngine;
typedef struct _IBusCharmapEngineClass IBusCharmapEngineClass;
typedef struct _IBusCharmapEnginePrivate IBusCharmapEnginePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define IBUS_CHARMAP_ENGINE_TYPE_MOVE_BINDING (ibus_charmap_engine_move_binding_get_type ())
typedef struct _IBusCharmapEngineMoveBinding IBusCharmapEngineMoveBinding;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _IBusCharmapEngine {
	IBusEngine parent_instance;
	IBusCharmapEnginePrivate * priv;
};

struct _IBusCharmapEngineClass {
	IBusEngineClass parent_class;
};

struct _IBusCharmapEnginePrivate {
	gchar* select_chapter_shortcut;
	gchar* commit_character_shortcut;
	guint max_matches;
	IBusPropList* prop_list;
	GString* preedit;
	IBusCharmap* charmap;
};

struct _IBusCharmapEngineMoveBinding {
	guint keyval;
	guint state;
	IBusMovementStep step;
	gint count;
};


static gpointer ibus_charmap_engine_parent_class = NULL;
extern IBusConfig* ibus_charmap_engine_config;
IBusConfig* ibus_charmap_engine_config = NULL;

GType ibus_charmap_engine_get_type (void) G_GNUC_CONST;
#define IBUS_CHARMAP_ENGINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), IBUS_CHARMAP_TYPE_ENGINE, IBusCharmapEnginePrivate))
enum  {
	IBUS_CHARMAP_ENGINE_DUMMY_PROPERTY
};
static GType ibus_charmap_engine_move_binding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static IBusCharmapEngineMoveBinding* ibus_charmap_engine_move_binding_dup (const IBusCharmapEngineMoveBinding* self);
static void ibus_charmap_engine_move_binding_free (IBusCharmapEngineMoveBinding* self);
static void ibus_charmap_engine_real_enable (IBusEngine* base);
static void ibus_charmap_engine_real_disable (IBusEngine* base);
static void ibus_charmap_engine_real_focus_in (IBusEngine* base);
static void ibus_charmap_engine_real_focus_out (IBusEngine* base);
static void ibus_charmap_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state);
static gboolean ibus_charmap_engine_isascii (guint keyval);
static gboolean ibus_charmap_engine_parse_keystr (IBusCharmapEngine* self, const gchar* keystr, guint* keyval, guint* state);
static void ibus_charmap_engine_move_cursor (IBusCharmapEngine* self, IBusMovementStep step, gint count);
static gboolean ibus_charmap_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state);
static void ibus_charmap_engine_real_set_cursor_location (IBusEngine* base, gint x, gint y, gint w, gint h);
static void ibus_charmap_engine_real_destroy (IBusObject* base);
static void ibus_charmap_engine_on_character_activated (IBusCharmapEngine* self, gunichar uc);
IBusCharmapEngine* ibus_charmap_engine_new (void);
IBusCharmapEngine* ibus_charmap_engine_construct (GType object_type);
static GObject * ibus_charmap_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _ibus_charmap_engine_on_character_activated_ibus_charmap_character_activated (IBusCharmap* _sender, gunichar uc, gpointer self);
static void ibus_charmap_engine_finalize (GObject* obj);

static const IBusCharmapEngineMoveBinding IBUS_CHARMAP_ENGINE_move_bindings[16] = {{(guint) IBUS_Up, (guint) 0, IBUS_MOVEMENT_STEP_DISPLAY_LINES, -1}, {(guint) IBUS_KP_Up, (guint) 0, IBUS_MOVEMENT_STEP_DISPLAY_LINES, -1}, {(guint) IBUS_Down, (guint) 0, IBUS_MOVEMENT_STEP_DISPLAY_LINES, 1}, {(guint) IBUS_KP_Down, (guint) 0, IBUS_MOVEMENT_STEP_DISPLAY_LINES, 1}, {(guint) IBUS_Home, (guint) 0, IBUS_MOVEMENT_STEP_BUFFER_ENDS, -1}, {(guint) IBUS_KP_Home, (guint) 0, IBUS_MOVEMENT_STEP_BUFFER_ENDS, -1}, {(guint) IBUS_End, (guint) 0, IBUS_MOVEMENT_STEP_BUFFER_ENDS, 1}, {(guint) IBUS_KP_End, (guint) 0, IBUS_MOVEMENT_STEP_BUFFER_ENDS, 1}, {(guint) IBUS_Page_Up, (guint) 0, IBUS_MOVEMENT_STEP_PAGES, -1}, {(guint) IBUS_KP_Page_Up, (guint) 0, IBUS_MOVEMENT_STEP_PAGES, -1}, {(guint) IBUS_Page_Down, (guint) 0, IBUS_MOVEMENT_STEP_PAGES, 1}, {(guint) IBUS_KP_Page_Down, (guint) 0, IBUS_MOVEMENT_STEP_PAGES, 1}, {(guint) IBUS_Left, (guint) 0, IBUS_MOVEMENT_STEP_VISUAL_POSITIONS, -1}, {(guint) IBUS_KP_Left, (guint) 0, IBUS_MOVEMENT_STEP_VISUAL_POSITIONS, -1}, {(guint) IBUS_Right, (guint) 0, IBUS_MOVEMENT_STEP_VISUAL_POSITIONS, 1}, {(guint) IBUS_KP_Right, (guint) 0, IBUS_MOVEMENT_STEP_VISUAL_POSITIONS, 1}};

static void ibus_charmap_engine_real_enable (IBusEngine* base) {
	IBusCharmapEngine * self;
	IBusCharmap* _tmp0_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = self->priv->charmap;
	ibus_panel_extension_show ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_charmap_engine_parent_class)->enable (IBUS_ENGINE (self));
}


static void ibus_charmap_engine_real_disable (IBusEngine* base) {
	IBusCharmapEngine * self;
	IBusCharmap* _tmp0_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = self->priv->charmap;
	ibus_panel_extension_hide ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_charmap_engine_parent_class)->disable (IBUS_ENGINE (self));
}


static void ibus_charmap_engine_real_focus_in (IBusEngine* base) {
	IBusCharmapEngine * self;
	IBusPropList* _tmp0_;
	IBusCharmap* _tmp1_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = self->priv->prop_list;
	ibus_engine_register_properties ((IBusEngine*) self, _tmp0_);
	_tmp1_ = self->priv->charmap;
	ibus_panel_extension_show ((IBusPanelExtension*) _tmp1_);
	IBUS_ENGINE_CLASS (ibus_charmap_engine_parent_class)->focus_in (IBUS_ENGINE (self));
}


static void ibus_charmap_engine_real_focus_out (IBusEngine* base) {
	IBusCharmapEngine * self;
	IBusCharmap* _tmp0_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = self->priv->charmap;
	ibus_panel_extension_hide ((IBusPanelExtension*) _tmp0_);
	IBUS_ENGINE_CLASS (ibus_charmap_engine_parent_class)->focus_out (IBUS_ENGINE (self));
}


static void ibus_charmap_engine_real_property_activate (IBusEngine* base, const gchar* prop_name, guint prop_state) {
	IBusCharmapEngine * self;
	const gchar* _tmp0_;
	GError * _inner_error_ = NULL;
	self = (IBusCharmapEngine*) base;
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = prop_name;
	if (g_strcmp0 (_tmp0_, "setup") == 0) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp1_ = g_build_filename (LIBEXECDIR, "ibus-setup-charmap", NULL);
		_tmp2_ = _tmp1_;
		g_spawn_command_line_async (_tmp2_, &_inner_error_);
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean ibus_charmap_engine_isascii (guint keyval) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	guint _tmp1_;
	gboolean _tmp3_;
	_tmp1_ = keyval;
	if (((guint) 0x20) <= _tmp1_) {
		guint _tmp2_;
		_tmp2_ = keyval;
		_tmp0_ = _tmp2_ <= ((guint) 0x7E);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static gboolean ibus_charmap_engine_parse_keystr (IBusCharmapEngine* self, const gchar* keystr, guint* keyval, guint* state) {
	guint _vala_keyval = 0U;
	guint _vala_state = 0U;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	GString* _tmp1_;
	GString* buffer;
	GString* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GString* _tmp9_;
	const gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GString* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GString* _tmp23_;
	const gchar* _tmp24_;
	guint _tmp25_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keystr != NULL, FALSE);
	_tmp0_ = keystr;
	_tmp1_ = g_string_new (_tmp0_);
	buffer = _tmp1_;
	_vala_state = (guint) 0;
	_tmp2_ = buffer;
	_tmp3_ = _tmp2_->str;
	_tmp4_ = g_str_has_prefix (_tmp3_, "Control+");
	if (_tmp4_) {
		guint _tmp5_;
		GString* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp5_ = _vala_state;
		_vala_state = _tmp5_ | IBUS_CONTROL_MASK;
		_tmp6_ = buffer;
		_tmp7_ = strlen ("Control+");
		_tmp8_ = _tmp7_;
		g_string_erase (_tmp6_, (gssize) 0, (gssize) _tmp8_);
	}
	_tmp9_ = buffer;
	_tmp10_ = _tmp9_->str;
	_tmp11_ = g_str_has_prefix (_tmp10_, "Alt+");
	if (_tmp11_) {
		guint _tmp12_;
		GString* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp12_ = _vala_state;
		_vala_state = _tmp12_ | IBUS_MOD1_MASK;
		_tmp13_ = buffer;
		_tmp14_ = strlen ("Alt+");
		_tmp15_ = _tmp14_;
		g_string_erase (_tmp13_, (gssize) 0, (gssize) _tmp15_);
	}
	_tmp16_ = buffer;
	_tmp17_ = _tmp16_->str;
	_tmp18_ = g_str_has_prefix (_tmp17_, "Shift+");
	if (_tmp18_) {
		guint _tmp19_;
		GString* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = _vala_state;
		_vala_state = _tmp19_ | IBUS_SHIFT_MASK;
		_tmp20_ = buffer;
		_tmp21_ = strlen ("Shift+");
		_tmp22_ = _tmp21_;
		g_string_erase (_tmp20_, (gssize) 0, (gssize) _tmp22_);
	}
	_tmp23_ = buffer;
	_tmp24_ = _tmp23_->str;
	_tmp25_ = ibus_keyval_from_name (_tmp24_);
	_vala_keyval = _tmp25_;
	result = TRUE;
	_g_string_free0 (buffer);
	if (keyval) {
		*keyval = _vala_keyval;
	}
	if (state) {
		*state = _vala_state;
	}
	return result;
}


static void ibus_charmap_engine_move_cursor (IBusCharmapEngine* self, IBusMovementStep step, gint count) {
	IBusCharmap* _tmp0_;
	IBusMovementStep _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->charmap;
	_tmp1_ = step;
	_tmp2_ = count;
	ibus_charmap_move_cursor (_tmp0_, _tmp1_, _tmp2_);
}


static gboolean ibus_charmap_engine_real_process_key_event (IBusEngine* base, guint keyval, guint keycode, guint state) {
	IBusCharmapEngine * self;
	gboolean result = FALSE;
	guint shortcut_keyval = 0U;
	guint shortcut_state = 0U;
	guint _tmp0_;
	const gchar* _tmp13_;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	guint _tmp17_;
	guint _tmp18_;
	gboolean _tmp21_;
	const gchar* _tmp23_;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	gboolean _tmp26_ = FALSE;
	guint _tmp27_;
	guint _tmp28_;
	gboolean _tmp31_;
	gboolean _tmp33_ = FALSE;
	guint _tmp34_;
	gboolean _tmp37_;
	GString* _tmp45_;
	gssize _tmp46_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = state;
	if ((IBUS_RELEASE_MASK & _tmp0_) != 0) {
		result = FALSE;
		return result;
	}
	{
		IBusCharmapEngineMoveBinding* binding_collection = NULL;
		gint binding_collection_length1 = 0;
		gint _binding_collection_size_ = 0;
		gint binding_it = 0;
		binding_collection = IBUS_CHARMAP_ENGINE_move_bindings;
		binding_collection_length1 = G_N_ELEMENTS (IBUS_CHARMAP_ENGINE_move_bindings);
		for (binding_it = 0; binding_it < G_N_ELEMENTS (IBUS_CHARMAP_ENGINE_move_bindings); binding_it = binding_it + 1) {
			IBusCharmapEngineMoveBinding binding = {0};
			binding = binding_collection[binding_it];
			{
				gboolean _tmp1_ = FALSE;
				IBusCharmapEngineMoveBinding _tmp2_;
				guint _tmp3_;
				guint _tmp4_;
				gboolean _tmp8_;
				_tmp2_ = binding;
				_tmp3_ = _tmp2_.keyval;
				_tmp4_ = keyval;
				if (_tmp3_ == _tmp4_) {
					IBusCharmapEngineMoveBinding _tmp5_;
					guint _tmp6_;
					guint _tmp7_;
					_tmp5_ = binding;
					_tmp6_ = _tmp5_.state;
					_tmp7_ = state;
					_tmp1_ = _tmp6_ == _tmp7_;
				} else {
					_tmp1_ = FALSE;
				}
				_tmp8_ = _tmp1_;
				if (_tmp8_) {
					IBusCharmapEngineMoveBinding _tmp9_;
					IBusMovementStep _tmp10_;
					IBusCharmapEngineMoveBinding _tmp11_;
					gint _tmp12_;
					_tmp9_ = binding;
					_tmp10_ = _tmp9_.step;
					_tmp11_ = binding;
					_tmp12_ = _tmp11_.count;
					ibus_charmap_engine_move_cursor (self, _tmp10_, _tmp12_);
					result = TRUE;
					return result;
				}
			}
		}
	}
	_tmp13_ = self->priv->commit_character_shortcut;
	ibus_charmap_engine_parse_keystr (self, _tmp13_, &_tmp14_, &_tmp15_);
	shortcut_keyval = _tmp14_;
	shortcut_state = _tmp15_;
	_tmp17_ = keyval;
	_tmp18_ = shortcut_keyval;
	if (_tmp17_ == _tmp18_) {
		guint _tmp19_;
		guint _tmp20_;
		_tmp19_ = state;
		_tmp20_ = shortcut_state;
		_tmp16_ = _tmp19_ == _tmp20_;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp21_ = _tmp16_;
	if (_tmp21_) {
		IBusCharmap* _tmp22_;
		_tmp22_ = self->priv->charmap;
		ibus_charmap_activate_selected (_tmp22_);
		result = TRUE;
		return result;
	}
	_tmp23_ = self->priv->select_chapter_shortcut;
	ibus_charmap_engine_parse_keystr (self, _tmp23_, &_tmp24_, &_tmp25_);
	shortcut_keyval = _tmp24_;
	shortcut_state = _tmp25_;
	_tmp27_ = shortcut_state;
	_tmp28_ = state;
	if ((_tmp27_ & _tmp28_) != ((guint) 0)) {
		guint _tmp29_;
		guint _tmp30_;
		_tmp29_ = keyval;
		_tmp30_ = shortcut_keyval;
		_tmp26_ = _tmp29_ == _tmp30_;
	} else {
		_tmp26_ = FALSE;
	}
	_tmp31_ = _tmp26_;
	if (_tmp31_) {
		IBusCharmap* _tmp32_;
		_tmp32_ = self->priv->charmap;
		ibus_charmap_popup_chapters (_tmp32_);
		result = TRUE;
		return result;
	}
	_tmp34_ = state;
	if (_tmp34_ == ((guint) 0)) {
		guint _tmp35_;
		gboolean _tmp36_ = FALSE;
		_tmp35_ = keyval;
		_tmp36_ = ibus_charmap_engine_isascii (_tmp35_);
		_tmp33_ = _tmp36_;
	} else {
		_tmp33_ = FALSE;
	}
	_tmp37_ = _tmp33_;
	if (_tmp37_) {
		guint _tmp38_;
		gchar c;
		GString* _tmp39_;
		gchar _tmp40_;
		IBusCharmap* _tmp41_;
		GString* _tmp42_;
		const gchar* _tmp43_;
		guint _tmp44_;
		_tmp38_ = keyval;
		c = (gchar) _tmp38_;
		_tmp39_ = self->priv->preedit;
		_tmp40_ = c;
		g_string_append_c (_tmp39_, _tmp40_);
		_tmp41_ = self->priv->charmap;
		_tmp42_ = self->priv->preedit;
		_tmp43_ = _tmp42_->str;
		_tmp44_ = self->priv->max_matches;
		ibus_charmap_start_search (_tmp41_, _tmp43_, _tmp44_);
		result = TRUE;
		return result;
	}
	_tmp45_ = self->priv->preedit;
	_tmp46_ = _tmp45_->len;
	if (_tmp46_ > ((gssize) 0)) {
		guint _tmp47_;
		guint _tmp59_;
		_tmp47_ = keyval;
		if (_tmp47_ == ((guint) IBUS_BackSpace)) {
			GString* _tmp48_;
			GString* _tmp49_;
			gssize _tmp50_;
			GString* _tmp51_;
			gssize _tmp52_;
			_tmp48_ = self->priv->preedit;
			_tmp49_ = self->priv->preedit;
			_tmp50_ = _tmp49_->len;
			g_string_truncate (_tmp48_, (gsize) (_tmp50_ - 1));
			_tmp51_ = self->priv->preedit;
			_tmp52_ = _tmp51_->len;
			if (_tmp52_ == ((gssize) 0)) {
				IBusCharmap* _tmp53_;
				IBusCharmap* _tmp54_;
				_tmp53_ = self->priv->charmap;
				ibus_charmap_cancel_search (_tmp53_);
				_tmp54_ = self->priv->charmap;
				ibus_panel_extension_show ((IBusPanelExtension*) _tmp54_);
			} else {
				IBusCharmap* _tmp55_;
				GString* _tmp56_;
				const gchar* _tmp57_;
				guint _tmp58_;
				_tmp55_ = self->priv->charmap;
				_tmp56_ = self->priv->preedit;
				_tmp57_ = _tmp56_->str;
				_tmp58_ = self->priv->max_matches;
				ibus_charmap_start_search (_tmp55_, _tmp57_, _tmp58_);
			}
			result = TRUE;
			return result;
		}
		_tmp59_ = keyval;
		if (_tmp59_ == ((guint) IBUS_Escape)) {
			GString* _tmp60_;
			IBusCharmap* _tmp61_;
			IBusCharmap* _tmp62_;
			_tmp60_ = self->priv->preedit;
			g_string_erase (_tmp60_, (gssize) 0, (gssize) (-1));
			_tmp61_ = self->priv->charmap;
			ibus_charmap_cancel_search (_tmp61_);
			_tmp62_ = self->priv->charmap;
			ibus_panel_extension_show ((IBusPanelExtension*) _tmp62_);
			result = TRUE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void ibus_charmap_engine_real_set_cursor_location (IBusEngine* base, gint x, gint y, gint w, gint h) {
	IBusCharmapEngine * self;
	IBusCharmap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = self->priv->charmap;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = w;
	_tmp4_ = h;
	ibus_panel_extension_set_cursor_location ((IBusPanelExtension*) _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	_tmp5_ = x;
	_tmp6_ = y;
	_tmp7_ = w;
	_tmp8_ = h;
	IBUS_ENGINE_CLASS (ibus_charmap_engine_parent_class)->set_cursor_location (IBUS_ENGINE (self), _tmp5_, _tmp6_, _tmp7_, _tmp8_);
}


static void ibus_charmap_engine_real_destroy (IBusObject* base) {
	IBusCharmapEngine * self;
	IBusCharmap* _tmp0_;
	self = (IBusCharmapEngine*) base;
	_tmp0_ = self->priv->charmap;
	ibus_panel_extension_hide ((IBusPanelExtension*) _tmp0_);
	IBUS_OBJECT_CLASS (ibus_charmap_engine_parent_class)->destroy ((IBusObject*) IBUS_ENGINE (self));
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* str;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


static void ibus_charmap_engine_on_character_activated (IBusCharmapEngine* self, gunichar uc) {
	gunichar _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = uc;
	if (_tmp0_ > ((gunichar) 0)) {
		gunichar _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		IBusText* _tmp4_;
		IBusText* _tmp5_;
		_tmp1_ = uc;
		_tmp2_ = g_unichar_to_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = ibus_text_new_from_string (_tmp3_);
		_tmp5_ = g_object_ref_sink (_tmp4_);
		ibus_engine_commit_text ((IBusEngine*) self, _tmp5_);
		_g_object_unref0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
}


IBusCharmapEngine* ibus_charmap_engine_construct (GType object_type) {
	IBusCharmapEngine * self = NULL;
	self = (IBusCharmapEngine*) g_object_new (object_type, NULL);
	return self;
}


IBusCharmapEngine* ibus_charmap_engine_new (void) {
	return ibus_charmap_engine_construct (IBUS_CHARMAP_TYPE_ENGINE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _ibus_charmap_engine_on_character_activated_ibus_charmap_character_activated (IBusCharmap* _sender, gunichar uc, gpointer self) {
	ibus_charmap_engine_on_character_activated (self, uc);
}


static GObject * ibus_charmap_engine_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	IBusCharmapEngine * self;
	IBusPropList* _tmp9_;
	IBusPropList* _tmp10_;
	IBusText* _tmp11_;
	IBusText* _tmp12_;
	IBusText* _tmp13_;
	IBusText* _tmp14_;
	IBusPropList* _tmp15_;
	IBusPropList* _tmp16_;
	IBusProperty* _tmp17_;
	IBusProperty* _tmp18_;
	IBusProperty* _tmp19_;
	IBusProperty* prop;
	IBusPropList* _tmp20_;
	IBusProperty* _tmp21_;
	GVariant* value = NULL;
	IBusConfig* _tmp22_;
	GVariant* _tmp23_ = NULL;
	GVariant* _tmp24_;
	IBusConfig* _tmp29_;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_;
	IBusConfig* _tmp36_;
	GVariant* _tmp37_ = NULL;
	GVariant* _tmp38_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (ibus_charmap_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = IBUS_CHARMAP_ENGINE (obj);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* conn;
		GDBusConnection* _tmp2_;
		IBusCharmap* _tmp3_;
		IBusCharmap* _tmp4_;
		IBusCharmap* _tmp5_;
		_tmp0_ = ibus_service_get_connection ((IBusService*) self);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		conn = _tmp1_;
		_tmp2_ = conn;
		_tmp3_ = ibus_charmap_new (_tmp2_, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (conn);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->charmap);
		self->priv->charmap = _tmp4_;
		_tmp5_ = self->priv->charmap;
		g_signal_connect_object (_tmp5_, "character-activated", (GCallback) _ibus_charmap_engine_on_character_activated_ibus_charmap_character_activated, self, 0);
		_g_object_unref0 (conn);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "%s\n", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp9_ = ibus_prop_list_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = _tmp10_;
	_tmp11_ = ibus_text_new_from_string ("Setup");
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_tmp13_ = ibus_text_new_from_string ("Configure Charmap engine");
	_tmp14_ = g_object_ref_sink (_tmp13_);
	_tmp15_ = ibus_prop_list_new ();
	_tmp16_ = g_object_ref_sink (_tmp15_);
	_tmp17_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp12_, "gtk-preferences", _tmp14_, TRUE, TRUE, PROP_STATE_UNCHECKED, _tmp16_);
	_tmp18_ = g_object_ref_sink (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (_tmp14_);
	_g_object_unref0 (_tmp12_);
	prop = _tmp19_;
	_tmp20_ = self->priv->prop_list;
	_tmp21_ = prop;
	ibus_prop_list_append (_tmp20_, _tmp21_);
	_tmp22_ = ibus_charmap_engine_config;
	_tmp23_ = ibus_config_get_value (_tmp22_, "engines/charmap", "selet_chapter_shortcut");
	_g_variant_unref0 (value);
	value = _tmp23_;
	_tmp24_ = value;
	if (_tmp24_ != NULL) {
		GVariant* _tmp25_;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		_tmp25_ = value;
		_tmp26_ = g_variant_get_string (_tmp25_, NULL);
		_tmp27_ = g_strdup (_tmp26_);
		_g_free0 (self->priv->select_chapter_shortcut);
		self->priv->select_chapter_shortcut = _tmp27_;
	} else {
		gchar* _tmp28_;
		_tmp28_ = g_strdup ("Alt+Down");
		_g_free0 (self->priv->select_chapter_shortcut);
		self->priv->select_chapter_shortcut = _tmp28_;
	}
	_tmp29_ = ibus_charmap_engine_config;
	_tmp30_ = ibus_config_get_value (_tmp29_, "engines/charmap", "commit_character_shortcut");
	_g_variant_unref0 (value);
	value = _tmp30_;
	_tmp31_ = value;
	if (_tmp31_ != NULL) {
		GVariant* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		_tmp32_ = value;
		_tmp33_ = g_variant_get_string (_tmp32_, NULL);
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (self->priv->commit_character_shortcut);
		self->priv->commit_character_shortcut = _tmp34_;
	} else {
		gchar* _tmp35_;
		_tmp35_ = g_strdup ("Return");
		_g_free0 (self->priv->commit_character_shortcut);
		self->priv->commit_character_shortcut = _tmp35_;
	}
	_tmp36_ = ibus_charmap_engine_config;
	_tmp37_ = ibus_config_get_value (_tmp36_, "engines/charmap", "max_matches");
	_g_variant_unref0 (value);
	value = _tmp37_;
	_tmp38_ = value;
	if (_tmp38_ != NULL) {
		GVariant* _tmp39_;
		gint32 _tmp40_ = 0;
		_tmp39_ = value;
		_tmp40_ = g_variant_get_int32 (_tmp39_);
		self->priv->max_matches = (guint) _tmp40_;
	} else {
		self->priv->max_matches = (guint) 100;
	}
	_g_variant_unref0 (value);
	_g_object_unref0 (prop);
	return obj;
}


static IBusCharmapEngineMoveBinding* ibus_charmap_engine_move_binding_dup (const IBusCharmapEngineMoveBinding* self) {
	IBusCharmapEngineMoveBinding* dup;
	dup = g_new0 (IBusCharmapEngineMoveBinding, 1);
	memcpy (dup, self, sizeof (IBusCharmapEngineMoveBinding));
	return dup;
}


static void ibus_charmap_engine_move_binding_free (IBusCharmapEngineMoveBinding* self) {
	g_free (self);
}


static GType ibus_charmap_engine_move_binding_get_type (void) {
	static volatile gsize ibus_charmap_engine_move_binding_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_charmap_engine_move_binding_type_id__volatile)) {
		GType ibus_charmap_engine_move_binding_type_id;
		ibus_charmap_engine_move_binding_type_id = g_boxed_type_register_static ("IBusCharmapEngineMoveBinding", (GBoxedCopyFunc) ibus_charmap_engine_move_binding_dup, (GBoxedFreeFunc) ibus_charmap_engine_move_binding_free);
		g_once_init_leave (&ibus_charmap_engine_move_binding_type_id__volatile, ibus_charmap_engine_move_binding_type_id);
	}
	return ibus_charmap_engine_move_binding_type_id__volatile;
}


static void ibus_charmap_engine_class_init (IBusCharmapEngineClass * klass) {
	ibus_charmap_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IBusCharmapEnginePrivate));
	IBUS_ENGINE_CLASS (klass)->enable = ibus_charmap_engine_real_enable;
	IBUS_ENGINE_CLASS (klass)->disable = ibus_charmap_engine_real_disable;
	IBUS_ENGINE_CLASS (klass)->focus_in = ibus_charmap_engine_real_focus_in;
	IBUS_ENGINE_CLASS (klass)->focus_out = ibus_charmap_engine_real_focus_out;
	IBUS_ENGINE_CLASS (klass)->property_activate = ibus_charmap_engine_real_property_activate;
	IBUS_ENGINE_CLASS (klass)->process_key_event = ibus_charmap_engine_real_process_key_event;
	IBUS_ENGINE_CLASS (klass)->set_cursor_location = ibus_charmap_engine_real_set_cursor_location;
	IBUS_OBJECT_CLASS (klass)->destroy = ibus_charmap_engine_real_destroy;
	G_OBJECT_CLASS (klass)->constructor = ibus_charmap_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = ibus_charmap_engine_finalize;
}


static void ibus_charmap_engine_instance_init (IBusCharmapEngine * self) {
	GString* _tmp0_;
	self->priv = IBUS_CHARMAP_ENGINE_GET_PRIVATE (self);
	_tmp0_ = g_string_new ("");
	self->priv->preedit = _tmp0_;
}


static void ibus_charmap_engine_finalize (GObject* obj) {
	IBusCharmapEngine * self;
	self = IBUS_CHARMAP_ENGINE (obj);
	_g_free0 (self->priv->select_chapter_shortcut);
	_g_free0 (self->priv->commit_character_shortcut);
	_g_object_unref0 (self->priv->prop_list);
	_g_string_free0 (self->priv->preedit);
	_g_object_unref0 (self->priv->charmap);
	G_OBJECT_CLASS (ibus_charmap_engine_parent_class)->finalize (obj);
}


GType ibus_charmap_engine_get_type (void) {
	static volatile gsize ibus_charmap_engine_type_id__volatile = 0;
	if (g_once_init_enter (&ibus_charmap_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IBusCharmapEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ibus_charmap_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IBusCharmapEngine), 0, (GInstanceInitFunc) ibus_charmap_engine_instance_init, NULL };
		GType ibus_charmap_engine_type_id;
		ibus_charmap_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "IBusCharmapEngine", &g_define_type_info, 0);
		g_once_init_leave (&ibus_charmap_engine_type_id__volatile, ibus_charmap_engine_type_id);
	}
	return ibus_charmap_engine_type_id__volatile;
}



