
#==============================================================================#
# $Id: property.rb,v 1.3 2004/01/23 05:02:46 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/pie_base/property.rb,v $
#==============================================================================#

require 'grb/chart/base/property'

#==============================================================================#

module GRb

  module Chart

    class PieChartPropertyBase < ChartPropertyBase

      def initialize
        super()
        @stretch = nil
        @edge    = EdgeProperty.new
        @label   = LabelProperty.new
      end

      attr_accessor :stretch
      attr_reader   :edge, :label

      def setup
        super()
      end

      class EdgeProperty

        def initialize
          @visible = nil
          @color   = nil
        end

        attr_accessor :visible, :color

      end # EdgeProperty

      class LabelProperty

        def initialize
          @visible = nil
          @type    = nil
          @font    = FontProperty.new
          @line    = LineProperty.new
        end

        attr_accessor :visible, :type
        attr_reader   :font, :line

        class LineProperty

          def initialize
            @color   = nil
            @length1 = nil
            @length2 = nil
          end

          attr_accessor :color, :length1, :length2

        end # LineProperty

      end # LabelProperty

    end # PieChartPropertyBase

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
