
#==============================================================================#
# $Id: layer.rb,v 1.2 2004/01/23 05:24:11 yuya Exp $
# $Source: /cvsroot/gruby/gruby/lib/grb/chart/base/decorator/layer.rb,v $
#==============================================================================#

require 'grb/chart/base/decorator/plural_base'

#==============================================================================#

module GRb

  module Chart

    class LayerDecorator < PluralDecoratorBase

      def initialize(*children)
        super(*children)
      end

      def draw_child(image, box)
        self.each { |child|
          child.draw(image, box) unless child.nil?
        }
      end
      protected :draw_child

      def <<(child)
        if child.kind_of?(Array)
          child.each { |item| @children << item }
        else
          @children << child
        end
      end

      def dx
        return 0 if self.empty?
        return self.collect { |child| child.dx }.max
      end

      def dy
        return 0 if self.empty?
        return self.collect { |child| child.dy }.max
      end

    end # LayerDecorator

  end # Chart

end # GRb

#==============================================================================#
#==============================================================================#
