/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan.h>
#include <gegl.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define FLEGITA_TYPE_SINK (flegita_sink_get_type ())
#define FLEGITA_SINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_SINK, FlegitaSink))
#define FLEGITA_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_SINK, FlegitaSinkClass))
#define FLEGITA_IS_SINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_SINK))
#define FLEGITA_IS_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_SINK))
#define FLEGITA_SINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_SINK, FlegitaSinkClass))

typedef struct _FlegitaSink FlegitaSink;
typedef struct _FlegitaSinkClass FlegitaSinkClass;
typedef struct _FlegitaSinkPrivate FlegitaSinkPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define FLEGITA_TYPE_OPTION_OUTPUT_FILENAME (flegita_option_output_filename_get_type ())
#define FLEGITA_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilename))
#define FLEGITA_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))

typedef struct _FlegitaOptionOutputFilename FlegitaOptionOutputFilename;
typedef struct _FlegitaOptionOutputFilenameClass FlegitaOptionOutputFilenameClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FlegitaSink {
	GnomeScanSink parent_instance;
	FlegitaSinkPrivate * priv;
};

struct _FlegitaSinkClass {
	GnomeScanSinkClass parent_class;
};

struct _FlegitaSinkPrivate {
	GeglNode* _save;
	char* directory;
	char* basename;
	char* suffix;
	gint count;
};


static gpointer flegita_sink_parent_class = NULL;

GType flegita_sink_get_type (void);
#define FLEGITA_SINK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_SINK, FlegitaSinkPrivate))
enum  {
	FLEGITA_SINK_DUMMY_PROPERTY
};
static gboolean flegita_sink_real_start_image (GnomeScanNode* base);
GType flegita_option_output_filename_get_type (void);
const char* flegita_option_output_filename_get_value (FlegitaOptionOutputFilename* self);
static void flegita_sink_on_output_filename_changed (FlegitaSink* self, FlegitaOptionOutputFilename* option, GParamSpec* pspec);
FlegitaSink* flegita_sink_new (void);
FlegitaSink* flegita_sink_construct (GType object_type);
FlegitaOptionOutputFilename* flegita_option_output_filename_new (const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint);
FlegitaOptionOutputFilename* flegita_option_output_filename_construct (GType object_type, const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint);
void flegita_option_output_filename_install_format (FlegitaOptionOutputFilename* self, GnomeScanFormat* format);
void flegita_option_output_filename_set_value (FlegitaOptionOutputFilename* self, const char* value);
static void _flegita_sink_on_output_filename_changed_g_object_notify (FlegitaOptionOutputFilename* _sender, GParamSpec* pspec, gpointer self);
static GObject * flegita_sink_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void flegita_sink_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static gboolean flegita_sink_real_start_image (GnomeScanNode* base) {
	FlegitaSink * self;
	gboolean result;
	char* filename;
	char* number;
	self = (FlegitaSink*) base;
	filename = g_strdup ("");
	number = NULL;
	{
		gboolean _tmp0_;
		_tmp0_ = TRUE;
		while (TRUE) {
			char* _tmp3_;
			if (!_tmp0_) {
				if (!g_file_test (filename, G_FILE_TEST_EXISTS)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			if (self->priv->count == 0) {
				char* _tmp1_;
				number = (_tmp1_ = g_strdup (""), _g_free0 (number), _tmp1_);
			} else {
				char* _tmp2_;
				number = (_tmp2_ = g_strdup_printf ("-%d", self->priv->count), _g_free0 (number), _tmp2_);
			}
			filename = (_tmp3_ = g_strdup_printf ("%s%c%s%s%s", self->priv->directory, (gint) G_DIR_SEPARATOR, self->priv->basename, number, self->priv->suffix), _g_free0 (filename), _tmp3_);
			self->priv->count++;
		}
	}
	g_debug ("flegita-sink.vala:81: Saving to %s", filename);
	gegl_node_set (self->priv->_save, "path", filename, NULL);
	result = TRUE;
	_g_free0 (filename);
	_g_free0 (number);
	return result;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			goto __finally0;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (glong) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			goto __finally0;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void flegita_sink_on_output_filename_changed (FlegitaSink* self, FlegitaOptionOutputFilename* option, GParamSpec* pspec) {
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	g_return_if_fail (pspec != NULL);
	self->priv->count = 0;
	self->priv->directory = (_tmp0_ = g_path_get_dirname (flegita_option_output_filename_get_value (option)), _g_free0 (self->priv->directory), _tmp0_);
	self->priv->basename = (_tmp1_ = g_path_get_basename (flegita_option_output_filename_get_value (option)), _g_free0 (self->priv->basename), _tmp1_);
	self->priv->suffix = (_tmp2_ = g_strdup (g_utf8_strrchr (self->priv->basename, (gssize) (-1), (gunichar) '.')), _g_free0 (self->priv->suffix), _tmp2_);
	if (self->priv->suffix != NULL) {
		char* _tmp3_;
		self->priv->basename = (_tmp3_ = string_replace (self->priv->basename, self->priv->suffix, ""), _g_free0 (self->priv->basename), _tmp3_);
	}
	_tmp4_ = FALSE;
	_tmp5_ = FALSE;
	if (g_file_test (self->priv->directory, G_FILE_TEST_IS_DIR | G_FILE_TEST_EXISTS)) {
		_tmp5_ = g_utf8_strlen (self->priv->basename, -1) > 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = self->priv->suffix != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gnome_scan_node_update_status ((GnomeScanNode*) self, GNOME_SCAN_STATUS_READY, NULL);
	} else {
		gnome_scan_node_update_status ((GnomeScanNode*) self, GNOME_SCAN_STATUS_UNCONFIGURED, NULL);
	}
}


FlegitaSink* flegita_sink_construct (GType object_type) {
	FlegitaSink * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


FlegitaSink* flegita_sink_new (void) {
	return flegita_sink_construct (FLEGITA_TYPE_SINK);
}


static void _flegita_sink_on_output_filename_changed_g_object_notify (FlegitaOptionOutputFilename* _sender, GParamSpec* pspec, gpointer self) {
	flegita_sink_on_output_filename_changed (self, _sender, pspec);
}


static GObject * flegita_sink_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	FlegitaSinkClass * klass;
	GObjectClass * parent_class;
	FlegitaSink * self;
	klass = FLEGITA_SINK_CLASS (g_type_class_peek (FLEGITA_TYPE_SINK));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = FLEGITA_SINK (obj);
	{
		GnomeScanFormat* format;
		FlegitaOptionOutputFilename* option;
		const char* gettext_package;
		FlegitaOptionOutputFilename* _tmp0_;
		GnomeScanFormat* _tmp5_;
		gint _tmp4__length1;
		char** _tmp4_;
		char** _tmp3_;
		gint _tmp2__length1;
		char** _tmp2_;
		char** _tmp1_;
		char* _tmp6_;
		GeglNode* _tmp7_;
		format = NULL;
		option = NULL;
		gettext_package = GETTEXT_PACKAGE;
		option = (_tmp0_ = flegita_option_output_filename_new ("output-filename", N_ ("Output Filename"), N_ ("Output filename"), GETTEXT_PACKAGE, GNOME_SCAN_OPTION_GROUP_SINK, GNOME_SCAN_OPTION_HINT_PRIMARY), _g_object_unref0 (option), _tmp0_);
		_tmp3_ = NULL;
		_tmp1_ = NULL;
		format = (_tmp5_ = gnome_scan_format_new ("png", N_ ("PNG Picture"), GETTEXT_PACKAGE, "image", (_tmp2_ = (_tmp1_ = g_new0 (char*, 1 + 1), _tmp1_[0] = g_strdup ("image/png"), _tmp1_), _tmp2__length1 = 1, _tmp2_), 1, (_tmp4_ = (_tmp3_ = g_new0 (char*, 1 + 1), _tmp3_[0] = g_strdup ("png"), _tmp3_), _tmp4__length1 = 1, _tmp4_), 1), _g_object_unref0 (format), _tmp5_);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
		flegita_option_output_filename_install_format (option, format);
		gnome_scan_node_install_option ((GnomeScanNode*) self, (GnomeScanOption*) option);
		flegita_option_output_filename_set_value (option, _tmp6_ = g_strdup_printf ("%s%c%s.%s", g_get_user_special_dir (G_USER_DIRECTORY_PICTURES), (gint) G_DIR_SEPARATOR, _ ("Scanned picture"), format->suffixes[0]));
		_g_free0 (_tmp6_);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _flegita_sink_on_output_filename_changed_g_object_notify, self, 0);
		self->priv->_save = (_tmp7_ = gegl_node_new (), _g_object_unref0 (self->priv->_save), _tmp7_);
		gegl_node_set (self->priv->_save, "operation", "gegl:png-save", "compression", 9, "bitdepth", 8, NULL);
		gnome_scan_node_append_node ((GnomeScanNode*) self, self->priv->_save);
		gnome_scan_node_update_status ((GnomeScanNode*) self, GNOME_SCAN_STATUS_READY, NULL);
		_g_object_unref0 (format);
		_g_object_unref0 (option);
	}
	return obj;
}


static void flegita_sink_class_init (FlegitaSinkClass * klass) {
	flegita_sink_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FlegitaSinkPrivate));
	GNOME_SCAN_NODE_CLASS (klass)->start_image = flegita_sink_real_start_image;
	G_OBJECT_CLASS (klass)->constructor = flegita_sink_constructor;
	G_OBJECT_CLASS (klass)->finalize = flegita_sink_finalize;
}


static void flegita_sink_instance_init (FlegitaSink * self) {
	self->priv = FLEGITA_SINK_GET_PRIVATE (self);
	self->priv->count = 0;
}


static void flegita_sink_finalize (GObject* obj) {
	FlegitaSink * self;
	self = FLEGITA_SINK (obj);
	_g_object_unref0 (self->priv->_save);
	_g_free0 (self->priv->directory);
	_g_free0 (self->priv->basename);
	_g_free0 (self->priv->suffix);
	G_OBJECT_CLASS (flegita_sink_parent_class)->finalize (obj);
}


GType flegita_sink_get_type (void) {
	static GType flegita_sink_type_id = 0;
	if (flegita_sink_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (FlegitaSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flegita_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlegitaSink), 0, (GInstanceInitFunc) flegita_sink_instance_init, NULL };
		flegita_sink_type_id = g_type_register_static (GNOME_SCAN_TYPE_SINK, "FlegitaSink", &g_define_type_info, 0);
	}
	return flegita_sink_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




